/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.errors;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.implspi.FileAnnotationsRefresh;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class Utilities {
    private static volatile Pair<FileObject, Reference<ClassPath>> rootCache;

    public static ClassPath getSourceClassPathFor(FileObject file) {
        ClassPath cp;
        Pair<FileObject, Reference<ClassPath>> ce = rootCache;
        if (ce != null && (cp = (ClassPath)((Reference)ce.second()).get()) != null && ((FileObject)ce.first()).equals(cp.findOwnerRoot(file))) {
            return cp;
        }
        for (String sourceCP : PathRecognizerRegistry.getDefault().getSourceIds()) {
            cp = ClassPath.getClassPath((FileObject)file, (String)sourceCP);
            if (cp == null) continue;
            FileObject root = cp.findOwnerRoot(file);
            if (root != null) {
                rootCache = Pair.of((Object)root, new WeakReference<ClassPath>(cp));
            }
            return cp;
        }
        return null;
    }

    public static Iterable<? extends FileObject> findIndexedRootsUnderDirectory(Project p, FileObject bigRoot) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        try {
            Iterable<? extends FileObject> roots = CacheFolder.findRootsWithCacheUnderFolder(bigRoot);
            for (FileObject fileObject : roots) {
                Project curr = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (curr == null || curr.getProjectDirectory() != p.getProjectDirectory() || !PathRegistry.getDefault().getSources().contains(fileObject.toURL())) continue;
                result.add(fileObject);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, null, ex);
        }
        return result;
    }

    public static boolean isBadgesEnabled() {
        return true;
    }

    static void refreshAnnotations(@NonNull Set<URL> toRefresh) {
        Collection refreshables = Lookup.getDefault().lookupAll(FileAnnotationsRefresh.class);
        for (FileAnnotationsRefresh refreshable : refreshables) {
            refreshable.refresh(toRefresh);
        }
    }

    private Utilities() {
    }
}

