/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.PersistentList;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class CCCCompiler
extends AbstractCompiler {
    private static final Logger LOG = Logger.getLogger(CCCCompiler.class.getName());
    private static final String DEV_NULL = "/dev/null";
    private static final String NB69_VERSION_PATTERN = "/var/cache/cnd/remote-includes/";
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private volatile Pair compilerDefinitions;
    private static File emptyFile = null;
    private final Map<String, Pair> particularModel = new HashMap<String, Pair>();

    protected CCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> values) {
        return this.copySystemIncludeDirectoriesImpl(values, true);
    }

    protected final boolean copySystemIncludeDirectories(List<String> values) {
        boolean res = this.copySystemIncludeDirectoriesImpl(values, false);
        if (res && values instanceof CompilerDefinition) {
            this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions.clear();
            this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions.addAll(((CompilerDefinition)values).userAddedDefinitions);
        }
        return res;
    }

    private boolean copySystemIncludeDirectoriesImpl(List<String> values, boolean normalize) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (values.equals(this.compilerDefinitions.systemIncludeDirectoriesList)) {
            return false;
        }
        CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition((Collection<String>)values);
        if (normalize) {
            this.normalizePaths(systemIncludeDirectoriesList);
        }
        systemIncludeDirectoriesList.userAddedDefinitions.addAll(this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions);
        this.compilerDefinitions.systemIncludeDirectoriesList = systemIncludeDirectoriesList;
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> values) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (values.equals(this.compilerDefinitions.systemPreprocessorSymbolsList)) {
            return false;
        }
        CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition((Collection<String>)values);
        systemPreprocessorSymbolsList.userAddedDefinitions.addAll(this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions);
        this.compilerDefinitions.systemPreprocessorSymbolsList = systemPreprocessorSymbolsList;
        return true;
    }

    protected final boolean copySystemPreprocessorSymbols(List<String> values) {
        boolean res = this.setSystemPreprocessorSymbols(values);
        if (res && values instanceof CompilerDefinition) {
            this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions.clear();
            this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions.addAll(((CompilerDefinition)values).userAddedDefinitions);
        }
        return res;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        Pair cur = this.compilerDefinitions;
        if (cur == null) {
            cur = this.resetAndGetSystemProperties();
        }
        return cur.systemPreprocessorSymbolsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSystemPreprocessorSymbols(String flags) {
        if (flags != null && !flags.isEmpty()) {
            Pair particular;
            Map<String, Pair> map = this.particularModel;
            synchronized (map) {
                particular = this.particularModel.get(flags);
                if (particular == null) {
                    MyCallable<Pair> callable = this.getCallable();
                    particular = callable.call(flags);
                    this.particularModel.put(flags, particular);
                    if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                        this.applyUserAddedDefinitions(particular);
                    }
                }
            }
            if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                return this.predefinedMacrosByFlags(particular.systemPreprocessorSymbolsList, flags);
            }
        }
        return this.predefinedMacrosByFlags(this.getSystemPreprocessorSymbols(), flags);
    }

    private void applyUserAddedDefinitions(Pair particular) {
        List<String> systemIncludeDirectories;
        List<String> systemPreprocessorSymbols = this.getSystemPreprocessorSymbols();
        if (systemPreprocessorSymbols instanceof CompilerDefinition) {
            Iterator i$ = ((CompilerDefinition)systemPreprocessorSymbols).userAddedDefinitions.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                CCCCompiler.addUniqueOrReplace(particular.systemPreprocessorSymbolsList, systemPreprocessorSymbols.get(i));
            }
        }
        if ((systemIncludeDirectories = this.getSystemIncludeDirectories()) instanceof CompilerDefinition) {
            Iterator i$ = ((CompilerDefinition)systemIncludeDirectories).userAddedDefinitions.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                CCCCompiler.addUnique(particular.systemIncludeDirectoriesList, systemIncludeDirectories.get(i));
            }
        }
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        Pair cur = this.compilerDefinitions;
        if (cur == null) {
            cur = this.resetAndGetSystemProperties();
        }
        return cur.systemIncludeDirectoriesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSystemIncludeDirectories(String flags) {
        if (flags != null && !flags.isEmpty()) {
            Pair particular;
            Map<String, Pair> map = this.particularModel;
            synchronized (map) {
                particular = this.particularModel.get(flags);
                if (particular == null) {
                    MyCallable<Pair> callable = this.getCallable();
                    particular = callable.call(flags);
                    this.particularModel.put(flags, particular);
                    if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                        this.applyUserAddedDefinitions(particular);
                    }
                }
            }
            if (particular.systemPreprocessorSymbolsList.size() > 6 && particular.exitCode == 0) {
                return particular.systemIncludeDirectoriesList;
            }
        }
        return this.getSystemIncludeDirectories();
    }

    @Override
    public boolean isReady() {
        return this.compilerDefinitions != null;
    }

    @Override
    public void waitReady(boolean reset) {
        if (reset || !this.isReady()) {
            this.resetSystemProperties();
        }
    }

    private Pair resetAndGetSystemProperties() {
        Pair res;
        CndUtils.assertNonUiThread();
        this.compilerDefinitions = res = this.getFreshSystemIncludesAndDefines();
        return res;
    }

    @Override
    public final void resetSystemProperties(boolean lazy) {
        if (lazy) {
            this.compilerDefinitions = null;
        } else {
            this.resetAndGetSystemProperties();
        }
    }

    @Override
    public void loadSettings(Preferences prefs, String prefix) {
        PersistentList<String> oldPreprocSymbolList;
        PersistentList<String> oldIncludeDirList;
        String version = prefs.get("csm.version", "1.0");
        ArrayList<String> includeDirList = new ArrayList<String>();
        ArrayList<Integer> userAddedInclude = new ArrayList<Integer>();
        String includeDirPrefix = prefix + ".systemIncludes";
        int includeDirCount = prefs.getInt(includeDirPrefix + ".count", 0);
        for (int i = 0; i < includeDirCount; ++i) {
            String includeDir = prefs.get(includeDirPrefix + '.' + i, null);
            if (includeDir == null) continue;
            if ("1.1".equals(version)) {
                int index;
                int start;
                if (Utilities.isWindows()) {
                    includeDir = includeDir.replace('\\', '/');
                }
                if ((start = includeDir.indexOf(NB69_VERSION_PATTERN)) > 0 && (index = (includeDir = includeDir.substring(start + NB69_VERSION_PATTERN.length())).indexOf(47)) > 0) {
                    includeDir = includeDir.substring(index);
                }
            }
            includeDirList.add(includeDir);
            String added = prefs.get(includeDirPrefix + ".useradded." + i, null);
            if (!"true".equals(added)) continue;
            userAddedInclude.add(includeDirList.size() - 1);
        }
        if (includeDirList.isEmpty() && (oldIncludeDirList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList")) != null) {
            includeDirList.addAll(oldIncludeDirList);
        }
        this.copySystemIncludeDirectories(includeDirList);
        if (!userAddedInclude.isEmpty()) {
            for (Integer i : userAddedInclude) {
                this.compilerDefinitions.systemIncludeDirectoriesList.setUserAdded(true, i);
            }
        }
        ArrayList<String> preprocSymbolList = new ArrayList<String>();
        ArrayList<Integer> userAddedpreprocSymbol = new ArrayList<Integer>();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        int preprocSymbolCount = prefs.getInt(preprocSymbolPrefix + ".count", 0);
        for (int i = 0; i < preprocSymbolCount; ++i) {
            String preprocSymbol = prefs.get(preprocSymbolPrefix + '.' + i, null);
            if (preprocSymbol == null) continue;
            preprocSymbolList.add(preprocSymbol);
            String added = prefs.get(preprocSymbolPrefix + ".useradded." + i, null);
            if (!"true".equals(added)) continue;
            userAddedpreprocSymbol.add(preprocSymbolList.size() - 1);
        }
        if (preprocSymbolList.isEmpty() && (oldPreprocSymbolList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList")) != null) {
            preprocSymbolList.addAll(oldPreprocSymbolList);
        }
        this.copySystemPreprocessorSymbols(preprocSymbolList);
        if (!userAddedpreprocSymbol.isEmpty()) {
            for (Integer i : userAddedpreprocSymbol) {
                this.compilerDefinitions.systemPreprocessorSymbolsList.setUserAdded(true, i);
            }
        }
    }

    @Override
    public void saveSettings(Preferences prefs, String prefix) {
        List<String> includeDirList = this.getSystemIncludeDirectories();
        String includeDirPrefix = prefix + ".systemIncludes";
        prefs.putInt(includeDirPrefix + ".count", includeDirList.size());
        for (int i = 0; i < includeDirList.size(); ++i) {
            prefs.put(includeDirPrefix + '.' + i, includeDirList.get(i));
            if (!this.compilerDefinitions.systemIncludeDirectoriesList.isUserAdded(i)) continue;
            prefs.put(includeDirPrefix + ".useradded." + i, "true");
        }
        List<String> preprocSymbolList = this.getSystemPreprocessorSymbols();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        prefs.putInt(preprocSymbolPrefix + ".count", preprocSymbolList.size());
        for (int i = 0; i < preprocSymbolList.size(); ++i) {
            prefs.put(preprocSymbolPrefix + '.' + i, preprocSymbolList.get(i));
            if (!this.compilerDefinitions.systemPreprocessorSymbolsList.isUserAdded(i)) continue;
            prefs.put(preprocSymbolPrefix + ".useradded." + i, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getSystemIncludesAndDefines(String arguments, final boolean stdout, Pair pair) throws IOException {
        block19: {
            String compilerPath = this.getPath();
            if (compilerPath == null || compilerPath.length() == 0) {
                return;
            }
            ExecutionEnvironment execEnv = this.getExecutionEnvironment();
            NativeProcess startedProcess = null;
            RequestProcessor.Task errorTask = null;
            try {
                NativeProcess process;
                if (execEnv.isLocal() && Utilities.isWindows()) {
                    compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
                }
                try {
                    if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath) && !HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)(compilerPath = this.getDefaultPath()))) {
                        return;
                    }
                }
                catch (Throwable ex) {
                    return;
                }
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
                argsList.add(this.getEmptyFile(execEnv));
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
                npb.setExecutable(compilerPath);
                npb.setArguments(argsList.toArray(new String[argsList.size()]));
                npb.getEnvironment().prependPathVariable("PATH", ToolUtils.getDirName(compilerPath));
                startedProcess = process = npb.call();
                if (process.getState() == NativeProcess.State.ERROR) break block19;
                InputStream stream = stdout ? process.getInputStream() : process.getErrorStream();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (stdout) {
                                ProcessUtils.readProcessError((Process)process);
                            } else {
                                ProcessUtils.readProcessOutput((Process)process);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                if (stream != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    try {
                        this.parseCompilerOutput(reader, pair);
                    }
                    finally {
                        reader.close();
                    }
                }
                process.waitFor();
                pair.exitCode = process.exitValue();
                startedProcess = null;
                errorTask = null;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
                throw new IOException(ex);
            }
            finally {
                if (errorTask != null) {
                    errorTask.cancel();
                }
                if (startedProcess != null) {
                    startedProcess.destroy();
                }
            }
        }
    }

    protected abstract void parseCompilerOutput(BufferedReader var1, Pair var2);

    protected abstract Pair getFreshSystemIncludesAndDefines();

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getNames().length > 0) {
            return compiler.getNames()[0];
        }
        return "";
    }

    protected boolean containsMacro(List<String> macrosList, String macroToFind) {
        int len = macroToFind.length();
        for (String macro : macrosList) {
            if (!macro.startsWith(macroToFind)) continue;
            if (macro.length() == len) {
                return true;
            }
            if (macro.charAt(len) != '=') continue;
            return true;
        }
        return false;
    }

    static void parseUserMacros(String line, List<String> preprocessorList) {
        List<String> list = CCCCompiler.scanCommandLine(line);
        for (String s : list) {
            String token;
            if ((s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) && s.length() > 2) {
                s = s.substring(1, s.length() - 1).trim();
            }
            if (!s.startsWith("-D") || (token = s.substring(2)).length() <= 0) continue;
            String name = token;
            int i = token.indexOf(61);
            if (i >= 0) {
                name = token.substring(0, i);
            }
            if (!CCCCompiler.isValidMacroName(name)) continue;
            CCCCompiler.addUnique(preprocessorList, token);
        }
    }

    static boolean isValidMacroName(String macroName) {
        boolean par = false;
        for (int i = 0; i < macroName.length(); ++i) {
            char c = macroName.charAt(i);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' && i > 0) continue;
            if (c == '(' && i > 0) {
                if (par) {
                    return false;
                }
                par = true;
                continue;
            }
            if (c == ')') {
                if (!par) {
                    return false;
                }
                return i == macroName.length() - 1;
            }
            if (c == ' ' || c == ',' || c == '.') {
                if (par) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String[] getMacro(String line) {
        int sepIdx = -1;
        int parCount = 0;
        block5: for (int i = 0; i < line.length(); ++i) {
            switch (line.charAt(i)) {
                case '(': {
                    ++parCount;
                    break;
                }
                case ')': {
                    --parCount;
                    break;
                }
                case ' ': {
                    if (parCount != 0) break;
                    sepIdx = i;
                    break block5;
                }
            }
        }
        if (sepIdx > 0) {
            return new String[]{line.substring(0, sepIdx), line.substring(sepIdx + 1).trim()};
        }
        return new String[]{line, null};
    }

    private static List<String> scanCommandLine(String line) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        block5: while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            switch (c) {
                case '\'': {
                    if (isSingleQuoteMode) {
                        isSingleQuoteMode = false;
                    } else if (!isDoubleQuoteMode) {
                        isSingleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\"': {
                    if (isDoubleQuoteMode) {
                        isDoubleQuoteMode = false;
                    } else if (!isSingleQuoteMode) {
                        isDoubleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (isSingleQuoteMode || isDoubleQuoteMode) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    res.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            res.add(current.toString());
        }
        return res;
    }

    private String getEmptyFile(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal() && Utilities.isWindows()) {
            if (emptyFile == null) {
                try {
                    File tmpFile = File.createTempFile("xyz", ".c");
                    tmpFile.deleteOnExit();
                    emptyFile = tmpFile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return emptyFile == null ? DEV_NULL : emptyFile.getAbsolutePath();
        }
        return DEV_NULL;
    }

    protected String getUniqueID() {
        if (this.getCompilerSet() == null || this.getCompilerSet().isAutoGenerated()) {
            return this.getClass().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
        }
        return this.getClass().getName() + this.getCompilerSet().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
    }

    protected static void addUnique(List<String> list, String element) {
        String pattern = element;
        if (element.indexOf(61) > 0) {
            pattern = pattern.substring(0, element.indexOf(61));
        }
        for (String s : list) {
            if (!(s.indexOf(61) > 0 ? pattern.equals(s.substring(0, s.indexOf(61))) : pattern.equals(s))) continue;
            return;
        }
        list.add(element);
    }

    protected static void addUniqueOrReplace(List<String> list, String element) {
        String pattern = element;
        if (element.indexOf(61) > 0) {
            pattern = pattern.substring(0, element.indexOf(61));
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (s.indexOf(61) > 0) {
                if (!pattern.equals(s.substring(0, s.indexOf(61)))) continue;
                list.set(i, element);
                return;
            }
            if (!pattern.equals(s)) continue;
            list.set(i, element);
            return;
        }
        list.add(element);
    }

    protected static void removeUnique(List<String> list, String element) {
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (!s.startsWith(element) || (s.length() <= element.length() || s.charAt(element.length()) != '=') && !s.contains(element)) continue;
            list.remove(i);
            break;
        }
    }

    private List<String> predefinedMacrosByFlags(List<String> macrosList, String flags) {
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor != null && flags != null && !flags.isEmpty() && (predefinedMacros = descriptor.getPredefinedMacros()) != null) {
            ArrayList<String> res = null;
            for (String flag : flags.split(" ")) {
                if (!flag.startsWith("-")) continue;
                for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                    if (!flag.equals(macro.getFlags())) continue;
                    if (res == null) {
                        res = new ArrayList<String>(macrosList);
                    }
                    if (macro.isHidden()) {
                        CCCCompiler.removeUnique(res, macro.getMacro());
                        continue;
                    }
                    CCCCompiler.addUniqueOrReplace(res, macro.getMacro());
                }
            }
            if (res != null) {
                return res;
            }
        }
        return macrosList;
    }

    protected void completePredefinedMacros(Pair pair) {
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor != null && (predefinedMacros = descriptor.getPredefinedMacros()) != null) {
            for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                if (macro.getFlags() != null) continue;
                if (macro.isHidden()) {
                    CCCCompiler.removeUnique(pair.systemPreprocessorSymbolsList, macro.getMacro());
                    continue;
                }
                CCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, macro.getMacro());
            }
        }
    }

    protected void checkModel(Pair res, MyCallable<Pair> get) {
        ArrayList<String> flags;
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        ToolchainManager.CompilerDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return;
        }
        List<ToolchainManager.PredefinedMacro> predefinedMacros = descriptor.getPredefinedMacros();
        if (predefinedMacros == null || predefinedMacros.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Compiler: ").append(this.getPath());
        StringBuilder toolChainPatch = new StringBuilder();
        toolChainPatch.append("Proposed patch for compiler: ").append(this.getPath());
        ArrayList<String> importantFlagsList = new ArrayList<String>();
        StringBuilder importantFlags = new StringBuilder();
        importantFlags.append("Important flags for compiler: ").append(this.getPath()).append("\n");
        HashSet<String> checked = new HashSet<String>();
        ArrayList<String> allFlags = new ArrayList<String>();
        for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
            if (macro.getFlags() == null || checked.contains(macro.getFlags())) continue;
            allFlags.add(macro.getFlags());
            checked.add(macro.getFlags());
        }
        ArrayList<String> undefinedAlternatives = new ArrayList<String>();
        if (this.getPath().endsWith("/g++") || this.getPath().endsWith("/gcc")) {
            flags = new ArrayList<String>();
            this.getCompilerOutput("-v --help", flags, undefinedAlternatives, true);
            for (String flag : flags) {
                if (checked.contains(flag)) continue;
                allFlags.add(flag);
                checked.add(flag);
            }
        } else if (this.getPath().endsWith("/CC") || this.getPath().endsWith("/cc")) {
            flags = new ArrayList();
            this.getCompilerOutput(" -flags", flags, undefinedAlternatives, false);
            for (String flag : flags) {
                if (checked.contains(flag)) continue;
                allFlags.add(flag);
                checked.add(flag);
            }
        }
        Collections.sort(allFlags);
        for (String flag : allFlags) {
            Pair tmp = get.call(flag);
            if (tmp.systemPreprocessorSymbolsList.size() <= 6 || tmp.exitCode != 0) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                buf.append("\nThe flag ").append(flag).append(" is not supported. Exit code " + tmp.exitCode);
                continue;
            }
            FlagModel flagModel = new FlagModel(flag);
            flagModel.diff(res, tmp);
            ArrayList<String> expectedDiff = new ArrayList<String>();
            ArrayList<String> expectedRm = new ArrayList<String>();
            for (ToolchainManager.PredefinedMacro m : predefinedMacros) {
                if (m.getFlags() == null || !m.getFlags().equals(flag)) continue;
                if (m.isHidden()) {
                    expectedRm.add(m.getMacro());
                    continue;
                }
                expectedDiff.add(m.getMacro());
            }
            if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && flagModel.removed.isEmpty())) {
                importantFlags.append(flagModel.flag).append(";");
                importantFlagsList.add(flagModel.flag);
                toolChainPatch.append("\n");
                if (!flagModel.added.isEmpty()) {
                    for (String t : flagModel.added) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\"/>");
                    }
                }
                if (!flagModel.changed.isEmpty()) {
                    for (String t : flagModel.changed) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\"/>");
                    }
                }
                if (!flagModel.removed.isEmpty()) {
                    for (String t : flagModel.removed) {
                        toolChainPatch.append("\n            <macro stringvalue=\"").append(t).append("\" flags=\"").append(flagModel.flag).append("\" hide=\"true\"/>");
                    }
                }
            } else if (flagModel.changedPaths) {
                importantFlags.append(flagModel.flag).append(";");
                importantFlagsList.add(flagModel.flag);
            }
            if (flagModel.changedPaths && LOG.isLoggable(Level.FINER)) {
                buf.append("\nThe flag ").append(flag).append(" changes predefined include paths");
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && expectedDiff.isEmpty() && flagModel.removed.isEmpty() && expectedRm.isEmpty())) {
                buf.append("\nThe flag ").append(flag);
                if (!(flagModel.added.isEmpty() && flagModel.changed.isEmpty() && expectedDiff.isEmpty())) {
                    if (!flagModel.added.isEmpty()) {
                        buf.append("\n\tadds predefined macros:");
                        for (String t : flagModel.added) {
                            buf.append("\n\t\t").append(t);
                        }
                    }
                    if (!flagModel.changed.isEmpty()) {
                        buf.append("\n\tchanges predefined macros:");
                        for (String t : flagModel.changed) {
                            buf.append("\n\t\t").append(t);
                        }
                    }
                    buf.append("\n\tby tool collection descriptor:");
                    for (String t : expectedDiff) {
                        buf.append("\n\t\t").append(t);
                    }
                }
                if (flagModel.removed.isEmpty() && expectedRm.isEmpty()) continue;
                buf.append("\n\tremoves predefined macros:");
                for (String t : flagModel.removed) {
                    buf.append("\n\t\t").append(t);
                }
                buf.append("\n\tby tool collection descriptor:");
                for (String t : expectedRm) {
                    buf.append("\n\t\t").append(t);
                }
                continue;
            }
            buf.append("\nNo changes for flag ").append(flag);
        }
        LOG.log(Level.FINE, buf.toString());
        LOG.log(Level.FINE, toolChainPatch.toString());
        LOG.log(Level.FINE, importantFlags.toString());
        importantFlags.setLength(0);
        importantFlags.append("Important flags pattern for compiler: ").append(this.getPath()).append("\n");
        importantFlags.append("        <important_flags flags=\"").append(CCCCompiler.convertToRegularExpression(importantFlagsList)).append("\"/>\n");
        importantFlags.append("Undefined alternatives:\n");
        for (String s : undefinedAlternatives) {
            importantFlags.append("|" + s + ".*");
        }
        LOG.log(Level.FINE, importantFlags.toString());
    }

    protected static String convertToRegularExpression(List<String> flags) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        String lastGroup = null;
        while (i < flags.size()) {
            String current = flags.get(i);
            int eq = current.indexOf(61);
            if (eq < 0) {
                String next;
                if (lastGroup != null) {
                    if (buf.length() > 0) {
                        buf.append('|');
                    }
                    buf.append(lastGroup).append(".*");
                    lastGroup = null;
                }
                if (buf.length() > 0) {
                    buf.append('|');
                }
                if (i + 1 < flags.size() && (next = flags.get(i + 1)).startsWith(current)) {
                    current = current + "(\\W|$|-)";
                    buf.append(current);
                    ++i;
                    continue;
                }
                buf.append(current);
                ++i;
                continue;
            }
            String candidate = current.substring(0, eq + 1);
            if (lastGroup != null) {
                if (lastGroup.equals(candidate)) {
                    ++i;
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append('|');
                }
                buf.append(lastGroup).append(".*");
            }
            lastGroup = candidate;
            ++i;
        }
        if (lastGroup != null) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(lastGroup).append(".*");
        }
        return buf.toString();
    }

    private void getCompilerOutput(String arguments, List<String> options, List<String> undefinedAlternatives, boolean isGcc) {
        String compilerPath = this.getPath();
        if (compilerPath == null || compilerPath.length() == 0) {
            return;
        }
        ExecutionEnvironment execEnv = this.getExecutionEnvironment();
        if (execEnv.isLocal() && Utilities.isWindows()) {
            compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
        }
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath) && !HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)(compilerPath = this.getDefaultPath()))) {
                return;
            }
        }
        catch (Throwable ex) {
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
        ProcessUtils.ExitStatus execute = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)compilerPath, (String[])argsList.toArray(new String[argsList.size()]));
        if (execute.isOK()) {
            CCCCompiler.discoverFlags(execute.output, options, undefinedAlternatives, isGcc);
        }
    }

    protected static void discoverFlags(String output, List<String> options, List<String> undefinedAlternatives, boolean isGcc) {
        String[] split = output.split("\n");
        for (int index = 0; index < split.length; ++index) {
            String alternative;
            int i$;
            int j;
            String[] splitOption;
            String line = split[index];
            String s = line.trim();
            if (!s.startsWith("-") || s.startsWith("--") || (splitOption = s.split(" ")).length > 1 && splitOption[1].startsWith("<")) continue;
            String option = splitOption[0];
            if (isGcc) {
                if (option.indexOf("<") >= 0) {
                    int i = option.indexOf("<");
                    j = option.indexOf(">");
                    if (j <= i) continue;
                    String alternatives = option.substring(i + 1, j);
                    if (alternatives.indexOf("|") > 0) {
                        String[] splitAlternatives = alternatives.split("\\|");
                        if (splitAlternatives.length <= 1) continue;
                        String[] arr$ = splitAlternatives;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            alternative = arr$[i$];
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    if (!"-O".equals(option.substring(0, i))) continue;
                    for (int n = 0; n < 6; ++n) {
                        options.add(option.substring(0, i) + n);
                    }
                    continue;
                }
                if (option.indexOf("[") >= 0) {
                    int i = option.indexOf("[");
                    j = option.indexOf("]");
                    if (j <= i) continue;
                    String alternatives = option.substring(i + 1, j);
                    String[] splitAlternatives = alternatives.split("\\|");
                    if (splitAlternatives.length > 1) {
                        String[] arr$ = splitAlternatives;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            alternative = arr$[i$];
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    option = option.substring(0, i) + option.substring(j + 1);
                }
                if (option.indexOf("=CPU") > 0 && index + 1 < split.length && (line.indexOf("CPU is one of:") > 0 || index + 1 < split.length && split[index + 1].indexOf("CPU is one of:") > 0)) {
                    ArrayList<String> CPUTypes = new ArrayList<String>();
                    int shift = line.indexOf("CPU is one of:") > 0 ? 1 : 2;
                    int lineNumber = index + shift;
                    while (index < split.length) {
                        String current = split[lineNumber];
                        if ((current = current.trim()).startsWith("-")) break;
                        String[] arr$ = current.split("\\,");
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            String variant = arr$[i$];
                            if ((variant = variant.trim()).isEmpty() || variant.indexOf(" ") >= 0) continue;
                            CPUTypes.add(variant);
                        }
                        if (!current.endsWith(",")) break;
                        ++lineNumber;
                    }
                    if (CPUTypes.size() > 0) {
                        int start = option.indexOf("=CPU");
                        for (String type : CPUTypes) {
                            options.add(option.substring(0, start + 1) + type);
                        }
                        continue;
                    }
                }
                options.add(option);
                continue;
            }
            if ((option = option.replace("[,<a>]", "")).indexOf("<") >= 0) {
                int i = option.indexOf("<");
                j = option.indexOf(">");
                if (j > i) {
                    String subtitute = option.substring(i, j + 1);
                    boolean found = false;
                    for (int k = 1; k < splitOption.length; ++k) {
                        if (!splitOption[k].startsWith(subtitute + "=")) continue;
                        String def = splitOption[k].substring(subtitute.length() + 1);
                        if (def.startsWith("{") && !def.endsWith("}")) {
                            for (int d = k + 1; d < splitOption.length && !(def = def + " " + splitOption[d]).endsWith("}"); ++d) {
                            }
                        }
                        option = option.substring(0, i) + def + option.substring(j + 1);
                        found = true;
                        break;
                    }
                    if (!found && index + 1 < split.length && !split[index + 1].trim().startsWith("-")) {
                        String[] nextLine = split[index + 1].trim().split(" ");
                        for (int k = 0; k < nextLine.length; ++k) {
                            if (!nextLine[k].startsWith(subtitute + "=")) continue;
                            option = option.substring(0, i) + nextLine[k].substring(subtitute.length() + 1) + option.substring(j + 1);
                            found = true;
                            break;
                        }
                    }
                    if (!found && "-O".equals(option.substring(0, i))) {
                        for (int n = 0; n < 6; ++n) {
                            options.add(option.substring(0, i) + n);
                        }
                        continue;
                    }
                }
            }
            if (option.indexOf("[") >= 0) {
                int i = option.indexOf("[");
                j = option.lastIndexOf("]");
                if (j <= i || option.substring(0, i).indexOf("<") >= 0) continue;
                options.add(option.substring(0, i));
                String alternatives = option.substring(i + 1, j);
                if (alternatives.indexOf("{") < 0 && alternatives.indexOf("<") < 0) {
                    if (alternatives.indexOf("|") > 0) {
                        String[] splitAlternatives = alternatives.split("\\|");
                        if (splitAlternatives.length <= 1) continue;
                        String[] arr$ = splitAlternatives;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            alternative = arr$[i$];
                            if (alternative.startsWith("<")) {
                                undefinedAlternatives.add(option.substring(0, i) + alternative);
                                continue;
                            }
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                    if (alternatives.indexOf(",") > 0) {
                        String[] splitAlternatives = alternatives.split(",");
                        if (splitAlternatives.length <= 1) continue;
                        String[] arr$ = splitAlternatives;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            alternative = arr$[i$];
                            if (alternative.startsWith("<")) {
                                undefinedAlternatives.add(option.substring(0, i) + alternative);
                                continue;
                            }
                            options.add(option.substring(0, i) + alternative);
                        }
                        continue;
                    }
                }
                option = option.substring(0, i) + option.substring(i + 1, j);
            }
            if (option.indexOf("{") >= 0) {
                String[] splitAlternatives;
                int i = option.indexOf("{");
                j = option.lastIndexOf("}");
                if (j <= i) continue;
                String alternatives = option.substring(i + 1, j);
                if (alternatives.indexOf("|") > 0) {
                    String[] splitAlternatives2 = alternatives.split("\\|");
                    if (splitAlternatives2.length <= 1) continue;
                    String[] arr$ = splitAlternatives2;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        alternative = arr$[i$];
                        if (alternative.startsWith("<")) {
                            undefinedAlternatives.add(option.substring(0, i) + alternative);
                            continue;
                        }
                        options.add(option.substring(0, i) + alternative);
                    }
                    continue;
                }
                if (alternatives.indexOf(",") <= 0 || (splitAlternatives = alternatives.split(",")).length <= 1) continue;
                String[] arr$ = splitAlternatives;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    alternative = arr$[i$];
                    if (alternative.startsWith("<")) {
                        undefinedAlternatives.add(option.substring(0, i) + alternative);
                        continue;
                    }
                    options.add(option.substring(0, i) + alternative);
                }
                continue;
            }
            if (option.indexOf("[") >= 0) {
                String alternatives;
                String[] splitAlternatives;
                int i = option.indexOf("[");
                j = option.indexOf("]");
                if (j <= i || (splitAlternatives = (alternatives = option.substring(i + 1, j)).split("\\|")).length <= 1) continue;
                String[] arr$ = splitAlternatives;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    alternative = arr$[i$];
                    options.add(option.substring(0, i) + alternative);
                }
                continue;
            }
            if (option.indexOf("<") >= 0) {
                undefinedAlternatives.add(option.substring(0, option.indexOf("<")));
                continue;
            }
            options.add(option);
        }
    }

    protected abstract MyCallable<Pair> getCallable();

    protected static final class FlagModel {
        private final String flag;
        private final List<String> added;
        private final List<String> changed;
        private final List<String> removed;
        private boolean changedPaths;

        private FlagModel(String flag) {
            this.flag = flag;
            this.added = new ArrayList<String>();
            this.changed = new ArrayList<String>();
            this.removed = new ArrayList<String>();
        }

        private boolean isIgnored(String macro) {
            return macro.startsWith("__LINE__") || macro.startsWith("__FILE__") || macro.startsWith("__DATE__") || macro.startsWith("__TIME__");
        }

        private void diff(Pair golden, Pair particular) {
            this.diffMacros(golden, particular);
            this.diffPaths(golden, particular);
        }

        private void diffPaths(Pair golden, Pair particular) {
            if (particular.systemIncludeDirectoriesList.size() == 0) {
                this.changedPaths = false;
                return;
            }
            if (particular.systemIncludeDirectoriesList.size() != golden.systemIncludeDirectoriesList.size()) {
                this.changedPaths = true;
                return;
            }
            for (int i = 0; i < golden.systemIncludeDirectoriesList.size(); ++i) {
                String s2;
                String s1 = (String)golden.systemIncludeDirectoriesList.get(i);
                if (s1.equals(s2 = (String)particular.systemIncludeDirectoriesList.get(i))) continue;
                this.changedPaths = true;
                return;
            }
            this.changedPaths = false;
        }

        private void diffMacros(Pair golden, Pair particular) {
            int i;
            String pattern;
            String t;
            Iterator i$ = particular.systemPreprocessorSymbolsList.iterator();
            while (i$.hasNext()) {
                pattern = t = (String)i$.next();
                i = t.indexOf(61);
                if (i > 0) {
                    pattern = pattern.substring(0, i);
                }
                String found = null;
                for (String s : golden.systemPreprocessorSymbolsList) {
                    i = s.indexOf(61);
                    if (i > 0) {
                        if (!pattern.equals(s.substring(0, i))) continue;
                        found = s;
                        break;
                    }
                    if (!pattern.equals(s)) continue;
                    found = s;
                    break;
                }
                if (found == null) {
                    if (this.isIgnored(t)) continue;
                    this.added.add(t);
                    continue;
                }
                if (t.equals(found) || this.isIgnored(t)) continue;
                boolean skip = false;
                if (t.endsWith("=1")) {
                    if (found.indexOf("=") < 0) {
                        skip = true;
                    }
                } else if (found.endsWith("=1") && t.indexOf("=") < 0) {
                    skip = true;
                }
                if (skip) continue;
                this.changed.add(t);
            }
            i$ = golden.systemPreprocessorSymbolsList.iterator();
            while (i$.hasNext()) {
                pattern = t = (String)i$.next();
                i = t.indexOf(61);
                if (i > 0) {
                    pattern = pattern.substring(0, i);
                }
                boolean found = false;
                for (String s : particular.systemPreprocessorSymbolsList) {
                    i = s.indexOf(61);
                    if (i > 0) {
                        if (!pattern.equals(s.substring(0, i))) continue;
                        found = true;
                        break;
                    }
                    if (!pattern.equals(s)) continue;
                    found = true;
                    break;
                }
                if (found || this.isIgnored(pattern)) continue;
                this.removed.add(pattern);
            }
        }
    }

    protected static interface MyCallable<V> {
        public V call(String var1);
    }

    public static final class CompilerDefinition
    extends ArrayList<String> {
        private List<Integer> userAddedDefinitions = new ArrayList<Integer>(0);

        public CompilerDefinition() {
        }

        public CompilerDefinition(int size) {
            super(size);
        }

        public CompilerDefinition(Collection<String> c) {
            super(c);
        }

        public boolean isUserAdded(int i) {
            return this.userAddedDefinitions.contains(i);
        }

        public void setUserAdded(boolean isUserAddes, int i) {
            if (isUserAddes) {
                if (!this.userAddedDefinitions.contains(i)) {
                    this.userAddedDefinitions.add(i);
                }
            } else if (this.userAddedDefinitions.contains(i)) {
                this.userAddedDefinitions.remove((Object)i);
            }
        }

        public void sort() {
            HashSet set = new HashSet();
            for (Integer i : this.userAddedDefinitions) {
                if (i >= this.size()) continue;
                set.add(this.get(i));
            }
            Collections.sort(this, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
            this.userAddedDefinitions.clear();
            for (String s : set) {
                this.userAddedDefinitions.add(this.indexOf(s));
            }
        }
    }

    protected static final class Pair {
        public CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition(0);
        public CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition(0);
        public int exitCode = 0;
    }
}

