/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.FingerprintScanner;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

abstract class OracleCCppCompiler
extends CCCCompiler {
    protected OracleCCppCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    protected String getCompilerFingerPrintCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getFingerPrintFlags();
        }
        return null;
    }

    @Override
    protected CCCCompiler.Pair getFreshSystemIncludesAndDefines() {
        CCCCompiler.Pair res = new CCCCompiler.Pair();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerFingerPrintCommand(), true, res);
            this.completePredefinedMacros(res);
        }
        catch (IOException ioe) {
            System.err.println("IOException " + ioe);
            String errormsg = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(this.getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(this.getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            if (CndUtils.isStandalone()) {
                System.err.println(errormsg);
            }
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
        }
        this.checkModel(res, this.getCallable());
        return res;
    }

    @Override
    protected CCCCompiler.MyCallable<CCCCompiler.Pair> getCallable() {
        return new CCCCompiler.MyCallable<CCCCompiler.Pair>(){

            @Override
            public CCCCompiler.Pair call(String p) {
                CCCCompiler.Pair tmp = new CCCCompiler.Pair();
                try {
                    OracleCCppCompiler.this.getSystemIncludesAndDefines(OracleCCppCompiler.this.getCompilerFingerPrintCommand() + " " + p, true, tmp);
                    OracleCCppCompiler.this.completePredefinedMacros(tmp);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                return tmp;
            }
        };
    }

    protected Collection<String> getSystemPaths(String line) {
        List<String> res = this.getIncludePaths(line, "-include");
        res.addAll(this.getIncludePaths(line, "-I"));
        return res;
    }

    private List<String> getIncludePaths(String line, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        int includeIndex = line.indexOf(prefix);
        while (includeIndex > 0) {
            int spaceIndex;
            String token;
            int rest = includeIndex + prefix.length();
            if (line.charAt(includeIndex + prefix.length()) == ' ') {
                ++rest;
            }
            if (!(token = (spaceIndex = line.indexOf(32, rest)) > 0 ? line.substring(rest, spaceIndex) : line.substring(rest)).equals("-xbuiltin")) {
                res.add(token);
            }
            if (spaceIndex < 0) break;
            includeIndex = line.indexOf(prefix, spaceIndex);
        }
        return res;
    }

    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.Pair pair) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                FingerprintScanner.Result res = FingerprintScanner.scaneLine(line);
                if (res == null) continue;
                switch (res.getKind()) {
                    case SystemMacro: {
                        OracleCCppCompiler.addUnique(pair.systemPreprocessorSymbolsList, res.getResult());
                        break;
                    }
                    case SystemPath: {
                        OracleCCppCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(res.getResult()));
                    }
                }
            }
            reader.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }
}

