/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.execution.ShowInOutputFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOPosition;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputListenerImpl
implements OutputListener {
    private static final String CC_compiler_errors = "C/C++ compiler errors";
    private final ErrorParserProvider.OutputListenerRegistry registry;
    private final FileObject file;
    private final int line;
    private final boolean isError;
    private final String description;
    private final IOPosition.Position ioPos;

    public OutputListenerImpl(ErrorParserProvider.OutputListenerRegistry registry, FileObject file, int line, boolean isError, String description, IOPosition.Position ioPos) {
        this.registry = registry;
        this.file = file;
        this.line = line;
        this.isError = isError;
        this.description = description;
        this.ioPos = ioPos;
    }

    public int getLine() {
        return this.line;
    }

    public String getDescription() {
        return this.description;
    }

    public FileObject getFile() {
        return this.file;
    }

    public IOPosition.Position getIOPos() {
        return this.ioPos;
    }

    public void outputLineSelected(OutputEvent ev) {
        this.showLine(false);
    }

    public void outputLineAction(OutputEvent ev) {
        this.showLine(true);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.file != null ? this.file.hashCode() : 0);
        hash = 83 * hash + this.line;
        hash = 83 * hash + (this.isError ? 1 : 0);
        hash = 83 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputListenerImpl other = (OutputListenerImpl)obj;
        if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.isError != other.isError) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public void outputLineCleared(OutputEvent ev) {
        try {
            EditorCookie ec;
            DataObject dob = DataObject.find((FileObject)this.file);
            StyledDocument doc = null;
            if (dob.isValid() && (ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null) {
                doc = ec.getDocument();
            }
            if (doc != null) {
                HintsController.setErrors(doc, (String)CC_compiler_errors, Collections.emptyList());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public static void attach(ErrorParserProvider.OutputListenerRegistry registry) {
        JTextComponent pane = EditorRegistry.lastFocusedComponent();
        if (pane == null) {
            return;
        }
        Document doc = pane.getDocument();
        if (doc == null) {
            return;
        }
        DataObject dobj = (DataObject)doc.getProperty("stream");
        if (dobj == null) {
            return;
        }
        FileObject file = dobj.getPrimaryFile();
        if (file == null) {
            return;
        }
        OutputListenerImpl.attachFile(registry, file, doc);
    }

    private void showLine(boolean openTab) {
        block9: {
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                LineCookie lc = (LineCookie)dob.getLookup().lookup(LineCookie.class);
                if (lc == null) break block9;
                try {
                    Line l = lc.getLineSet().getOriginal(this.line);
                    if (!l.isDeleted()) {
                        EditorCookie ec;
                        if (openTab) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        } else {
                            l.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
                        }
                        StyledDocument doc = null;
                        if (dob.isValid() && (ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null) {
                            doc = ec.getDocument();
                        }
                        if (doc != null) {
                            OutputListenerImpl.attachFile(this.registry, this.file, doc);
                        }
                    }
                }
                catch (IndexOutOfBoundsException ex) {}
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void attachFile(ErrorParserProvider.OutputListenerRegistry registry, FileObject file, Document doc) throws MissingResourceException {
        Set<OutputListener> fileListeners = registry.getFileListeners(file);
        if (fileListeners == null) {
            return;
        }
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        for (OutputListener listener : fileListeners) {
            if (!(listener instanceof OutputListenerImpl)) continue;
            OutputListenerImpl impl = (OutputListenerImpl)listener;
            String aDescription = impl.description;
            ArrayList<ShowInOutputFix> fixes = new ArrayList<ShowInOutputFix>();
            if (IOPosition.isSupported((InputOutput)registry.getIO()) && IOSelect.isSupported((InputOutput)registry.getIO())) {
                fixes.add(new ShowInOutputFix(impl.description, registry.getIO(), impl.ioPos));
            }
            try {
                if (impl.isError) {
                    if (aDescription == null) {
                        aDescription = NbBundle.getMessage(OutputListenerImpl.class, (String)"HINT_CompilerError");
                    }
                    errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)aDescription, fixes, (Document)doc, (int)(impl.line + 1)));
                    continue;
                }
                if (aDescription == null) {
                    aDescription = NbBundle.getMessage(OutputListenerImpl.class, (String)"HINT_CompilerWarning");
                }
                errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)aDescription, fixes, (Document)doc, (int)(impl.line + 1)));
            }
            catch (IndexOutOfBoundsException e) {}
        }
        HintsController.setErrors((Document)doc, (String)CC_compiler_errors, errors);
    }
}

