/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JRadioButton;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;

public class PluginsOperator
extends NbDialogOperator {
    private static final String TITLE = Bundle.getString("org.netbeans.modules.autoupdate.ui.actions.Bundle", "PluginManager_Panel_Name");
    private static final String TOOLS_ITEM = Bundle.getStringTrimmed("org.netbeans.core.ui.resources.Bundle", "Menu/Tools");
    private static final String PLUGINS_ITEM = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.actions.Bundle", "PluginManagerAction_Name");
    private static final String INSTALLED_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Installed_Title");
    private static final String AVAILABLE_PLUGINS_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Available_Title");
    private JTabbedPaneOperator _tabbedPane;

    public PluginsOperator() {
        super(TITLE);
        this.tabbedPane();
        this.waitTabEnabled(INSTALLED_LABEL);
        if (!this.tabbedPane().isEnabledAt(this.tabbedPane().waitPage(AVAILABLE_PLUGINS_LABEL))) {
            this.selectInstalled();
            this.reloadCatalog();
            this.selectAvailablePlugins();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginsOperator invoke() {
        new ActionNoBlock(TOOLS_ITEM + "|" + PLUGINS_ITEM, null).perform();
        long oldTime = JemmyProperties.getCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout");
        JemmyProperties.setCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout", (long)120000L);
        try {
            PluginsOperator pluginsOperator = new PluginsOperator();
            return pluginsOperator;
        }
        finally {
            JemmyProperties.setCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout", (long)oldTime);
        }
    }

    public JTabbedPaneOperator tabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JTabbedPaneOperator((ContainerOperator)this);
            this._tabbedPane.getTimeouts().setTimeout("ComponentOperator.WaitComponentEnabledTimeout", 120000L);
            this._tabbedPane.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 120000L);
        }
        this._tabbedPane.wtComponentEnabled();
        return this._tabbedPane;
    }

    public JTableOperator table() {
        return new JTableOperator((ContainerOperator)this);
    }

    public JButtonOperator btUpdate() {
        this.selectUpdates();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_UPDATE"));
    }

    public JButtonOperator btInstall() {
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_AVAILABLE"));
    }

    public JButtonOperator btReloadCatalog() {
        return new JButtonOperator((ContainerOperator)this, "Check for");
    }

    public JButtonOperator btAddPlugins() {
        this.selectDownloaded();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bAddLocallyDownloads_Name"));
    }

    public JButtonOperator btDeactivate() {
        this.selectInstalled();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_DeactivateAction"));
    }

    public JButtonOperator btUninstall() {
        this.selectInstalled();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_INSTALLED"));
    }

    public JCheckBoxOperator cbShowDetails() {
        return new JCheckBoxOperator((ContainerOperator)this.selectInstalled(), Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab.detailView.text"));
    }

    public JTextFieldOperator txtSearch() {
        return new JTextFieldOperator((ContainerOperator)this);
    }

    public WizardOperator installer() {
        String installerTitle = Bundle.getString("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "UninstallUnitWizard_Title");
        return new WizardOperator(installerTitle);
    }

    public JTabbedPaneOperator selectUpdates() {
        String updatesTitle = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Update_Title");
        return this.selectTab(updatesTitle);
    }

    public JTabbedPaneOperator selectAvailablePlugins() {
        return this.selectTab(AVAILABLE_PLUGINS_LABEL);
    }

    public JTabbedPaneOperator selectDownloaded() {
        String downloadedTitle = Bundle.getString("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Local_Title");
        return this.selectTab(downloadedTitle);
    }

    public JTabbedPaneOperator selectInstalled() {
        return this.selectTab(INSTALLED_LABEL);
    }

    public JTabbedPaneOperator selectSettings() {
        String settingsTitle = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "SettingsTab_displayName");
        return this.selectTab(settingsTitle);
    }

    public JTabbedPaneOperator selectTab(String tabName) {
        this.waitTabEnabled(tabName);
        this.tabbedPane().selectPage(tabName);
        return this.tabbedPane();
    }

    public void waitTabEnabled(final String tabName) {
        final int installedIndex = this.tabbedPane().waitPage(tabName);
        this.tabbedPane().waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return PluginsOperator.this.tabbedPane().isEnabledAt(installedIndex);
            }

            public String getDescription() {
                return "page " + tabName + " enabled";
            }
        });
    }

    public void update() {
        this.btUpdate().pushNoBlock();
    }

    public void install() {
        this.btInstall().pushNoBlock();
    }

    public void uninstall() {
        this.btUninstall().pushNoBlock();
    }

    public void deactivate() {
        this.btDeactivate().pushNoBlock();
    }

    public void search(String text) {
        final int rowCount = this.table().getRowCount();
        this.txtSearch().setText(text);
        this.table().waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return PluginsOperator.this.table().getRowCount() != rowCount;
            }

            public String getDescription() {
                return "table changed row count";
            }
        });
    }

    public void reloadCatalog() {
        this.btReloadCatalog().push();
        this.tabbedPane();
    }

    public void addPlugins() {
        this.btAddPlugins().pushNoBlock();
    }

    public void selectPlugin(String pluginName) {
        this.selectPlugins(new String[]{pluginName});
    }

    public void selectPlugins(String[] pluginNames) {
        JTableOperator tableOper = this.table();
        for (int i = 0; i < pluginNames.length; ++i) {
            String name = pluginNames[i];
            int row = tableOper.findCellRow(name, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true), 1, 0);
            if (row == -1) {
                throw new JemmyException("Plugin " + name + " not found.");
            }
            tableOper.selectCell(row, 1);
            tableOper.clickOnCell(row, 0);
        }
    }

    public void addPlugin(String nbmPath) {
        this.addPlugins();
        JFileChooserOperator fileChooserOp = new JFileChooserOperator();
        fileChooserOp.setSelectedFile(new File(nbmPath));
        fileChooserOp.approve();
        this.tabbedPane();
    }

    public void install(String pluginName) {
        this.install(new String[]{pluginName});
    }

    public void install(String[] pluginNames) {
        this.selectAvailablePlugins();
        this.selectPlugins(pluginNames);
        this.install();
        this.finishInstall();
    }

    public void finishInstall() {
        WizardOperator installerOper = this.installer();
        installerOper.next();
        String acceptLabel = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "LicenseApprovalPanel.cbAccept.text");
        JCheckBoxOperator acceptCheckboxOper = new JCheckBoxOperator((ContainerOperator)installerOper, acceptLabel);
        if (!acceptCheckboxOper.isEnabled()) {
            acceptCheckboxOper.waitComponentShowing(false);
            acceptCheckboxOper = new JCheckBoxOperator((ContainerOperator)installerOper, acceptLabel);
        }
        acceptCheckboxOper.push();
        String installInDialogLabel = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallUnitWizardModel_Buttons_Install");
        new JButtonOperator((ContainerOperator)installerOper, installInDialogLabel).push();
        String installedLabel = Bundle.getString("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallStep_InstallDone_Text");
        JemmyProperties.setCurrentTimeout((String)"ComponentOperator.WaitComponentTimeout", (long)120000L);
        new JTextAreaOperator((ContainerOperator)installerOper, installedLabel);
        String restartNowLabel = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallUnitWizardModel_Buttons_RestartNow");
        JRadioButton restartButton = JRadioButtonOperator.findJRadioButton((Container)((Container)installerOper.getSource()), (String)restartNowLabel, (boolean)true, (boolean)true);
        if (restartButton == null) {
            String turningOnLabel = Bundle.getString("org.netbeans.core.startup.Bundle", "MSG_finish_enable_modules");
            MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000L);
            MainWindowOperator.getDefault().waitStatusText(turningOnLabel);
        }
        installerOper.finish();
    }
}

