/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.javafx2.platform.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class JavaFxRuntimeInclusion {
    private static final String PROP_PLATFORM_ANT_NAME = "platform.ant.name";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String SPEC_J2SE = "j2se";
    private final Support support;
    private final List<String> artifacts;

    private JavaFxRuntimeInclusion(Support supported, List<String> artifacts) {
        this.support = supported;
        this.artifacts = artifacts;
    }

    public boolean isSupported() {
        return this.support == Support.INCLUDED || this.support == Support.PRESENT;
    }

    public boolean isIncludedOnClassPath() {
        return this.support == Support.INCLUDED;
    }

    public List<String> getExtensionArtifactPaths() {
        return this.artifacts;
    }

    @NonNull
    public static JavaFxRuntimeInclusion forPlatform(@NonNull JavaPlatform javaPlatform) {
        Parameters.notNull((CharSequence)"javaPlatform", (Object)javaPlatform);
        boolean isDefault = JavaPlatform.getDefault().equals(javaPlatform);
        ArrayList<String> paths = new ArrayList<String>();
        Support runtimeSupport = Support.MISSING;
        String runtimePath = null;
        for (String runtimeLocation : Utils.getJavaFxRuntimeLocations()) {
            runtimePath = runtimeLocation + Utils.getJavaFxRuntimeArchiveName();
            runtimeSupport = JavaFxRuntimeInclusion.forRuntime(javaPlatform, Utils.getJavaFxRuntimeSubDir() + runtimePath);
            if (runtimeSupport != Support.MISSING) break;
        }
        if (runtimeSupport != Support.MISSING && runtimePath != null) {
            if (runtimeSupport == Support.PRESENT) {
                paths.add((isDefault ? "" : Utils.getJavaFxRuntimeSubDir()) + runtimePath);
            }
            for (String optionalName : Utils.getJavaFxRuntimeOptionalNames()) {
                Support optionalSupport = Support.MISSING;
                String optionalPath = null;
                for (String optionalLocation : Utils.getJavaFxRuntimeLocations()) {
                    optionalPath = optionalLocation + optionalName;
                    optionalSupport = JavaFxRuntimeInclusion.forRuntime(javaPlatform, Utils.getJavaFxRuntimeSubDir() + optionalPath);
                    if (optionalSupport == Support.PRESENT) break;
                }
                if (optionalSupport != Support.PRESENT || optionalPath == null) continue;
                paths.add((isDefault ? "" : Utils.getJavaFxRuntimeSubDir()) + optionalPath);
            }
        }
        return new JavaFxRuntimeInclusion(runtimeSupport, paths);
    }

    @NonNull
    private static Support forRuntime(@NonNull JavaPlatform javaPlatform, @NonNull String runtimePath) {
        Parameters.notNull((CharSequence)"javaPlatform", (Object)javaPlatform);
        Parameters.notNull((CharSequence)"rtPath", (Object)runtimePath);
        for (FileObject installFolder : javaPlatform.getInstallFolders()) {
            FileObject jfxrtJar = installFolder.getFileObject(runtimePath);
            if (jfxrtJar == null || !jfxrtJar.isData()) continue;
            URL jfxrtRoot = FileUtil.getArchiveRoot((URL)jfxrtJar.toURL());
            for (ClassPath.Entry e : javaPlatform.getBootstrapLibraries().entries()) {
                if (!jfxrtRoot.equals(e.getURL())) continue;
                return Support.INCLUDED;
            }
            return Support.PRESENT;
        }
        return Support.MISSING;
    }

    public static Set<String> getProjectClassPathExtension(@NonNull JavaPlatform javaPlatform) {
        Parameters.notNull((CharSequence)"javaPlatform", (Object)javaPlatform);
        if (!SPEC_J2SE.equals(javaPlatform.getSpecification().getName())) {
            Collection installFolders = javaPlatform.getInstallFolders();
            throw new IllegalArgumentException(String.format("Java platform %s (%s) installed in %s is not a valid J2SE platform.", javaPlatform.getDisplayName(), javaPlatform.getSpecification(), installFolders.isEmpty() ? "???" : FileUtil.getFileDisplayName((FileObject)((FileObject)installFolders.iterator().next()))));
        }
        JavaFxRuntimeInclusion inclusion = JavaFxRuntimeInclusion.forPlatform(javaPlatform);
        if (!inclusion.isSupported()) {
            return new LinkedHashSet<String>();
        }
        List<String> artifacts = inclusion.getExtensionArtifactPaths();
        if (!artifacts.isEmpty()) {
            LinkedHashSet<String> extensionProp = new LinkedHashSet<String>();
            for (String artifact : artifacts) {
                extensionProp.add(String.format("${%s}/%s", JavaFxRuntimeInclusion.getPlatformHomeProperty(javaPlatform), artifact));
            }
            return extensionProp;
        }
        return new LinkedHashSet<String>();
    }

    @NonNull
    public static String getPlatformHomeProperty(@NonNull JavaPlatform javaPlatform) {
        Parameters.notNull((CharSequence)"javaPlatform", (Object)javaPlatform);
        return javaPlatform.equals(JavaPlatformManager.getDefault().getDefaultPlatform()) ? PROP_JAVA_HOME : String.format("platforms.%s.home", javaPlatform.getProperties().get(PROP_PLATFORM_ANT_NAME));
    }

    public static enum Support {
        MISSING,
        PRESENT,
        INCLUDED;

    }
}

