/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend2.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.php.zend2.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Zend2OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1687321354656L;
    private static final String SKELETON_LAST_FOLDER_SUFFIX = ".skeleton";
    private static final FileFilter ZIP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.isFile() && f.getName().toLowerCase().endsWith(".zip");
        }

        @Override
        public String getDescription() {
            return Bundle.Zend2OptionsPanel_ziles_zip_filter();
        }
    };
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseSkeletonButton;
    private JLabel downloadSkeletonLabel;
    private JLabel errorLabel;
    private JLabel noteLabel;
    private JLabel skeletonInfoLabel;
    private JLabel skeletonLabel;
    private JTextField skeletonTextField;

    public Zend2OptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initListeners();
    }

    private void initListeners() {
        this.skeletonTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                Zend2OptionsPanel.this.fireChange();
            }
        });
    }

    public String getSkeleton() {
        return this.skeletonTextField.getText();
    }

    public void setSkeleton(String skeleton) {
        this.skeletonTextField.setText(skeleton);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.skeletonLabel = new JLabel();
        this.skeletonTextField = new JTextField();
        this.browseSkeletonButton = new JButton();
        this.skeletonInfoLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.downloadSkeletonLabel = new JLabel();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.skeletonLabel, (String)NbBundle.getMessage(Zend2OptionsPanel.class, (String)"Zend2OptionsPanel.skeletonLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseSkeletonButton, (String)NbBundle.getMessage(Zend2OptionsPanel.class, (String)"Zend2OptionsPanel.browseSkeletonButton.text"));
        this.browseSkeletonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Zend2OptionsPanel.this.browseSkeletonButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.skeletonInfoLabel, (String)NbBundle.getMessage(Zend2OptionsPanel.class, (String)"Zend2OptionsPanel.skeletonInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(Zend2OptionsPanel.class, (String)"Zend2OptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.downloadSkeletonLabel, (String)NbBundle.getMessage(Zend2OptionsPanel.class, (String)"Zend2OptionsPanel.downloadSkeletonLabel.text"));
        this.downloadSkeletonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Zend2OptionsPanel.this.downloadSkeletonLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Zend2OptionsPanel.this.downloadSkeletonLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.skeletonLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.skeletonInfoLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.skeletonTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseSkeletonButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.downloadSkeletonLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skeletonLabel).addComponent(this.skeletonTextField, -2, -1, -2).addComponent(this.browseSkeletonButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skeletonInfoLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadSkeletonLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseSkeletonButtonActionPerformed(ActionEvent evt) {
        File skeleton = new FileChooserBuilder(Zend2OptionsPanel.class.getName() + SKELETON_LAST_FOLDER_SUFFIX).setTitle(Bundle.Zend2OptionsPanel_browse_skeleton()).setFilesOnly(true).setFileFilter(ZIP_FILE_FILTER).showOpenDialog();
        if (skeleton != null) {
            skeleton = FileUtil.normalizeFile((File)skeleton);
            this.skeletonTextField.setText(skeleton.getAbsolutePath());
        }
    }

    private void downloadSkeletonLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void downloadSkeletonLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/zendframework/ZendSkeletonApplication");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

