/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionDocProvider;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionViewProvider;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.util.Lookup;

public final class CsmMacroExpansion {
    public static final String MACRO_EXPANSION_VIEW_DOCUMENT = "macro-expansion-view-document";
    public static final String USE_OWN_CARET_POSITION = "use-own-caret-position";
    private static final CsmMacroExpansionDocProvider EMPTY_MACRO_EXPANSION_DOC_PROVIDER = new EmptyMacroExpansionDoc();
    private static final CsmMacroExpansionViewProvider EMPTY_MACRO_EXPANSION_VIEW_PROVIDER = new EmptyMacroExpansionView();
    private static CsmMacroExpansionDocProvider defaultMacroExpansionDocProvider;
    private static CsmMacroExpansionViewProvider defaultMacroExpansionViewProvider;

    private CsmMacroExpansion() {
    }

    private static synchronized CsmMacroExpansionDocProvider getMacroExpansionDocProvider() {
        if (defaultMacroExpansionDocProvider != null) {
            return defaultMacroExpansionDocProvider;
        }
        defaultMacroExpansionDocProvider = (CsmMacroExpansionDocProvider)Lookup.getDefault().lookup(CsmMacroExpansionDocProvider.class);
        return defaultMacroExpansionDocProvider == null ? EMPTY_MACRO_EXPANSION_DOC_PROVIDER : defaultMacroExpansionDocProvider;
    }

    private static synchronized CsmMacroExpansionViewProvider getMacroExpansionViewProvider() {
        if (defaultMacroExpansionViewProvider != null) {
            return defaultMacroExpansionViewProvider;
        }
        defaultMacroExpansionViewProvider = (CsmMacroExpansionViewProvider)Lookup.getDefault().lookup(CsmMacroExpansionViewProvider.class);
        return defaultMacroExpansionViewProvider == null ? EMPTY_MACRO_EXPANSION_VIEW_PROVIDER : defaultMacroExpansionViewProvider;
    }

    public static int expand(Document inDoc, int startOffset, int endOffset, Document outDoc, AtomicBoolean canceled) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(inDoc, startOffset, endOffset, outDoc, canceled);
    }

    public static String expand(Document doc, int startOffset, int endOffset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(doc, startOffset, endOffset);
    }

    public static String expand(Document doc, CsmFile file, int startOffset, int endOffset, boolean updateIfNeeded) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(doc, file, startOffset, endOffset, updateIfNeeded);
    }

    public static String expand(Document doc, int offset, String code) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(doc, offset, code);
    }

    public static int[] getMacroExpansionSpan(Document doc, int offset, boolean wait) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getMacroExpansionSpan(doc, offset, wait);
    }

    public static int getOffsetInExpandedText(Document expandedDoc, int originalOffset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getOffsetInExpandedText(expandedDoc, originalOffset);
    }

    public static int getOffsetInOriginalText(Document expandedDoc, int expandedOffset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getOffsetInOriginalText(expandedDoc, expandedOffset);
    }

    public static int getNextMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getNextMacroExpansionStartOffset(expandedDoc, expandedOffset);
    }

    public static int getPrevMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getPrevMacroExpansionStartOffset(expandedDoc, expandedOffset);
    }

    public static int[][] getUsages(Document expandedDoc, int offset) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getUsages(expandedDoc, offset);
    }

    public static void showMacroExpansionView(Document doc, int offset) {
        UIGesturesSupport.submit((String)"USG_CND_SHOW_MACRO_EXPANSION", (Object[])new Object[0]);
        CsmMacroExpansion.getMacroExpansionViewProvider().showMacroExpansionView(doc, offset);
    }

    private static final class EmptyMacroExpansionView
    implements CsmMacroExpansionViewProvider {
        EmptyMacroExpansionView() {
        }

        @Override
        public void showMacroExpansionView(Document doc, int offset) {
        }
    }

    private static final class EmptyMacroExpansionDoc
    implements CsmMacroExpansionDocProvider {
        EmptyMacroExpansionDoc() {
        }

        @Override
        public int expand(Document inDoc, int startOffset, int endOffset, Document outDoc, AtomicBoolean canceled) {
            return 0;
        }

        @Override
        public String expand(Document doc, int startOffset, int endOffset) {
            return null;
        }

        @Override
        public String expand(Document doc, CsmFile file, int startOffset, int endOffset, boolean updateIfNeeded) {
            return null;
        }

        @Override
        public String expand(Document doc, int offset, String code) {
            return null;
        }

        @Override
        public int[] getMacroExpansionSpan(Document doc, int offset, boolean wait) {
            return new int[]{offset, offset};
        }

        @Override
        public int getOffsetInExpandedText(Document expandedDoc, int originalOffset) {
            return originalOffset;
        }

        @Override
        public int getOffsetInOriginalText(Document expandedDoc, int expandedOffset) {
            return expandedOffset;
        }

        @Override
        public int getNextMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
            return expandedOffset;
        }

        @Override
        public int getPrevMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
            return expandedOffset;
        }

        @Override
        public int[][] getUsages(Document expandedDoc, int offset) {
            return null;
        }
    }
}

