/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmSelectProvider;
import org.openide.util.Lookup;

public class CsmSelect {
    private static final Logger LOG = Logger.getLogger(CsmSelect.class.getSimpleName());
    private static CsmSelectProvider DEFAULT = new Default();
    public static final CsmFilter FUNCTION_KIND_FILTER = CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_LAMBDA, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION);
    public static final CsmFilter CLASSIFIER_KIND_FILTER = CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TYPEALIAS);
    private static final Callable<CsmCacheMap> SELECT_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("SELECT Cache", 1);
        }
    };

    public static CsmFilterBuilder getFilterBuilder() {
        return CsmSelect.getDefault().getFilterBuilder();
    }

    public static Iterator<CsmMacro> getMacros(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getMacros(file, filter);
    }

    public static Iterator<CsmInclude> getIncludes(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getIncludes(file, filter);
    }

    public static boolean hasDeclarations(CsmFile file) {
        return CsmSelect.getDefault().hasDeclarations(file);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(file, filter);
    }

    public static Iterator<CsmVariable> getStaticVariables(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getStaticVariables(file, filter);
    }

    public static Iterator<CsmFunction> getStaticFunctions(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getStaticFunctions(file, filter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace namespace, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(namespace, filter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition namespace, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(namespace, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<CsmMember> getClassMembers(CsmClass cls, CsmFilter filter) {
        Iterator<CsmMember> iterator;
        block7: {
            long time = System.currentTimeMillis();
            try {
                Iterator<CsmMember> out;
                CsmCacheMap cache = CsmCacheManager.getClientCache(ClassMembersKey.class, SELECT_INITIALIZER);
                ClassMembersKey key = new ClassMembersKey(cls, filter);
                IteratorWrapper<CsmMember> wrap = (IteratorWrapper<CsmMember>)CsmCacheMap.getFromCache(cache, key, null);
                if (wrap == null) {
                    time = System.currentTimeMillis();
                    Iterator<CsmMember> orig = CsmSelect.getDefault().getClassMembers(cls, filter);
                    time = System.currentTimeMillis() - time;
                    if (cache != null) {
                        wrap = new IteratorWrapper<CsmMember>(orig);
                        cache.put(key, CsmCacheMap.toValue(wrap, time));
                        out = wrap.iterator();
                    } else {
                        out = orig;
                    }
                } else {
                    out = wrap.iterator();
                    time = System.currentTimeMillis() - time;
                }
                iterator = out;
                if (!LOG.isLoggable(Level.FINE)) break block7;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "getClassMembers took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)cls), filter});
                }
                throw throwable;
            }
            LOG.log(Level.FINE, "getClassMembers took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)cls), filter});
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<CsmEnumerator> getEnumerators(CsmEnum en, CsmFilter filter) {
        Iterator<CsmEnumerator> iterator;
        block7: {
            long time = System.currentTimeMillis();
            try {
                Iterator<CsmEnumerator> out;
                CsmCacheMap cache = CsmCacheManager.getClientCache(ClassMembersKey.class, SELECT_INITIALIZER);
                EnumeratorsKey key = new EnumeratorsKey(en, filter);
                IteratorWrapper<CsmEnumerator> wrap = (IteratorWrapper<CsmEnumerator>)CsmCacheMap.getFromCache(cache, key, null);
                if (wrap == null) {
                    time = System.currentTimeMillis();
                    Iterator<CsmEnumerator> orig = CsmSelect.getDefault().getEnumerators(en, filter);
                    time = System.currentTimeMillis() - time;
                    if (cache != null) {
                        wrap = new IteratorWrapper<CsmEnumerator>(orig);
                        cache.put(key, CsmCacheMap.toValue(wrap, time));
                        out = wrap.iterator();
                    } else {
                        out = orig;
                    }
                } else {
                    out = wrap.iterator();
                    time = System.currentTimeMillis() - time;
                }
                iterator = out;
                if (!LOG.isLoggable(Level.FINE)) break block7;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "getEnumerators took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)en), filter});
                }
                throw throwable;
            }
            LOG.log(Level.FINE, "getEnumerators took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)en), filter});
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<CsmFriend> getClassFrirends(CsmClass cls, CsmFilter filter) {
        Iterator<CsmFriend> iterator;
        block7: {
            long time = System.currentTimeMillis();
            try {
                Iterator<CsmFriend> out;
                CsmCacheMap cache = CsmCacheManager.getClientCache(ClassFriendsKey.class, SELECT_INITIALIZER);
                ClassFriendsKey key = new ClassFriendsKey(cls, filter);
                IteratorWrapper<CsmFriend> wrap = (IteratorWrapper<CsmFriend>)CsmCacheMap.getFromCache(cache, key, null);
                if (wrap == null) {
                    time = System.currentTimeMillis();
                    Iterator<CsmFriend> orig = CsmSelect.getDefault().getClassFriends(cls, filter);
                    time = System.currentTimeMillis() - time;
                    if (cache != null) {
                        wrap = new IteratorWrapper<CsmFriend>(orig);
                        cache.put(key, CsmCacheMap.toValue(wrap, time));
                        out = wrap.iterator();
                    } else {
                        out = orig;
                    }
                } else {
                    out = wrap.iterator();
                    time = System.currentTimeMillis() - time;
                }
                iterator = out;
                if (!LOG.isLoggable(Level.FINE)) break block7;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "getClassFrirends took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)cls), filter});
                }
                throw throwable;
            }
            LOG.log(Level.FINE, "getClassFrirends took {0}ms:\n\tcls={1}\n\tfilter={2}\n", new Object[]{time, CsmSelect.getPosition((CsmOffsetableDeclaration)cls), filter});
        }
        return iterator;
    }

    public static Iterator<CsmFunction> getFunctions(CsmProject project, CharSequence qualifiedName) {
        if (qualifiedName.length() > 1 && qualifiedName.charAt(0) == ':' && qualifiedName.charAt(1) == ':') {
            qualifiedName = qualifiedName.subSequence(2, qualifiedName.length());
        }
        ArrayList<CsmFunction> result = new ArrayList<CsmFunction>();
        CsmSelect.getFunctions(project, qualifiedName, result, new LinkedHashSet<CsmProject>());
        return result.iterator();
    }

    private static void getFunctions(CsmProject project, CharSequence qName, Collection<CsmFunction> result, Collection<CsmProject> processedProjects) {
        if (!processedProjects.contains(project)) {
            processedProjects.add(project);
            int pos = CsmSelect.findLastScopeDelimeterPos(qName);
            if (pos == -1) {
                CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(FUNCTION_KIND_FILTER, CsmSelect.getFilterBuilder().createNameFilter(qName, true, true, false));
                CsmSelect.getFunctions(CsmSelect.getDeclarations(project.getGlobalNamespace(), filter), result);
            } else {
                CharSequence funcName;
                CharSequence nsQName;
                CharSequence classQName = nsQName = qName.subSequence(0, pos);
                CharSequence shortFuncName = funcName = qName.subSequence(pos + 2, qName.length());
                CsmNamespace nsp = project.findNamespace(nsQName);
                while (nsp == null && pos >= 0) {
                    pos = CsmSelect.findLastScopeDelimeterPos(nsQName);
                    if (pos < 0) continue;
                    nsQName = nsQName.subSequence(0, pos);
                    nsp = project.findNamespace(nsQName);
                    funcName = qName.subSequence(pos + 2, qName.length());
                }
                if (nsp == null) {
                    nsp = project.getGlobalNamespace();
                    funcName = qName;
                }
                CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(FUNCTION_KIND_FILTER, CsmSelect.getFilterBuilder().createNameFilter(funcName, true, true, false));
                CsmSelect.getFunctions(CsmSelect.getDeclarations(nsp, filter), result);
                if (!shortFuncName.equals(funcName)) {
                    filter = CsmSelect.getFilterBuilder().createCompoundFilter(FUNCTION_KIND_FILTER, CsmSelect.getFilterBuilder().createNameFilter(shortFuncName, true, true, false));
                }
                for (CsmClassifier cls : project.findClassifiers(classQName)) {
                    if (!CsmKindUtilities.isClass((CsmObject)cls)) continue;
                    CsmSelect.getFunctions(CsmSelect.getClassMembers((CsmClass)cls, filter), result);
                }
            }
            for (CsmProject lib : project.getLibraries()) {
                CsmSelect.getFunctions(lib, qName, result, processedProjects);
            }
        }
    }

    private static int findLastScopeDelimeterPos(CharSequence qName) {
        int pos = -1;
        for (int i = qName.length() - 2; i > 1; --i) {
            if (qName.charAt(i) != ':' || qName.charAt(i + 1) != ':') continue;
            pos = i;
            break;
        }
        return pos;
    }

    private static void getFunctions(Iterator<? extends CsmOffsetableDeclaration> iter, Collection<CsmFunction> result) {
        while (iter.hasNext()) {
            CsmOffsetableDeclaration decl = iter.next();
            if (!CsmKindUtilities.isFunction((CsmObject)decl)) continue;
            result.add((CsmFunction)decl);
        }
    }

    public static Iterator<CsmUID<CsmFile>> getFileUIDs(CsmProject csmProject, NameAcceptor nameFilter) {
        return CsmSelect.getDefault().getFileUIDs(csmProject, nameFilter);
    }

    private CsmSelect() {
    }

    private static CsmSelectProvider getDefault() {
        return DEFAULT;
    }

    private static CharSequence getPosition(CsmOffsetableDeclaration obj) {
        CsmFile file = obj.getContainingFile();
        String position = file.getAbsolutePath().toString();
        int[] lineColumn = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, obj.getStartOffset());
        if (lineColumn != null) {
            position = "line=" + lineColumn[0] + ":" + lineColumn[1] + " " + position;
        }
        return position;
    }

    private static final class IteratorWrapper<T> {
        private final Iterator<T> orig;
        private final List<T> fetched = new ArrayList<T>(10);

        public IteratorWrapper(Iterator<T> iter) {
            this.orig = iter;
        }

        public Iterator<T> iterator() {
            return new Impl();
        }

        private final class Impl
        implements Iterator<T> {
            int index = 0;

            private Impl() {
            }

            @Override
            public boolean hasNext() {
                if (this.index < IteratorWrapper.this.fetched.size()) {
                    return true;
                }
                return IteratorWrapper.this.orig.hasNext();
            }

            @Override
            public T next() {
                if (this.index < IteratorWrapper.this.fetched.size()) {
                    return IteratorWrapper.this.fetched.get(this.index++);
                }
                if (IteratorWrapper.this.orig.hasNext()) {
                    IteratorWrapper.this.fetched.add(IteratorWrapper.this.orig.next());
                    return IteratorWrapper.this.fetched.get(this.index++);
                }
                throw new NoSuchElementException("Invalid index " + this.index + " has only " + IteratorWrapper.this.fetched.size());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "Impl{index=" + this.index + '}';
            }
        }
    }

    private static final class ClassFriendsKey {
        private final CsmClass cls;
        private final CsmFilter filter;

        public ClassFriendsKey(CsmClass cls, CsmFilter filter) {
            this.cls = cls;
            this.filter = filter;
        }

        public int hashCode() {
            int hash = 7;
            hash = 87 * hash + this.cls.hashCode();
            hash = 87 * hash + this.filter.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassFriendsKey other = (ClassFriendsKey)obj;
            if (!this.filter.equals(other.filter)) {
                return false;
            }
            return this.cls.equals(other.cls);
        }
    }

    private static final class EnumeratorsKey {
        private final CsmEnum en;
        private final CsmFilter filter;

        public EnumeratorsKey(CsmEnum cls, CsmFilter filter) {
            this.en = cls;
            this.filter = filter;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.en.hashCode();
            hash = 67 * hash + this.filter.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumeratorsKey other = (EnumeratorsKey)obj;
            if (!this.filter.equals(other.filter)) {
                return false;
            }
            return this.en.equals(other.en);
        }
    }

    private static final class ClassMembersKey {
        private final CsmClass cls;
        private final CsmFilter filter;

        public ClassMembersKey(CsmClass cls, CsmFilter filter) {
            this.cls = cls;
            this.filter = filter;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.cls.hashCode();
            hash = 67 * hash + this.filter.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassMembersKey other = (ClassMembersKey)obj;
            if (!this.filter.equals(other.filter)) {
                return false;
            }
            return this.cls.equals(other.cls);
        }
    }

    private static final class Default
    implements CsmSelectProvider {
        private final Lookup.Result<CsmSelectProvider> res = Lookup.getDefault().lookupResult(CsmSelectProvider.class);
        private static final boolean FIX_SERVICE = true;
        private CsmSelectProvider fixedSelector;

        Default() {
        }

        private CsmSelectProvider getService() {
            CsmSelectProvider service = this.fixedSelector;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CsmSelectProvider selector;
                    service = selector = (CsmSelectProvider)i$.next();
                }
                if (service != null) {
                    this.fixedSelector = service;
                }
            }
            return service;
        }

        @Override
        public CsmFilterBuilder getFilterBuilder() {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getFilterBuilder();
            }
            return null;
        }

        @Override
        public Iterator<CsmMacro> getMacros(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getMacros(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmInclude> getIncludes(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getIncludes(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace namespace, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(namespace, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition namespace, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(namespace, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmMember> getClassMembers(CsmClass cls, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getClassMembers(cls, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmFriend> getClassFriends(CsmClass cls, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getClassFriends(cls, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmEnumerator> getEnumerators(CsmEnum en, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getEnumerators(en, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmVariable> getStaticVariables(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getStaticVariables(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmFunction> getStaticFunctions(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getStaticFunctions(file, filter);
            }
            return null;
        }

        @Override
        public boolean hasDeclarations(CsmFile file) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.hasDeclarations(file);
            }
            return file.getDeclarations().isEmpty();
        }

        @Override
        public Iterator<CsmUID<CsmFile>> getFileUIDs(CsmProject csmProject, NameAcceptor filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getFileUIDs(csmProject, filter);
            }
            return Collections.emptyList().iterator();
        }
    }

    public static interface CsmFilterBuilder {
        public CsmFilter createKindFilter(CsmDeclaration.Kind ... var1);

        public CsmFilter createNameFilter(CharSequence var1, boolean var2, boolean var3, boolean var4);

        public CsmFilter createOffsetFilter(int var1, int var2);

        public CsmFilter createOffsetFilter(int var1);

        public CsmFilter createCompoundFilter(CsmFilter var1, CsmFilter var2);

        public CsmFilter createOrFilter(CsmFilter var1, CsmFilter var2);

        public CsmFilter createNameFilter(NameAcceptor var1);
    }

    public static interface NameAcceptor {
        public boolean accept(CharSequence var1);
    }

    public static interface CsmFilter {
    }
}

