/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.shelve;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.shelve.Bundle;
import org.netbeans.modules.git.remote.ui.stash.SaveStashAction;
import org.netbeans.modules.git.remote.ui.stash.Stash;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class ShelveChangesAction
extends SingleRepositoryAction {
    private static ShelveChangesActionsRegistry.ShelveChangesActionProvider ACTION_PROVIDER;

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.shelve(repository, roots);
    }

    public void shelve(VCSFileProxy repository, VCSFileProxy[] roots) {
        if (Git.getInstance().getFileStatusCache().listFiles(roots, FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING).length == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_ShelveAction_noModifications_text(), Bundle.LBL_ShelveAction_noModifications_title(), 1);
                }
            });
            return;
        }
        GitShelveChangesSupport supp = new GitShelveChangesSupport(repository);
        if (supp.open()) {
            RequestProcessor rp = Git.getInstance().getRequestProcessor(repository);
            supp.startAsync(rp, repository, roots);
        }
    }

    public static synchronized ShelveChangesActionsRegistry.ShelveChangesActionProvider getProvider() {
        if (ACTION_PROVIDER == null) {
            ACTION_PROVIDER = new ShelveChangesActionsRegistry.ShelveChangesActionProvider(){

                public Action getAction() {
                    SystemAction a = SystemAction.get(SaveStashAction.class);
                    Utils.setAcceleratorBindings((String)"Actions/Git", (Action[])new Action[]{a});
                    return a;
                }
            };
        }
        return ACTION_PROVIDER;
    }

    private static class UnshelveMenu {
        private static UnshelveMenu instance;

        private UnshelveMenu() {
        }

        static synchronized UnshelveMenu getInstance() {
            if (instance == null) {
                instance = new UnshelveMenu();
            }
            return instance;
        }

        private JComponent[] getMenu(VCSContext context, boolean popup) {
            VCSFileProxy root;
            RepositoryInfo info;
            List<GitRevisionInfo> stashes;
            Map.Entry actionRoots = ShelveChangesAction.getActionRoots(context);
            if (actionRoots != null && !(stashes = (info = RepositoryInfo.getInstance(root = (VCSFileProxy)actionRoots.getKey())).getStashes()).isEmpty()) {
                JMenu menu = new JMenu(popup ? Bundle.CTL_UnstashMenu_name_popup() : Bundle.CTL_UnstashMenu_name());
                Mnemonics.setLocalizedText((AbstractButton)menu, (String)menu.getText());
                ListIterator<Stash> it = Stash.create(root, stashes).listIterator();
                for (int i = 0; it.hasNext() && i < 10; ++i) {
                    Stash stash = it.next();
                    Action a = stash.getApplyAction();
                    String name = Bundle.CTL_UnstashAction_name(stash.getIndex(), stash.getInfo().getShortMessage());
                    if (name.length() > 40) {
                        name = name.substring(0, 40);
                    }
                    a.putValue("Name", name);
                    a.putValue("ShortDescription", stash.getInfo().getShortMessage());
                    JMenuItem item = new JMenuItem(name);
                    if (popup) {
                        Actions.connect((JMenuItem)item, (Action)a, (boolean)true);
                    } else {
                        Actions.connect((AbstractButton)item, (Action)a);
                    }
                    menu.add(item);
                }
                return new JComponent[]{menu};
            }
            return null;
        }
    }

    private static abstract class ShelveChangesProgressSupport
    extends GitProgressSupport {
        private ShelveChangesProgressSupport() {
        }

        @Override
        public void setDisplayName(String displayName) {
            super.setDisplayName(displayName);
        }
    }

    private static class GitShelveChangesSupport
    extends ShelveChangesSupport {
        private ShelveChangesProgressSupport support;
        private VCSFileProxy[] modifications;
        private final VCSFileProxy repository;
        private final JPanel optionsPanel;
        private final JCheckBox revertModificationInIndex;
        private final JCheckBox doPurgeChxBox;
        private boolean doRevertIndex;
        private boolean doPurge;

        public GitShelveChangesSupport(VCSFileProxy repository) {
            this.repository = repository;
            this.revertModificationInIndex = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.revertModificationInIndex, (String)Bundle.ShelvePanel_doRevertIndexChanges_text());
            this.revertModificationInIndex.setToolTipText(Bundle.ShelvePanel_doRevertIndexChanges_desc());
            this.revertModificationInIndex.getAccessibleContext().setAccessibleDescription(this.revertModificationInIndex.getToolTipText());
            this.revertModificationInIndex.setSelected(true);
            this.doPurgeChxBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.doPurgeChxBox, (String)Bundle.ShelvePanel_doPurgeChxBox_text());
            this.doPurgeChxBox.setToolTipText(Bundle.ShelvePanel_doPurgeChxBox_desc());
            this.doPurgeChxBox.getAccessibleContext().setAccessibleDescription(this.doPurgeChxBox.getToolTipText());
            this.doPurgeChxBox.setSelected(GitModuleConfig.getDefault().getRemoveWTNew());
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.revertModificationInIndex);
            this.optionsPanel.add(this.doPurgeChxBox);
        }

        protected void exportPatch(File toFile, File commonParent) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void postExportCleanup() {
            final HashSet<VCSFileProxy> notifiedFiles = new HashSet<VCSFileProxy>();
            if (this.support.isCanceled()) {
                return;
            }
            try {
                GitUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        GitShelveChangesSupport.this.support.setDisplayName(Bundle.MSG_ShelveChanges_progress_reverting(GitShelveChangesSupport.this.repository.getName()));
                        GitClient client = Git.getInstance().getClient(GitShelveChangesSupport.this.repository);
                        client.addNotificationListener((NotificationListener)new FileListener(){

                            public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
                                notifiedFiles.add(file);
                            }
                        });
                        ShelveChangesProgressSupport shelveChangesProgressSupport = GitShelveChangesSupport.this.support;
                        shelveChangesProgressSupport.getClass();
                        client.addNotificationListener((NotificationListener)shelveChangesProgressSupport.new GitProgressSupport.DefaultFileListener(GitShelveChangesSupport.this.modifications));
                        client.checkout(GitShelveChangesSupport.this.modifications, GitShelveChangesSupport.this.doRevertIndex ? "HEAD" : null, true, GitShelveChangesSupport.this.support.getProgressMonitor());
                        if (GitShelveChangesSupport.this.doPurge) {
                            client.clean(GitShelveChangesSupport.this.modifications, GitShelveChangesSupport.this.support.getProgressMonitor());
                        }
                        return null;
                    }
                }, this.modifications);
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            }
            finally {
                this.support.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(notifiedFiles);
            }
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, final VCSFileProxy repository, final VCSFileProxy[] roots) {
            this.support = new ShelveChangesProgressSupport(){

                @Override
                protected void perform() {
                    GitShelveChangesSupport.access$402(GitShelveChangesSupport.this, Git.getInstance().getFileStatusCache().listFiles(roots, FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING));
                    VCSFileProxy[] arr = Arrays.copyOf(GitShelveChangesSupport.this.modifications, GitShelveChangesSupport.this.modifications.length + 1);
                    arr[((GitShelveChangesSupport)GitShelveChangesSupport.this).modifications.length] = repository;
                }
            };
            this.support.start(rp, repository, Bundle.LBL_ShelveChanges_Progress());
        }

        private boolean open() {
            boolean retval = this.prepare(this.optionsPanel, "org.netbeans.modules.git.remote.ui.shelve.ShelveChangesPanel");
            if (retval) {
                this.doRevertIndex = this.revertModificationInIndex.isSelected();
                this.doPurge = this.doPurgeChxBox.isSelected();
                GitModuleConfig.getDefault().putRemoveWTNew(this.doPurge);
            }
            return retval;
        }

        static /* synthetic */ VCSFileProxy[] access$402(GitShelveChangesSupport x0, VCSFileProxy[] x1) {
            x0.modifications = x1;
            return x1;
        }
    }
}

