/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.loaders.CMakeDataObject;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class CMakeAction
extends AbstractExecutorRunAction {
    public String getName() {
        return CMakeAction.getString("BTN_Cmake");
    }

    @Override
    protected boolean accept(DataObject object) {
        return object instanceof CMakeDataObject;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.performAction(activatedNodes[i]);
        }
    }

    protected void performAction(Node node) {
        CMakeAction.performAction(node, null, null, CMakeAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener listener, final Writer outputListener, final Project project, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private NativeExecutionService es;

                public void doWork() {
                    this.es = CMakeAction.prepare(node, listener, outputListener, project, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = CMakeAction.getString("DLG_TITLE_Prepare", "cmake");
            String msg = CMakeAction.getString("MSG_TITLE_Prepare", "cmake");
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            NativeExecutionService es = CMakeAction.prepare(node, listener, outputListener, project, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private static NativeExecutionService prepare(Node node, ExecutionListener listener, Writer outputListener, Project project, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        String relativePathToScript;
        CMakeAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject buildDirFileObject = CMakeAction.getBuildDirectory(node, PredefinedToolKind.CMakeTool);
        if (buildDirFileObject == null) {
            CMakeAction.trace("Run folder folder is null");
            return null;
        }
        String buildDir = buildDirFileObject.getPath();
        String executable = CMakeAction.getCommand(node, project, PredefinedToolKind.CMakeTool, "cmake");
        String[] arguments = CMakeAction.getArguments(node, PredefinedToolKind.CMakeTool);
        ExecutionEnvironment execEnv = CMakeAction.getExecutionEnvironment(fileObject, project);
        if (FileSystemProvider.getExecutionEnvironment((FileObject)buildDirFileObject).isLocal()) {
            buildDir = CMakeAction.convertToRemoteIfNeeded(execEnv, buildDir, project);
        }
        if (buildDir == null) {
            CMakeAction.trace("Run folder folder is null");
            return null;
        }
        Map<String, String> envMap = CMakeAction.getEnv(execEnv, node, project, null);
        StringBuilder argsFlat = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(arguments[i]);
        }
        String scriptPath = fileObject.getParent().getPath();
        if (FileSystemProvider.getExecutionEnvironment((FileObject)buildDirFileObject).isLocal()) {
            scriptPath = CMakeAction.convertToRemoteIfNeeded(execEnv, scriptPath, project);
        }
        if ((relativePathToScript = CndPathUtilities.toRelativePath((String)buildDir, (String)scriptPath)).length() > 1) {
            argsFlat.append(" ");
            argsFlat.append(relativePathToScript);
        }
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? CMakeAction.getString("CMAKE_LABEL", node.getName()) : CMakeAction.getString("CMAKE_REMOTE_LABEL", node.getName(), execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Lookup.Provider)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            CMakeAction.trace("RemoteSyncWorker is not started up");
            return null;
        }
        MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)execEnv);
        mm.putAll(envMap);
        CMakeAction.traceExecutable(executable, buildDir, argsFlat, execEnv.toString(), (Map<String, String>)mm.toMap());
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, null, syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(buildDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(mm);
        npb.redirectError();
        List<String> list = ImportUtils.parseArgs(argsFlat.toString());
        list = ImportUtils.normalizeParameters(list);
        npb.setExecutable(executable);
        npb.setArguments(list.toArray(new String[list.size()]));
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).showProgress(!CndUtils.isStandalone()).postExecution((Runnable)processChangeListener).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default("CMake")).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        descr.noReset(true);
        inputOutput.getOut().println("cd '" + buildDir + "'");
        inputOutput.getOut().println(executable + " " + argsFlat);
        return NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"cmake");
    }
}

