/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public final class CndVisibilityQuery {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Pattern ignorePattern = null;

    public CndVisibilityQuery(String ignoredRegex) {
        this.ignorePattern = Pattern.compile(ignoredRegex);
    }

    public void setIgnoredPattern(String regex) {
        if (this.ignorePattern != null && regex != null && !this.ignorePattern.pattern().equals(regex)) {
            this.ignorePattern = Pattern.compile(regex);
            this.cs.fireChange();
        } else if (this.ignorePattern == null && regex != null) {
            this.ignorePattern = Pattern.compile(regex);
            this.cs.fireChange();
        }
    }

    public String getRegEx() {
        return this.ignorePattern.pattern();
    }

    public boolean isIgnored(FileObject file) {
        return this.isIgnored(file.getNameExt());
    }

    public boolean isIgnored(File file) {
        return this.isIgnored(file.getName());
    }

    private boolean isIgnored(String fileName) {
        return this.ignorePattern.matcher(fileName).find();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }
}

