/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ExecutionSupport
implements Node.Cookie {
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    private static final String EA_ENVIRONMENT_VARIABLES = "NetBeansAttrEnvironment";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    private final MultiDataObject.Entry entry;
    protected static final String READONLY_ATTRIBUTES = "readOnlyAttrs";

    public ExecutionSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    protected MultiDataObject.Entry getEntry() {
        return this.entry;
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    protected boolean startFailed(IOException ex) {
        return false;
    }

    public void setArguments(String[] args) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] args) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public String[] getArguments() {
        return ExecutionSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object o = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        return new String[0];
    }

    public void setEnvironmentVariables(String[] args) throws IOException {
        this.entry.getFile().setAttribute(EA_ENVIRONMENT_VARIABLES, (Object)args);
    }

    public String[] getEnvironmentVariables() {
        Object o = this.entry.getFile().getAttribute(EA_ENVIRONMENT_VARIABLES);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        return new String[0];
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty(PROP_FILE_PARAMS, ExecutionSupport.getString("PROP_fileParams"), ExecutionSupport.getString("HINT_fileParams")));
    }

    protected PropertySupport<String> createParamsProperty(String propertyName, String displayName, String description) {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(propertyName, String.class, displayName, description){

            public String getValue() {
                String[] args = ExecutionSupport.this.getArguments();
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    b.append(args[i]).append(' ');
                }
                return b.toString();
            }

            public void setValue(String val) throws InvocationTargetException {
                if (val != null) {
                    try {
                        ExecutionSupport.this.setArguments(new String[]{val});
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setArguments(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    protected PropertySupport<String> createEnvironmentProperty(String propertyName, String displayName, String description) {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(propertyName, String.class, displayName, description){

            public String getValue() {
                String[] args = ExecutionSupport.this.getEnvironmentVariables();
                List<String> list = new ArrayList<String>();
                for (int i = 0; i < args.length; ++i) {
                    list.add(args[i]);
                }
                list = ImportUtils.quoteList(list);
                StringBuilder b = new StringBuilder();
                for (String s : list) {
                    b.append(s).append(' ');
                }
                return b.toString();
            }

            public void setValue(String val) throws InvocationTargetException {
                if (val != null) {
                    try {
                        List<String> vars = ImportUtils.parseEnvironment(val);
                        ExecutionSupport.this.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setEnvironmentVariables(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean canWrite() {
                return ExecutionSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ExecutionSupport.class, (String)s);
    }
}

