/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

public abstract class RemoteBinaryService {
    private static final Map<RemoteBinaryID, Future<Boolean>> readiness = Collections.synchronizedMap(new HashMap());

    protected RemoteBinaryService() {
    }

    public static RemoteBinaryID getRemoteBinary(ExecutionEnvironment execEnv, String remotePath) {
        if (execEnv.isLocal()) {
            return new RemoteBinaryID(remotePath, "" + new File(remotePath).lastModified());
        }
        RemoteBinaryService rbs = (RemoteBinaryService)Lookup.getDefault().lookup(RemoteBinaryService.class);
        if (rbs == null) {
            return null;
        }
        RemoteBinaryResult result = rbs.getRemoteBinaryImpl(execEnv, remotePath);
        if (result == null) {
            return null;
        }
        RemoteBinaryID id = new RemoteBinaryID(result.localFName, result.timeStamp);
        Future<Boolean> prevResult = readiness.put(id, result.syncResult);
        if (prevResult != null && prevResult != result.syncResult) {
            prevResult.cancel(true);
        }
        return id;
    }

    public static String getFileName(RemoteBinaryID id) {
        return id.toIDString();
    }

    public static Future<Boolean> getResult(RemoteBinaryID id) {
        return readiness.get(id);
    }

    protected abstract RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment var1, String var2);

    public static class RemoteBinaryID {
        private final String id;
        private final String timeStamp;

        private RemoteBinaryID(String id, String timeStamp) {
            this.id = id;
            this.timeStamp = timeStamp;
        }

        public static RemoteBinaryID fromIDString(String str) {
            int i = str.lastIndexOf(59);
            String timeStamp = "0";
            if (i > 0) {
                timeStamp = str.substring(i + 1);
                str = str.substring(0, i);
            }
            return new RemoteBinaryID(str, timeStamp);
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public String toIDString() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteBinaryID)) {
                return false;
            }
            RemoteBinaryID that = (RemoteBinaryID)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }
    }

    protected static class RemoteBinaryResult {
        public final String localFName;
        public final Future<Boolean> syncResult;
        private String timeStamp;

        public RemoteBinaryResult(String localFName, Future<Boolean> syncResult) {
            this.localFName = localFName;
            this.syncResult = syncResult;
        }

        public void setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }
    }
}

