/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultMutableTreeNode;

class FileNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    static final FileNameComparator FILE_NAME_COMPARATOR = new FileNameComparator();
    private File file;
    private boolean isDir;
    private boolean loaded;
    private boolean isSelected;
    private final boolean exists;

    public FileNode(File file) {
        this(file, true, false, false, false);
    }

    public FileNode(File file, boolean allowsChildren) {
        this(file, allowsChildren, false, false, false);
    }

    public FileNode(File file, boolean allowsChildren, boolean isSelected, boolean isChecked, boolean isEditable) {
        super(file, allowsChildren);
        this.file = file;
        this.isDir = file.isDirectory();
        this.exists = file.exists();
        this.isSelected = isSelected;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.setUserObject(file);
        this.file = file;
        this.loaded = false;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Override
    public boolean isLeaf() {
        return !this.isDir;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDir;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean loadChildren(JFileChooser chooser, boolean descend) {
        if (!this.loaded) {
            ArrayList files = this.getFiles(chooser);
            if (files.isEmpty()) {
                return false;
            }
            for (int i = 0; i < files.size(); ++i) {
                File child = (File)files.get(i);
                if (!chooser.accept(child)) continue;
                try {
                    FileNode node = new FileNode(child);
                    if (!descend) break;
                    this.add(node);
                    continue;
                }
                catch (NullPointerException t) {
                    Logger.getLogger(FileNode.class.getName()).log(Level.INFO, null, t);
                }
            }
            if (descend || this.getChildCount() > 0) {
                this.loaded = true;
            }
        }
        return this.loaded;
    }

    private ArrayList getFiles(JFileChooser chooser) {
        ArrayList<File> list = new ArrayList<File>();
        if (this.file == null || !this.file.exists()) {
            return list;
        }
        File[] files = chooser.getFileSystemView().getFiles(this.file, chooser.isFileHidingEnabled());
        int mode = chooser.getFileSelectionMode();
        if (mode == 1) {
            for (int i = 0; i < files.length; ++i) {
                File child = files[i];
                if (!child.isDirectory()) continue;
                list.add(child);
            }
            Collections.sort(list, FILE_NAME_COMPARATOR);
        } else if (mode == 2 || mode == 0) {
            ArrayList<File> dirList = new ArrayList<File>();
            ArrayList<File> fileList = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File child = files[i];
                if (child.isDirectory()) {
                    dirList.add(child);
                    continue;
                }
                fileList.add(child);
            }
            Collections.sort(dirList, FILE_NAME_COMPARATOR);
            Collections.sort(fileList, FILE_NAME_COMPARATOR);
            list.addAll(dirList);
            list.addAll(fileList);
        }
        return list;
    }

    Icon getIcon(JFileChooser fileChooser) {
        if (this.exists) {
            return fileChooser.getIcon(this.getFile());
        }
        return null;
    }

    String getText(JFileChooser fileChooser) {
        if (this.exists) {
            return "<html>" + fileChooser.getName(this.getFile()) + "</html>";
        }
        return "<html> </html>";
    }

    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return String.CASE_INSENSITIVE_ORDER.compare(f1.getName(), f2.getName());
        }
    }
}

