/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.cnd.api.script.MakefileTokenId;
import org.netbeans.modules.cnd.api.script.ShTokenId;
import org.netbeans.modules.cnd.makefile.editor.ShellEmbeddingHighlightContainer;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class ShellEmbeddingProvider
extends EmbeddingProvider {
    private volatile boolean cancelled;

    ShellEmbeddingProvider() {
    }

    public void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenSequence tokenSequence;
        this.cancelled = false;
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        if (tokenHierarchy != null && (tokenSequence = tokenHierarchy.tokenSequence(MakefileTokenId.language())) != null) {
            List<Embedding> embeddings = this.getEmbeddings(snapshot, (TokenSequence<MakefileTokenId>)tokenSequence);
            Document doc = snapshot.getSource().getDocument(false);
            if (doc != null && !this.cancelled) {
                List<ShellEmbeddingHighlightContainer.HighlightItem> highlights = this.getHighlights(doc, embeddings);
                if (!this.cancelled) {
                    ShellEmbeddingHighlightContainer.get(doc).setHighlights(highlights);
                }
            }
            return embeddings;
        }
        return Collections.emptyList();
    }

    private List<Embedding> getEmbeddings(Snapshot snapshot, TokenSequence<MakefileTokenId> ts) {
        ArrayList<Embedding> allEmbeddings = new ArrayList<Embedding>();
        ArrayList<Embedding> localEmbeddings = new ArrayList<Embedding>();
        boolean inShell = false;
        block5: while (ts.moveNext() && !this.cancelled) {
            Token token = ts.token();
            switch ((MakefileTokenId)token.id()) {
                case TAB: {
                    inShell = true;
                    continue block5;
                }
                case SHELL: {
                    localEmbeddings.add(snapshot.create(ts.offset(), token.length(), "text/sh"));
                    inShell = true;
                    continue block5;
                }
                case MACRO: {
                    if (!inShell) continue block5;
                    localEmbeddings.add(snapshot.create(this.evaluateMacro(token.text()), "text/sh"));
                    continue block5;
                }
            }
            if (!localEmbeddings.isEmpty()) {
                allEmbeddings.add(Embedding.create(localEmbeddings));
                localEmbeddings.clear();
            }
            inShell = false;
        }
        if (!localEmbeddings.isEmpty() && !this.cancelled) {
            allEmbeddings.add(Embedding.create(localEmbeddings));
        }
        return allEmbeddings;
    }

    private List<ShellEmbeddingHighlightContainer.HighlightItem> getHighlights(Document doc, List<Embedding> embeddings) {
        ArrayList<ShellEmbeddingHighlightContainer.HighlightItem> highlights = new ArrayList<ShellEmbeddingHighlightContainer.HighlightItem>();
        for (Embedding embedding : embeddings) {
            TokenSequence tokenSequence;
            if (this.cancelled) break;
            Snapshot snapshot = embedding.getSnapshot();
            TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
            if (tokenHierarchy == null || (tokenSequence = tokenHierarchy.tokenSequence(ShTokenId.language())) == null) continue;
            ShellEmbeddingProvider.addHighlights(snapshot, doc, (TokenSequence<ShTokenId>)tokenSequence, highlights);
        }
        return highlights;
    }

    private static void addHighlights(Snapshot snapshot, Document doc, TokenSequence<ShTokenId> tokenSequence, List<ShellEmbeddingHighlightContainer.HighlightItem> highlights) {
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            int startOffset = snapshot.getOriginalOffset(tokenSequence.offset());
            int endOffset = snapshot.getOriginalOffset(tokenSequence.offset() + token.length());
            for (int i = 1; (startOffset < 0 || endOffset < 0) && i <= token.length(); ++i) {
                int offset = snapshot.getOriginalOffset(tokenSequence.offset() + i);
                if (0 > offset) continue;
                if (startOffset < 0) {
                    startOffset = offset;
                }
                if (endOffset >= 0 && endOffset >= offset) continue;
                endOffset = offset;
            }
            if (0 > startOffset || 0 > endOffset) continue;
            try {
                highlights.add(new ShellEmbeddingHighlightContainer.HighlightItem(doc.createPosition(startOffset), doc.createPosition(endOffset), ((ShTokenId)token.id()).primaryCategory()));
            }
            catch (BadLocationException ex) {}
        }
    }

    private CharSequence evaluateMacro(CharSequence macro) {
        if (TokenUtilities.textEquals((CharSequence)macro, (CharSequence)"$$")) {
            return "$";
        }
        return "";
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new ShellEmbeddingProvider());
        }
    }
}

