/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.util.Properties;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public abstract class TriggeredGlobalProfilingPoint
extends GlobalProfilingPoint {
    static final String PROPERTY_TRIGGER = "p_triggcond";
    private TriggerCondition condition = new TriggerCondition();

    TriggeredGlobalProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, project, factory);
    }

    public void setCondition(TriggerCondition condition) {
        if (this.condition.equals(condition)) {
            return;
        }
        TriggerCondition oldCondition = this.condition;
        this.condition = condition;
        this.getChangeSupport().firePropertyChange(PROPERTY_TRIGGER, oldCondition, condition);
    }

    public TriggerCondition getCondition() {
        return this.condition;
    }

    public static class TriggerCondition {
        public static final String PROPERTY_TRIGGCOND_METRIC = "p_triggcond_metric";
        public static final String PROPERTY_TRIGGCOND_VALUE = "p_triggcond_value";
        public static final String PROPERTY_TRIGGCOND_ONETIME = "p_triggcond_onetime";
        public static final int METRIC_HEAPUSG = 1;
        public static final int METRIC_HEAPSIZ = 2;
        public static final int METRIC_SURVGEN = 3;
        public static final int METRIC_LDCLASS = 4;
        private boolean onetime;
        private boolean triggered;
        private int metric;
        private long value;

        public TriggerCondition() {
            this(1, 95L);
        }

        public TriggerCondition(int metric, long value) {
            this(metric, value, true);
        }

        public TriggerCondition(int metric, long value, boolean onetime) {
            this.setMetric(metric);
            this.setValue(value);
            this.setOnetime(onetime);
            this.setTriggered(false);
        }

        public void setMetric(int metric) {
            this.metric = metric;
        }

        public int getMetric() {
            return this.metric;
        }

        public void setOnetime(boolean onetime) {
            this.onetime = onetime;
        }

        public boolean isOnetime() {
            return this.onetime;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TriggerCondition)) {
                return false;
            }
            TriggerCondition condition = (TriggerCondition)object;
            return this.metric == condition.metric && this.value == condition.value && this.onetime == condition.onetime;
        }

        public int hashCode() {
            int hash = 3;
            hash = 61 * hash + (this.onetime ? 1 : 0);
            hash = 61 * hash + this.metric;
            hash = 61 * hash + (int)(this.value ^ this.value >>> 32);
            return hash;
        }

        public static TriggerCondition load(Lookup.Provider project, int index, Properties properties) {
            return TriggerCondition.load(project, index, null, properties);
        }

        public static TriggerCondition load(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            String metricStr = properties.getProperty(absPrefix + PROPERTY_TRIGGCOND_METRIC, null);
            String valueStr = properties.getProperty(absPrefix + PROPERTY_TRIGGCOND_VALUE, null);
            String onetimeStr = properties.getProperty(absPrefix + PROPERTY_TRIGGCOND_ONETIME, null);
            if (metricStr == null || valueStr == null || onetimeStr == null) {
                return null;
            }
            TriggerCondition condition = null;
            try {
                condition = new TriggerCondition(Integer.parseInt(metricStr), Long.parseLong(valueStr), Boolean.parseBoolean(onetimeStr));
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(65536, e.getMessage());
            }
            return condition;
        }

        public void store(Lookup.Provider project, int index, Properties properties) {
            this.store(project, index, null, properties);
        }

        public void store(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            properties.put(absPrefix + PROPERTY_TRIGGCOND_METRIC, Integer.toString(this.metric));
            properties.put(absPrefix + PROPERTY_TRIGGCOND_VALUE, Long.toString(this.value));
            properties.put(absPrefix + PROPERTY_TRIGGCOND_ONETIME, Boolean.toString(this.onetime));
        }

        void setTriggered(boolean triggered) {
            this.triggered = triggered;
        }

        boolean isTriggered() {
            return this.triggered;
        }
    }
}

