/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.io;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;

public class OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> {
    private long NumBuckets;
    private long NumEntries;
    private uchar.ptr Buckets;
    private uchar.ptr Base;
    private InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

    public OnDiskChainedHashTable(long numBuckets, long numEntries, uchar.ptr buckets, uchar.ptr base, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        this.NumBuckets = numBuckets;
        this.NumEntries = numEntries;
        this.Buckets = buckets;
        this.Base = base;
        this.InfoObj = InfoObj;
    }

    public long getNumBuckets() {
        return this.NumBuckets;
    }

    public long getNumEntries() {
        return this.NumEntries;
    }

    public uchar.ptr getBase() {
        return this.Base;
    }

    public uchar.ptr getBuckets() {
        return this.Buckets;
    }

    public boolean isEmpty() {
        return this.NumEntries == 0L;
    }

    public iterator find(external_key_type eKey) {
        return this.find(eKey, null);
    }

    public iterator find(external_key_type eKey, InfoInterface<external_key_type, internal_key_type, data_type> InfoPtr) {
        if (InfoPtr == null) {
            InfoPtr = this.InfoObj;
        }
        internal_key_type iKey = this.InfoObj.GetInternalKey(eKey);
        long key_hash = this.InfoObj.ComputeHash(iKey);
        long idx = key_hash & this.NumBuckets - 1L;
        uchar.ptr Bucket2 = (uchar.ptr)this.Buckets.$inc((long)NativeType.sizeof(Integer.class) * idx);
        long offset = io.ReadLE32(Bucket2);
        if (offset == 0L) {
            return new iterator();
        }
        uchar.ptr Items = (uchar.ptr)this.Base.$inc(offset);
        long len = io.ReadUnalignedLE16((type.ref<uchar.ptr>)new type.ptr.single((Object)Items));
        for (long i = 0L; i < len; ++i) {
            long item_hash = (int)io.ReadUnalignedLE32((type.ref<uchar.ptr>)new type.ptr.single((Object)Items));
            std.pairUIntUInt L = InfoPtr.ReadKeyDataLength((type.ref<uchar.ptr>)new type.ptr.single((Object)Items));
            long item_len = L.first + L.second;
            if (item_hash != key_hash) {
                Items.$inc(item_len);
                continue;
            }
            internal_key_type X = InfoPtr.ReadKey(Items, L.first);
            if (!InfoPtr.EqualKey(X, iKey)) {
                Items.$inc(item_len);
                continue;
            }
            return new iterator(X, (uchar.ptr)Items.$inc(L.first), L.second, InfoPtr);
        }
        return new iterator();
    }

    public iterator end() {
        return new iterator();
    }

    public key_iterator key_begin() {
        return new key_iterator((uchar.ptr)this.Base.$inc(4), this.getNumEntries(), this.InfoObj);
    }

    public key_iterator key_end() {
        return new key_iterator(this.InfoObj);
    }

    public data_iterator data_begin() {
        return new data_iterator((uchar.ptr)this.Base.$inc(4), this.getNumEntries(), this.InfoObj);
    }

    public data_iterator data_end() {
        return new data_iterator(this.InfoObj);
    }

    public InfoInterface<external_key_type, internal_key_type, data_type> getInfoObj() {
        return this.InfoObj;
    }

    public static <Info extends InfoInterface<external_key_type, internal_key_type, data_type>, external_key_type, internal_key_type, data_type> OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> Create(uchar.ptr buckets, uchar.ptr base, Info InfoObj) {
        assert (buckets != null) : base;
        long numBuckets = io.ReadLE32(buckets);
        long numEntries = io.ReadLE32(buckets);
        return new OnDiskChainedHashTable<external_key_type, internal_key_type, data_type>(numBuckets, numEntries, buckets, base, InfoObj);
    }

    public static interface InfoInterface<external_key_type, internal_key_type, data_type> {
        public data_type ReadData(internal_key_type var1, uchar.ptr var2, long var3);

        public internal_key_type GetInternalKey(external_key_type var1);

        public external_key_type GetExternalKey(internal_key_type var1);

        public long ComputeHash(internal_key_type var1);

        public std.pairUIntUInt ReadKeyDataLength(type.ref<uchar.ptr> var1);

        public internal_key_type ReadKey(uchar.ptr var1, long var2);

        public boolean EqualKey(internal_key_type var1, internal_key_type var2);
    }

    public class data_iterator
    implements Native.NativeComparable<data_iterator>,
    NativeCloneable<data_iterator> {
        private uchar.ptr Ptr;
        private long NumItemsInBucketLeft;
        private long NumEntriesLeft;
        private InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        public data_iterator(uchar.ptr Ptr, long NumEntries, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Ptr = Ptr;
            this.NumItemsInBucketLeft = 0L;
            this.NumEntriesLeft = NumEntries;
            this.InfoObj = InfoObj;
        }

        public data_iterator(InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Ptr = null;
            this.NumItemsInBucketLeft = 0L;
            this.NumEntriesLeft = 0L;
            this.InfoObj = InfoObj;
        }

        public boolean $eq(data_iterator X) {
            return Native.$eq((long)X.NumEntriesLeft, (long)this.NumEntriesLeft);
        }

        public boolean $noteq(data_iterator X) {
            return Native.$noteq((long)X.NumEntriesLeft, (long)this.NumEntriesLeft);
        }

        public data_iterator $preInc() {
            if (this.NumItemsInBucketLeft == 0L) {
                this.NumItemsInBucketLeft = io.ReadUnalignedLE16((type.ref<uchar.ptr>)new type.ptr.single((Object)this.Ptr));
            }
            this.Ptr.$inc(4);
            std.pairUIntUInt L = this.InfoObj.ReadKeyDataLength((type.ref<uchar.ptr>)new type.ptr.single((Object)this.Ptr));
            this.Ptr.$inc(L.first + L.second);
            assert (this.NumItemsInBucketLeft != 0L);
            --this.NumItemsInBucketLeft;
            assert (this.NumEntriesLeft != 0L);
            --this.NumEntriesLeft;
            return this;
        }

        public data_iterator $postInc(int $Prm0) {
            data_iterator tmp = this.clone();
            this.$preInc();
            return tmp;
        }

        public data_type $star() {
            uchar.ptr LocalPtr = this.Ptr;
            if (this.NumItemsInBucketLeft == 0L) {
                LocalPtr.$inc(2);
            }
            LocalPtr.$inc(4);
            std.pairUIntUInt L = this.InfoObj.ReadKeyDataLength((type.ref<uchar.ptr>)new type.ptr.single((Object)LocalPtr));
            Object Key = this.InfoObj.ReadKey(LocalPtr, L.first);
            return this.InfoObj.ReadData(Key, (uchar.ptr)LocalPtr.$inc(L.first), L.second);
        }

        public data_iterator clone() {
            try {
                return (data_iterator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public class key_iterator
    implements NativeCloneable<key_iterator> {
        private uchar.ptr Ptr;
        private long NumItemsInBucketLeft;
        private long NumEntriesLeft;
        private InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        public key_iterator(uchar.ptr Ptr, long NumEntries, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Ptr = Ptr;
            this.NumItemsInBucketLeft = 0L;
            this.NumEntriesLeft = NumEntries;
            this.InfoObj = InfoObj;
        }

        public key_iterator(InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.Ptr = null;
            this.NumItemsInBucketLeft = 0L;
            this.NumEntriesLeft = 0L;
            this.InfoObj = InfoObj;
        }

        public key_iterator $preInc() {
            if (this.NumItemsInBucketLeft == 0L) {
                this.NumItemsInBucketLeft = io.ReadUnalignedLE16((type.ref<uchar.ptr>)new type.ptr.single((Object)this.Ptr));
            }
            this.Ptr.$inc(4);
            std.pairUIntUInt L = this.InfoObj.ReadKeyDataLength((type.ref<uchar.ptr>)new type.ptr.single((Object)this.Ptr));
            this.Ptr.$inc(L.first + L.second);
            assert (this.NumItemsInBucketLeft != 0L);
            --this.NumItemsInBucketLeft;
            assert (this.NumEntriesLeft != 0L);
            --this.NumEntriesLeft;
            return this;
        }

        public key_iterator $postInc(int $Prm0) {
            key_iterator tmp = this.clone();
            this.$preInc();
            return tmp;
        }

        public external_key_type $star() {
            uchar.ptr LocalPtr = this.Ptr;
            if (this.NumItemsInBucketLeft == 0L) {
                LocalPtr.$inc(2);
            }
            LocalPtr.$inc(4);
            std.pairUIntUInt L = this.InfoObj.ReadKeyDataLength((type.ref<uchar.ptr>)new type.ptr.single((Object)LocalPtr));
            Object Key = this.InfoObj.ReadKey(LocalPtr, L.first);
            return this.InfoObj.GetExternalKey(Key);
        }

        public key_iterator clone() {
            try {
                return (key_iterator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public class iterator
    implements Native.NativeComparable<iterator> {
        private internal_key_type key;
        private uchar.ptr data;
        private long len;
        private InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        public iterator() {
            this.data = null;
            this.len = 0L;
        }

        public iterator(internal_key_type k, uchar.ptr d, long l, InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.key = k;
            this.data = d;
            this.len = l;
            this.InfoObj = InfoObj;
        }

        public data_type $star() {
            return this.InfoObj.ReadData(this.key, this.data, this.len);
        }

        public boolean $eq(iterator X) {
            return Native.$eq((abstract_iterator)X.data, (abstract_iterator)this.data);
        }

        public boolean $noteq(iterator X) {
            return Native.$noteq((abstract_iterator)X.data, (abstract_iterator)this.data);
        }
    }
}

