/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.ClangGlobals;
import org.clang.basic.impl.VersionTupleStatics;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.uint;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.NoneType;
import org.llvm.adt.StringRef;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;

public class VersionTuple {
    long Major;
    long Minor;
    long Subminor;
    private boolean HasMinor;
    private boolean HasSubminor;
    private boolean UsesUnderscores;

    public VersionTuple() {
        this.Major = 0L;
        this.Minor = 0L;
        this.Subminor = 0L;
        this.HasMinor = false;
        this.HasSubminor = false;
        this.UsesUnderscores = false;
    }

    public VersionTuple(long Major) {
        this.Major = Major;
        this.Minor = 0L;
        this.Subminor = 0L;
        this.HasMinor = false;
        this.HasSubminor = false;
        this.UsesUnderscores = false;
    }

    public VersionTuple(long Major, long Minor) {
        this(Major, Minor, false);
    }

    public VersionTuple(long Major, long Minor, boolean UsesUnderscores) {
        this.Major = Major;
        this.Minor = Minor;
        this.Subminor = 0L;
        this.HasMinor = true;
        this.HasSubminor = false;
        this.UsesUnderscores = UsesUnderscores;
    }

    public VersionTuple(long Major, long Minor, long Subminor) {
        this(Major, Minor, Subminor, false);
    }

    public VersionTuple(long Major, long Minor, long Subminor, boolean UsesUnderscores) {
        this.Major = Major;
        this.Minor = Minor;
        this.Subminor = Subminor;
        this.HasMinor = true;
        this.HasSubminor = true;
        this.UsesUnderscores = UsesUnderscores;
    }

    public boolean empty() {
        return this.Major == 0L && this.Minor == 0L && this.Subminor == 0L;
    }

    public long getMajor() {
        return this.Major;
    }

    public ADTAliases.OptionalUInt getMinor() {
        if (!this.HasMinor) {
            return new ADTAliases.OptionalUInt(NoneType.None);
        }
        return new ADTAliases.OptionalUInt(this.Minor);
    }

    public ADTAliases.OptionalUInt getSubminor() {
        if (!this.HasSubminor) {
            return new ADTAliases.OptionalUInt(NoneType.None);
        }
        return new ADTAliases.OptionalUInt(this.Subminor);
    }

    public boolean usesUnderscores() {
        return this.UsesUnderscores;
    }

    public void UseDotAsSeparator() {
        this.UsesUnderscores = false;
    }

    public static boolean $eq_VersionTuple(VersionTuple X, VersionTuple Y) {
        return X.Major == Y.Major && X.Minor == Y.Minor && X.Subminor == Y.Subminor;
    }

    public static boolean $noteq_VersionTuple(VersionTuple X, VersionTuple Y) {
        return !VersionTuple.$eq_VersionTuple(X, Y);
    }

    public static boolean $greater_VersionTuple(VersionTuple X, VersionTuple Y) {
        return ClangGlobals.$less_VersionTuple(Y, X);
    }

    public static boolean $lesseq_VersionTuple(VersionTuple X, VersionTuple Y) {
        return !ClangGlobals.$less_VersionTuple(Y, X);
    }

    public static boolean $greatereq_VersionTuple(VersionTuple X, VersionTuple Y) {
        return !ClangGlobals.$less_VersionTuple(X, Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string getAsString() {
        std.string Result = null;
        try {
            Result = new std.string();
            raw_string_ostream Out = null;
            try {
                Out = new raw_string_ostream(Result);
                ClangGlobals.$out_raw_ostream_VersionTuple((raw_ostream)Out, this);
            }
            finally {
                if (Out != null) {
                    Out.$destroy();
                }
            }
            std.string string2 = new std.string(Result);
            return string2;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public boolean tryParse(StringRef input) {
        uint.ref major = NativePointer.create_uint$ref();
        uint.ref minor = NativePointer.create_uint$ref();
        uint.ref micro = NativePointer.create_uint$ref();
        if (VersionTupleStatics.parseInt(input, major)) {
            return true;
        }
        if (input.empty()) {
            this.$assign(new VersionTuple(major.$deref()));
            return false;
        }
        if (input.$at(0) != NativePointer.$((char)'.')) {
            return true;
        }
        input.$assign$substr(1);
        if (VersionTupleStatics.parseInt(input, minor)) {
            return true;
        }
        if (input.empty()) {
            this.$assign(new VersionTuple(major.$deref(), minor.$deref()));
            return false;
        }
        if (input.$at(0) != NativePointer.$((char)'.')) {
            return true;
        }
        input.$assign$substr(1);
        if (VersionTupleStatics.parseInt(input, micro)) {
            return true;
        }
        if (!input.empty()) {
            return true;
        }
        this.$assign(new VersionTuple(major.$deref(), minor.$deref(), micro.$deref()));
        return false;
    }

    public VersionTuple $assign(VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.Minor = $Prm0.Minor;
        this.Subminor = $Prm0.Subminor;
        this.HasMinor = $Prm0.HasMinor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
        return this;
    }

    public String toString() {
        return "Major=" + this.Major + ", Minor=" + this.Minor + ", Subminor=" + this.Subminor + ", HasMinor=" + this.HasMinor + ", HasSubminor=" + this.HasSubminor + ", UsesUnderscores=" + this.UsesUnderscores;
    }

    public VersionTuple(VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.Minor = $Prm0.Minor;
        this.Subminor = $Prm0.Subminor;
        this.HasMinor = $Prm0.HasMinor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
    }
}

