/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.SparcTargetInfo;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class SparcV9TargetInfo
extends SparcTargetInfo {
    public SparcV9TargetInfo(Triple _Triple) {
        super(_Triple);
        this.DescriptionString = NativePointer.$((String)"E-m:e-i64:64-n32:64-S128");
        this.PointerAlign = (short)64;
        this.PointerWidth = (short)64;
        this.LongAlign = (short)64;
        this.LongWidth = (short)64;
        this.IntMaxType = this.getTriple().getOS() == Triple.OSType.OpenBSD ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.Int64Type = this.IntMaxType;
        this.LongDoubleWidth = (short)128;
        this.LongDoubleAlign = (short)128;
        this.LongDoubleFormat = APFloat.IEEEquad;
        this.MaxAtomicInlineWidth = (short)64;
        this.MaxAtomicPromoteWidth = (short)64;
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder) {
        super.getTargetDefines(Opts, Builder);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__sparcv9")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__arch64__")));
        if (this.getTriple().getOS() != Triple.OSType.Solaris) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__sparc64__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__sparc_v9__")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"__sparcv9__")));
        }
    }

    @Override
    public boolean setCPU(std.string Name) {
        boolean CPUKnown = (Boolean)new StringSwitch(new StringRef(Name)).Case(NativePointer.$((String)"v9"), (Object)true).Case(NativePointer.$((String)"ultrasparc"), (Object)true).Case(NativePointer.$((String)"ultrasparc3"), (Object)true).Case(NativePointer.$((String)"niagara"), (Object)true).Case(NativePointer.$((String)"niagara2"), (Object)true).Case(NativePointer.$((String)"niagara3"), (Object)true).Case(NativePointer.$((String)"niagara4"), (Object)true).Default((Object)false);
        return CPUKnown;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

