/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.ARMleTargetInfo;
import org.clang.basic.target.impl.WindowsTargetInfo;
import org.clank.support.NativePointer;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class WindowsARMTargetInfo
extends WindowsTargetInfo<ARMleTargetInfo> {
    private Triple _Triple;

    public WindowsARMTargetInfo(Triple Triple2) {
        super(new ARMleTargetInfo(Triple2), Triple2);
        this._Triple = new Triple(Triple2);
        this.TLSSupported = false;
        this.WCharType = TargetInfo.IntType.UnsignedShort;
        this.SizeType = TargetInfo.IntType.UnsignedInt;
        this.UserLabelPrefix = NativePointer.$((String)"");
    }

    @Override
    public void getVisualStudioDefines(LangOptions Opts, MacroBuilder Builder) {
        super.getVisualStudioDefines(Opts, Builder);
        Builder.defineMacro(new Twine(NativePointer.$((String)"_M_ARM_NT")), new Twine(NativePointer.$((String)"1")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"_M_ARMT")), new Twine(NativePointer.$((String)"_M_ARM")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"_M_THUMB")), new Twine(NativePointer.$((String)"_M_ARM")));
        assert (this._Triple.getArch() == Triple.ArchType.arm || this._Triple.getArch() == Triple.ArchType.thumb) : "invalid architecture for Windows ARM target info";
        int Offset = this._Triple.getArch() == Triple.ArchType.arm ? 4 : 6;
        Builder.defineMacro(new Twine(NativePointer.$((String)"_M_ARM")), new Twine(this._Triple.getArchName().substr(Offset)));
        Builder.defineMacro(new Twine(NativePointer.$((String)"_M_ARM_FP")), new Twine(NativePointer.$((String)"31")));
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    @Override
    public String toString() {
        return "Triple=" + this._Triple + super.toString();
    }
}

