/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.vfs;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;

public class Status
implements Destructors.ClassWithDestructor {
    private std.string Name;
    private fs.UniqueID UID;
    private TimeValue MTime;
    private long User;
    private long Group;
    private long Size;
    private fs.file_type Type;
    private fs.perms Perms;
    public boolean IsVFSMapped;

    public Status() {
        this.Name = new std.string();
        this.UID = new fs.UniqueID();
        this.MTime = new TimeValue();
        this.Type = fs.file_type.status_error;
    }

    public Status(fs.file_status Status2) {
        this.Name = new std.string();
        this.UID = new fs.UniqueID(Status2.getUniqueID());
        this.MTime = new TimeValue(Status2.getLastModificationTime());
        this.User = Status2.getUser();
        this.Group = Status2.getGroup();
        this.Size = Status2.getSize();
        this.Type = Status2.type();
        this.Perms = Status2.permissions();
        this.IsVFSMapped = false;
    }

    public Status(StringRef Name, StringRef ExternalName, fs.UniqueID UID, TimeValue MTime, long User, long Group, long Size, fs.file_type Type2, fs.perms Perms) {
        this.Name = new std.string(Name.$basic_string());
        this.UID = new fs.UniqueID(UID);
        this.MTime = new TimeValue(MTime);
        this.User = User;
        this.Group = Group;
        this.Size = Size;
        this.Type = Type2;
        this.Perms = Perms;
        this.IsVFSMapped = false;
    }

    public StringRef getName() {
        return new StringRef(this.Name);
    }

    public void setName(StringRef N) {
        this.Name.$assign(N.$basic_string());
    }

    public fs.file_type getType() {
        return this.Type;
    }

    public fs.perms getPermissions() {
        return this.Perms;
    }

    public TimeValue getLastModificationTime() {
        return this.MTime;
    }

    public fs.UniqueID getUniqueID() {
        return this.UID;
    }

    public long getUser() {
        return this.User;
    }

    public long getGroup() {
        return this.Group;
    }

    public long getSize() {
        return this.Size;
    }

    public void setType(fs.file_type v) {
        this.Type = v;
    }

    public void setPermissions(fs.perms p) {
        this.Perms = p;
    }

    public boolean equivalent(Status Other) {
        return this.getUniqueID().$eq(Other.getUniqueID());
    }

    public boolean isDirectory() {
        return this.Type == fs.file_type.directory_file;
    }

    public boolean isRegularFile() {
        return this.Type == fs.file_type.regular_file;
    }

    public boolean isOther() {
        return this.exists() && !this.isRegularFile() && !this.isDirectory() && !this.isSymlink();
    }

    public boolean isSymlink() {
        return this.Type == fs.file_type.symlink_file;
    }

    public boolean isStatusKnown() {
        return this.Type != fs.file_type.status_error;
    }

    public boolean exists() {
        return this.isStatusKnown() && this.Type != fs.file_type.file_not_found;
    }

    public Status(Status $Prm0) {
        this.Name = new std.string($Prm0.Name);
        this.UID = new fs.UniqueID($Prm0.UID);
        this.MTime = new TimeValue($Prm0.MTime);
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
    }

    public Status $assign(Status $Prm0) {
        this.Name.$assign($Prm0.Name);
        this.UID.$assign($Prm0.UID);
        this.MTime = $Prm0.MTime;
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
        return this;
    }

    public void $destroy() {
        this.Name.$destroy();
    }

    public String toString() {
        return "Name=" + this.Name + ", UID=" + this.UID + ", MTime=" + this.MTime + ", User=" + this.User + ", Group=" + this.Group + ", Size=" + this.Size + ", Type=" + this.Type + ", Perms=" + this.Perms + ", IsVFSMapped=" + this.IsVFSMapped;
    }
}

