/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;

public class MakeOptions
extends SharedClassObject
implements PropertyChangeListener {
    private static MakeOptions instance = null;
    private static final String MAKE_OPTIONS = "makeOptions";
    private static String defaultMakeOptions = "";
    private static final String PATH_MODE = "pathMode";
    private static final String DEF_EXE_PERM = "defexeperm";
    private static final String DEF_FILE_PERM = "deffileperm";
    private static final String DEF_OWNER = "defowner";
    private static final String DEF_GROUP = "defgroup";
    private static final String PREF_APP_LANGUAGE = "prefAppLanguage";
    public static final String USE_BUILD_TRACE = "useBuildTrace";

    public static MakeOptions getInstance() {
        if (instance == null) {
            instance = (MakeOptions)SharedClassObject.findObject(MakeOptions.class, (boolean)true);
        }
        return instance;
    }

    public static void setDefaultMakeOptions(String makeOptions) {
        defaultMakeOptions = makeOptions;
    }

    public static String getDefaultMakeOptions() {
        return defaultMakeOptions;
    }

    public MakeOptions() {
        this.addPropertyChangeListener(this);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MakeOptions.class);
    }

    public String getMakeOptions() {
        return this.getPreferences().get(MAKE_OPTIONS, MakeOptions.getDefaultMakeOptions());
    }

    public void setMakeOptions(String value) {
        String oldValue = this.getMakeOptions();
        this.getPreferences().put(MAKE_OPTIONS, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(MAKE_OPTIONS, oldValue, value);
        }
    }

    public MakeProjectOptions.PathMode getPathMode() {
        MakeProjectOptions.PathMode defaultValue = MakeProjectOptions.PathMode.REL;
        String stringValue = this.getPreferences().get(PATH_MODE, defaultValue.name());
        if (Character.isDigit(stringValue.charAt(0))) {
            int intValue;
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            for (MakeProjectOptions.PathMode pathMode : MakeProjectOptions.PathMode.values()) {
                if (pathMode.ordinal() != intValue) continue;
                return pathMode;
            }
            return defaultValue;
        }
        return MakeProjectOptions.PathMode.valueOf(stringValue);
    }

    public void setPathMode(MakeProjectOptions.PathMode pathMode) {
        MakeProjectOptions.PathMode oldValue = this.getPathMode();
        this.getPreferences().put(PATH_MODE, pathMode.name());
        if (oldValue != pathMode) {
            this.firePropertyChange(PATH_MODE, (Object)oldValue, (Object)pathMode);
        }
    }

    public boolean getDepencyChecking() {
        return NamedOption.getAccessor().getBoolean("dependencyChecking");
    }

    public boolean getRebuildPropChanged() {
        return NamedOption.getAccessor().getBoolean("rebuildPropChanged");
    }

    public boolean getResolveSymbolicLinks() {
        return NamedOption.getAccessor().getBoolean("resolveSymbolicLinks");
    }

    public boolean getViewBinaryFiles() {
        return NamedOption.getAccessor().getBoolean("viewBinaryFiles");
    }

    public boolean getSave() {
        return NamedOption.getAccessor().getBoolean("save");
    }

    public boolean getReuse() {
        return NamedOption.getAccessor().getBoolean("reuse");
    }

    public boolean getShowConfigurationWarning() {
        return NamedOption.getAccessor().getBoolean("showConfigurationWarning");
    }

    public void setShowConfigurationWarning(boolean val) {
        NamedOption.getAccessor().setBoolean("showConfigurationWarning", val);
    }

    public String getDefExePerm() {
        return this.getPreferences().get(DEF_EXE_PERM, "755");
    }

    public void setDefExePerm(String value) {
        String oldValue = this.getDefExePerm();
        this.getPreferences().put(DEF_EXE_PERM, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_EXE_PERM, oldValue, value);
        }
    }

    public String getDefFilePerm() {
        return this.getPreferences().get(DEF_FILE_PERM, "644");
    }

    public void setDefFilePerm(String value) {
        String oldValue = this.getDefFilePerm();
        this.getPreferences().put(DEF_FILE_PERM, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_FILE_PERM, oldValue, value);
        }
    }

    public String getDefOwner() {
        return this.getPreferences().get(DEF_OWNER, "root");
    }

    public void setDefOwner(String value) {
        String oldValue = this.getDefOwner();
        this.getPreferences().put(DEF_OWNER, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_OWNER, oldValue, value);
        }
    }

    public String getDefGroup() {
        return this.getPreferences().get(DEF_GROUP, "bin");
    }

    public void setDefGroup(String value) {
        String oldValue = this.getDefGroup();
        this.getPreferences().put(DEF_GROUP, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_GROUP, oldValue, value);
        }
    }

    public String getPrefApplicationLanguage() {
        return this.getPreferences().get(PREF_APP_LANGUAGE, "C++");
    }

    public void setPrefApplicationLanguage(String value) {
        String oldValue = this.getPrefApplicationLanguage();
        this.getPreferences().put(PREF_APP_LANGUAGE, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(PREF_APP_LANGUAGE, oldValue, value);
        }
    }

    public boolean isFullFileIndexer() {
        return CndTraceFlags.USE_INDEXING_API;
    }

    public boolean isFixUnresolvedInclude() {
        return NamedOption.getAccessor().getBoolean("fixUnresolvedInclude");
    }

    public void setFixUnresolvedInclude(boolean value) {
        NamedOption.getAccessor().setBoolean("fixUnresolvedInclude", value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }
}

