/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Utilities;

public class MakeTemplateListener
implements OperationListener {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MakeTemplateListener.class.getName());
    private static final String ADD_TO_LOGICAL_FOLDER_ATTRIBUTE = "addToLogicalFolder";
    private static MakeTemplateListener INSTANCE;
    private Project contextProject;
    private MakeConfigurationDescriptor contextCD;

    static MakeTemplateListener getInstance() {
        return INSTANCE;
    }

    static synchronized MakeTemplateListener createInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MakeTemplateListener();
            DataLoaderPool.getDefault().addOperationListener((OperationListener)INSTANCE);
        }
        return INSTANCE;
    }

    private MakeTemplateListener() {
    }

    public void operationPostCreate(OperationEvent operationEvent) {
    }

    public void operationCopy(OperationEvent.Copy copy) {
    }

    public void operationMove(OperationEvent.Move move) {
    }

    public void operationDelete(OperationEvent operationEvent) {
    }

    public void operationRename(OperationEvent.Rename rename) {
    }

    public void operationCreateShadow(OperationEvent.Copy copy) {
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project p) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return null;
        }
        return pdp.getConfigurationDescriptor();
    }

    void setContext(Project contextProject, MakeConfigurationDescriptor contextCD) {
        this.contextProject = contextProject;
        this.contextCD = contextCD;
    }

    void clearContext() {
        this.contextProject = null;
        this.contextCD = null;
    }

    public void operationCreateFromTemplate(OperationEvent.Copy copy) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        boolean addToLogicalFolder;
        FileObject originalPrimaryFile;
        Folder folder = (Folder)Utilities.actionsGlobalContext().lookup(Folder.class);
        Project project = folder != null ? folder.getProject() : (Project)Utilities.actionsGlobalContext().lookup(Project.class);
        DataObject originalDataObject = copy.getOriginalDataObject();
        if (originalDataObject != null && (originalPrimaryFile = originalDataObject.getPrimaryFile()) != null && originalPrimaryFile.getAttribute(ADD_TO_LOGICAL_FOLDER_ATTRIBUTE) != null && !(addToLogicalFolder = ((Boolean)originalPrimaryFile.getAttribute(ADD_TO_LOGICAL_FOLDER_ATTRIBUTE)).booleanValue())) {
            return;
        }
        if (folder == null || project == null) {
            DataObject od = (DataObject)Utilities.actionsGlobalContext().lookup(DataObject.class);
            if (od == null) {
                od = copy.getObject();
            }
            if (od == null) {
                return;
            }
            FileObject file = od.getPrimaryFile();
            if (file == null) {
                return;
            }
            if (this.contextProject != null && this.contextCD != null) {
                project = this.contextProject;
                makeConfigurationDescriptor = this.contextCD;
            } else {
                project = FileOwnerQuery.getOwner((FileObject)file);
                if (project == null) {
                    return;
                }
                makeConfigurationDescriptor = this.getMakeConfigurationDescriptor(project);
                if (makeConfigurationDescriptor == null) {
                    return;
                }
            }
            folder = makeConfigurationDescriptor.getLogicalFolders();
        } else {
            makeConfigurationDescriptor = this.getMakeConfigurationDescriptor(project);
            if (makeConfigurationDescriptor == null) {
                return;
            }
        }
        FileObject file = copy.getObject().getPrimaryFile();
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "processing file=" + file);
            ERR.log(1, "FileUtil.toFile(file.getPrimaryFile())=" + FileUtil.toFile((FileObject)file));
            ERR.log(1, "into folder = " + folder);
            ERR.log(1, "in project = " + project.getProjectDirectory());
        }
        if (owner != null && owner.getProjectDirectory() == project.getProjectDirectory()) {
            if (file.isFolder()) {
                return;
            }
            if (!makeConfigurationDescriptor.okToChange()) {
                return;
            }
            String itemPath = ProjectSupport.toProperPath(makeConfigurationDescriptor.getBaseDirFileObject(), file, project);
            itemPath = CndPathUtilities.normalizeSlashes((String)itemPath);
            Item item = Item.createInFileSystem(makeConfigurationDescriptor.getBaseDirFileSystem(), itemPath);
            if (!folder.isDiskFolder()) {
                folder = this.changeFolder(folder, file);
            }
            folder.addItemAction(item);
            makeConfigurationDescriptor.save();
            if (ERR.isLoggable(1)) {
                ERR.log(1, "folder: " + folder + ", added: " + file);
            }
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "not adding: " + file + " because it is not owned by this project");
        }
    }

    private Folder changeFolder(Folder folder, FileObject file) {
        block3: {
            Folder parent;
            String preferedFolder;
            block4: {
                if (folder.getKind() != Folder.Kind.ROOT) break block4;
                String preferedFolder2 = this.preferedFolder(file);
                if (preferedFolder2 == null) break block3;
                for (Folder f : folder.getFolders()) {
                    if (f.getKind() != Folder.Kind.SOURCE_LOGICAL_FOLDER || !preferedFolder2.equals(f.getName())) continue;
                    folder = f;
                    break block3;
                }
                break block3;
            }
            if (folder.getKind() == Folder.Kind.SOURCE_LOGICAL_FOLDER && (preferedFolder = this.preferedFolder(file)) != null && (parent = folder.getParent()) != null) {
                for (Folder f : parent.getFolders()) {
                    if (f.getKind() != Folder.Kind.SOURCE_LOGICAL_FOLDER || !preferedFolder.equals(f.getName())) continue;
                    folder = f;
                    break;
                }
            }
        }
        return folder;
    }

    private String preferedFolder(FileObject fo) {
        String mimeType = fo.getMIMEType();
        if (MIMENames.isCppOrCOrFortran((String)mimeType)) {
            return "SourceFiles";
        }
        if (MIMENames.isHeader((String)mimeType)) {
            return "HeaderFiles";
        }
        if ("text/qtui+xml".equals(mimeType) || "text/qtresource+xml".equals(mimeType) || "text/qttranslation+xml".equals(mimeType)) {
            return "ResourceFiles";
        }
        return null;
    }
}

