/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.Mutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class NativeProjectSettingsImpl
implements NativeProjectSettings {
    private final Project project;
    private static final String CodeAssistanceData = "code-assistance-data";
    private static final String CodeModelEnabled = "code-model-enabled";
    private final String namespace;
    private final boolean shared;

    public NativeProjectSettingsImpl(MakeProject prj, String namespace, boolean shared) {
        this.shared = shared;
        this.project = prj;
        this.namespace = namespace;
    }

    public boolean isCodeAssistanceEnabled() {
        String value = this.doLoad(CodeModelEnabled);
        return this.str2bool(value);
    }

    public void setCodeAssistanceEnabled(boolean enabled) {
        this.doSave(CodeModelEnabled, Boolean.toString(enabled));
    }

    private boolean str2bool(String value) {
        return value == null || value.length() == 0 || Boolean.parseBoolean(value);
    }

    private Element getConfigurationFragment() {
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        Element data = aux.getConfigurationFragment(CodeAssistanceData, this.namespace, this.shared);
        if (data == null) {
            data = NativeProjectSettingsImpl.createDocument(this.namespace, this.shared ? "project" : "project-private").createElementNS(this.namespace, CodeAssistanceData);
        }
        if (data == null) {
            System.err.println("CodeAssistanceOptions: Failed to load and create configuration fragment (code-assistance-data : " + this.namespace + ")");
        }
        return data;
    }

    private Element getNode(Element configurationFragment, String name) {
        Element node;
        NodeList nodes = configurationFragment.getElementsByTagNameNS(this.namespace, name);
        if (nodes.getLength() == 0) {
            node = configurationFragment.getOwnerDocument().createElementNS(this.namespace, name);
            configurationFragment.appendChild(node);
        } else {
            node = (Element)nodes.item(0);
        }
        return node;
    }

    private String doLoad(final String name) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element configurationFragment = NativeProjectSettingsImpl.this.getConfigurationFragment();
                if (configurationFragment == null) {
                    return null;
                }
                return NativeProjectSettingsImpl.this.getNode(configurationFragment, name).getTextContent();
            }
        });
    }

    private void doSave(final String name, final String value) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element configurationFragment = NativeProjectSettingsImpl.this.getConfigurationFragment();
                if (configurationFragment != null) {
                    Element el = NativeProjectSettingsImpl.this.getNode(configurationFragment, name);
                    el.setTextContent(value);
                    AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)NativeProjectSettingsImpl.this.project);
                    aux.putConfigurationFragment(configurationFragment, NativeProjectSettingsImpl.this.shared);
                }
            }
        });
    }

    private static Document createDocument(String ns, String root) throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(ns, root, null);
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(ex);
        }
    }
}

