/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectChangeSupport;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.runprofiles.ui.RerunArguments;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.SelectExecutablePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.execution.IOTabsController;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ProjectActionSupport {
    private static ProjectActionSupport instance;
    private static final RequestProcessor RP;
    private static final RequestProcessor tasksProcessor;
    private static final Logger LOGGER;
    private final List<ProjectActionHandlerFactory> handlerFactories = new ArrayList<ProjectActionHandlerFactory>(Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class));

    private ProjectActionSupport() {
    }

    public static synchronized ProjectActionSupport getInstance() {
        if (instance == null) {
            instance = new ProjectActionSupport();
        }
        return instance;
    }

    private static boolean isFileOperationsIntensive(ProjectActionEvent pae) {
        ProjectActionEvent.Type type = pae.getType();
        return type == ProjectActionEvent.PredefinedType.PRE_BUILD || type == ProjectActionEvent.PredefinedType.BUILD || type == ProjectActionEvent.PredefinedType.CLEAN || type == ProjectActionEvent.PredefinedType.BUILD_TESTS;
    }

    private static void refreshProjectFilesOnFinish(final ProjectActionEvent curPAE, final FileOperationsNotifier fon) {
        try {
            SourceGroup[] groups;
            if (curPAE.getType() != ProjectActionEvent.PredefinedType.RUN && !fon.isLastExpectedEvent(curPAE)) {
                return;
            }
            final Project project = curPAE.getProject();
            final HashSet<File> files = new HashSet<File>();
            final HashSet<FileObject> fileObjects = new HashSet<FileObject>();
            FileObject projectFileObject = project.getProjectDirectory();
            File f = FileUtil.toFile((FileObject)projectFileObject);
            if (f != null) {
                files.add(f);
            } else {
                fileObjects.add(projectFileObject);
            }
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : groups = sources.getSourceGroups("generic")) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                File file = FileUtil.toFile((FileObject)rootFolder);
                if (file != null) {
                    files.add(file);
                    continue;
                }
                fileObjects.add(rootFolder);
            }
            final Runnable refresher = new Runnable(){

                @Override
                public void run() {
                    File[] array = files.toArray(new File[files.size()]);
                    if (array.length > 0) {
                        FileUtil.refreshFor((File[])array);
                    }
                    if (!fileObjects.isEmpty()) {
                        for (FileObject fo : fileObjects) {
                            FileSystemProvider.scheduleRefresh((FileObject)fo);
                        }
                    }
                }
            };
            RP.post(new Runnable(){

                @Override
                public void run() {
                    FileUtil.runAtomicAction((Runnable)refresher);
                    fon.onFinish(curPAE);
                    MakeLogicalViewProvider.refreshBrokenItems(project);
                }
            });
            ConfigurationDescriptorProvider.SnapShot snapShot = (ConfigurationDescriptorProvider.SnapShot)curPAE.getContext().lookup(ConfigurationDescriptorProvider.SnapShot.class);
            if (snapShot != null) {
                ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                cdp.endModifications(snapShot, true, LOGGER);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Cannot refresh project files", e);
        }
    }

    public boolean canHandle(MakeConfiguration conf, Lookup context, ProjectActionEvent.Type type) {
        DebuggerChooserConfiguration chooser;
        CustomizerNode node;
        if (conf != null && (node = (chooser = conf.getDebuggerChooserConfiguration()).getNode()) instanceof ProjectActionHandlerFactory && ((ProjectActionHandlerFactory)((Object)node)).canHandle(type, context, conf)) {
            return true;
        }
        for (ProjectActionHandlerFactory factory : this.handlerFactories) {
            if (!factory.canHandle(type, context, conf)) continue;
            return true;
        }
        return false;
    }

    public void fireActionPerformed(ProjectActionEvent[] paes) {
        this.fireActionPerformed(paes, null);
    }

    public void fireActionPerformed(ProjectActionEvent[] paes, ProjectActionHandler preferredHandler) {
        ProjectActionSupport.submitTask(new EventsProcessor(paes, preferredHandler));
    }

    private static void submitTask(EventsProcessor eventsProcessor) {
        tasksProcessor.post((Runnable)eventsProcessor);
    }

    private static boolean checkProject(ProjectActionEvent pae) {
        FileObject projectDirectory;
        Project project = pae.getProject();
        if (project != null && (CndUtils.isUnitTestMode() || OpenProjects.getDefault().isProjectOpen(project)) && (projectDirectory = project.getProjectDirectory()) != null) {
            FileObject nbproject = projectDirectory.getFileObject("nbproject");
            return nbproject != null && nbproject.isValid();
        }
        return false;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ProjectActionSupport.class, (String)s);
    }

    private static String getString(String s, String ... arg) {
        return NbBundle.getMessage(ProjectActionSupport.class, (String)s, (Object[])arg);
    }

    static {
        RP = new RequestProcessor("ProjectActionSupport.refresh", 1);
        tasksProcessor = new RequestProcessor("ProjectActionSupport.tasks", 50);
        LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    }

    private static final class TermAction
    extends AbstractAction {
        private final EventsProcessor handleEvents;

        public TermAction(EventsProcessor handleEvents) {
            this.handleEvents = handleEvents;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/terminal/ui/term.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.TermAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block4: {
                ProjectActionEvent pae;
                int i = this.handleEvents.paes.length - 1;
                if (i < 0 || !ProjectActionSupport.checkProject(pae = this.handleEvents.paes[i])) break block4;
                String projectName = ProjectUtils.getInformation((Project)pae.getProject()).getDisplayName();
                String dir = pae.getProfile().getRunDirectory();
                ExecutionEnvironment env = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                if (env.isRemote() && RemoteFileUtil.getProjectSourceExecutionEnvironment((Project)pae.getProject()).isLocal()) {
                    PathMap pathMap = RemoteSyncSupport.getPathMap((Lookup.Provider)pae.getProject());
                    if (pathMap != null) {
                        String aDir = pathMap.getRemotePath(dir);
                        if (aDir != null) {
                            dir = aDir;
                        }
                    } else {
                        LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{pae.getProject(), dir});
                    }
                }
                TerminalSupport.openTerminal((String)ProjectActionSupport.getString("TargetExecutor.TermAction.tabTitle", new String[]{projectName, env.getDisplayName()}), (ExecutionEnvironment)env, (String)dir);
            }
        }
    }

    private static final class RerunModAction
    extends AbstractAction {
        private final EventsProcessor eventsProcessor;

        public RerunModAction(EventsProcessor eventsProcessor) {
            this.eventsProcessor = eventsProcessor;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/rerun-mod.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.RerunAction.rerun-mod"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (new RerunArguments(this.eventsProcessor.paes).showMe()) {
                ProjectActionSupport.submitTask(this.eventsProcessor);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private static final class RerunAction
    extends AbstractAction {
        private final EventsProcessor eventsProcessor;

        public RerunAction(EventsProcessor eventsProcessor) {
            this.eventsProcessor = eventsProcessor;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/rerun.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.RerunAction.rerun"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            ProjectActionSupport.submitTask(this.eventsProcessor);
        }
    }

    private static final class StopAction
    extends AbstractAction {
        private final AtomicReference<ProjectActionHandler> activeHandlerRef;

        public StopAction(AtomicReference<ProjectActionHandler> activeHandlerRef) {
            this.activeHandlerRef = activeHandlerRef;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/stop.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.StopAction.stop"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            ProjectActionHandler handler = this.activeHandlerRef.getAndSet(null);
            if (handler != null) {
                handler.cancel();
            }
        }
    }

    private final class EventsProcessor
    implements Runnable {
        private final IOTabsController.TabsGroup tabs;
        private final ProjectActionEvent[] paes;
        private final AtomicReference<ProjectActionHandler> activeHandlerRef = new AtomicReference<Object>(null);
        private final StopAction stopAction = new StopAction(this.activeHandlerRef);
        private final RerunAction rerunAction = new RerunAction(this);
        private final RerunModAction rerunModAction = new RerunModAction(this);
        private final TermAction ta = new TermAction(this);
        private List<BuildActionsProvider.BuildAction> additional;
        private final ProjectActionHandler customHandler;
        private final FileOperationsNotifier fon;
        private final String[] FILE_LOCATIONS = new String[]{"/usr/bin", "/usr/sbin", "/bin"};

        public EventsProcessor(ProjectActionEvent[] paes, ProjectActionHandler customHandler) {
            this.paes = paes;
            this.customHandler = customHandler;
            this.fon = this.getFileOperationsNotifier(paes);
            this.tabs = IOTabsController.getDefault().openTabsGroup(this.getTabName(paes), MakeOptions.getInstance().getReuse());
        }

        private Action[] getActions(String name) {
            ArrayList<Action> list = new ArrayList<Action>();
            list.add(this.stopAction);
            list.add(this.rerunAction);
            for (int i = 0; i < this.paes.length; ++i) {
                if (this.paes[i].getType() != ProjectActionEvent.PredefinedType.RUN) continue;
                list.add(this.rerunModAction);
                break;
            }
            list.add(this.ta);
            if (this.additional == null) {
                this.additional = BuildActionsProvider.getDefault().getActions(name, this.paes);
            }
            list.addAll(this.additional);
            return list.toArray(new Action[list.size()]);
        }

        private String getTabName(ProjectActionEvent[] paes) {
            MakeConfiguration conf;
            String projectName = ProjectUtils.getInformation((Project)paes[0].getProject()).getDisplayName();
            StringBuilder name = new StringBuilder(projectName);
            name.append(" (");
            int counter = 0;
            boolean skipDebug = paes.length > 1;
            for (int i = 0; i < paes.length; ++i) {
                boolean isDebugAction;
                if (counter >= 2) {
                    name.append("...");
                    break;
                }
                ProjectActionEvent.Type type = paes[i].getType();
                boolean bl = isDebugAction = type == ProjectActionEvent.PredefinedType.DEBUG || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || type == ProjectActionEvent.PredefinedType.DEBUG_TEST || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST;
                if (skipDebug && isDebugAction) continue;
                if (counter > 0) {
                    name.append(", ");
                }
                ++counter;
                name.append(paes[i].getActionName());
            }
            name.append(")");
            if (paes.length > 0 && !(conf = paes[0].getConfiguration()).getDevelopmentHost().isLocalhost()) {
                String hkey = conf.getDevelopmentHost().getHostKey();
                name.append(" - ").append(hkey);
            }
            return name.toString();
        }

        private ProgressHandle createProgressHandle(final IOTabsController.InputOutputTab ioTab, ProjectActionHandler handlerToUse) {
            Cancellable cancel = handlerToUse.canCancel() ? new Cancellable(){

                public boolean cancel() {
                    EventsProcessor.this.stopAction.actionPerformed(null);
                    return true;
                }
            } : null;
            return ProgressHandleFactory.createHandle((String)ioTab.getName(), (Cancellable)cancel, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ioTab.select();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.tabs.lockAndReset();
            LifecycleManager.getDefault().saveAll();
            this.rerunAction.setEnabled(false);
            this.rerunModAction.setEnabled(false);
            this.stopAction.setEnabled(false);
            final AtomicInteger currentEventIndex = new AtomicInteger(-1);
            AtomicReference<Object> currentIORef = new AtomicReference<Object>(null);
            try {
                for (final ProjectActionEvent currentEvent : this.paes) {
                    Object tabFactory;
                    String tabBaseName;
                    boolean isRunAction;
                    currentEventIndex.incrementAndGet();
                    if (!ProjectActionSupport.checkProject(currentEvent)) {
                        return;
                    }
                    ProjectActionEvent.Type type = currentEvent.getType();
                    boolean isDebugAction = type == ProjectActionEvent.PredefinedType.DEBUG || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || type == ProjectActionEvent.PredefinedType.DEBUG_TEST || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST;
                    boolean bl = isRunAction = type == ProjectActionEvent.PredefinedType.RUN || isDebugAction || type == ProjectActionEvent.PredefinedType.CUSTOM_ACTION;
                    if ((isRunAction || type == ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE) && !this.checkExecutable(currentEvent)) {
                        return;
                    }
                    int consoleType = currentEvent.getProfile().getConsoleType().getValue();
                    if (consoleType == 1 && !currentEvent.getConfiguration().getDevelopmentHost().isLocalhost()) {
                        consoleType = 0;
                    }
                    if (consoleType == 0) {
                        consoleType = RunProfile.getDefaultConsoleType();
                    }
                    if (isRunAction && consoleType == 3) {
                        tabBaseName = this.getTabName(new ProjectActionEvent[]{currentEvent});
                        tabFactory = new IOTabsController.IOTabFactory(){

                            public InputOutput createNewTab(String tabName) {
                                IOProvider ioProvider = IOProvider.get((String)"Terminal");
                                if (ioProvider == null) {
                                    ioProvider = IOProvider.getDefault();
                                }
                                return ioProvider.getIO(tabName, EventsProcessor.this.getActions(currentEvent.getActionName()));
                            }
                        };
                    } else if (isDebugAction) {
                        tabBaseName = this.getTabName(new ProjectActionEvent[]{currentEvent});
                        tabFactory = new IOTabsController.IOTabFactory(){

                            public InputOutput createNewTab(String tabName) {
                                return IOProvider.getDefault().getIO(tabName, EventsProcessor.this.getActions(currentEvent.getActionName()));
                            }
                        };
                    } else {
                        tabBaseName = this.getTabName(this.paes);
                        tabFactory = new IOTabsController.IOTabFactory(){

                            public InputOutput createNewTab(String tabName) {
                                return IOProvider.getDefault().getIO(tabName, EventsProcessor.this.getActions(currentEvent.getActionName()));
                            }
                        };
                    }
                    IOTabsController.InputOutputTab ioTab = this.tabs.getTab(tabBaseName, tabFactory);
                    IOTabsController.InputOutputTab prevIO = currentIORef.getAndSet(ioTab);
                    if (prevIO != null && prevIO != ioTab) {
                        prevIO.closeOutput();
                    }
                    ProjectActionHandler handlerToUse = null;
                    if (type == ProjectActionEvent.PredefinedType.CUSTOM_ACTION && this.customHandler != null) {
                        handlerToUse = this.customHandler;
                    } else {
                        for (ProjectActionHandlerFactory factory : ProjectActionSupport.this.handlerFactories) {
                            if (!factory.canHandle(currentEvent)) continue;
                            handlerToUse = factory.createHandler();
                            break;
                        }
                    }
                    if (handlerToUse == null) {
                        break;
                    }
                    final CountDownLatch eventProcessed = new CountDownLatch(1);
                    final AtomicBoolean stepFailed = new AtomicBoolean(true);
                    ExecutionListener eventExecutionListener = new ExecutionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void executionStarted(int pid) {
                            try {
                                ProjectActionHandler handler = (ProjectActionHandler)EventsProcessor.this.activeHandlerRef.get();
                                EventsProcessor.this.stopAction.setEnabled(handler != null && handler.canCancel());
                                if (EventsProcessor.this.additional != null) {
                                    for (BuildActionsProvider.BuildAction action : EventsProcessor.this.additional) {
                                        try {
                                            action.setStep(currentEventIndex.get());
                                            action.executionStarted(pid);
                                        }
                                        catch (Throwable th) {}
                                    }
                                }
                            }
                            finally {
                                EventsProcessor.this.fon.onStart(currentEvent);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void executionFinished(int rc) {
                            try {
                                EventsProcessor.this.stopAction.setEnabled(false);
                                stepFailed.set(rc != 0);
                                if (EventsProcessor.this.additional != null) {
                                    for (Action action : EventsProcessor.this.additional) {
                                        try {
                                            ((ExecutionListener)action).executionFinished(rc);
                                        }
                                        catch (Throwable th) {}
                                    }
                                }
                            }
                            finally {
                                eventProcessed.countDown();
                            }
                        }
                    };
                    ProgressHandle progressHandle = null;
                    try {
                        this.initHandler(handlerToUse, currentEvent, this.paes);
                        this.activeHandlerRef.set(handlerToUse);
                        handlerToUse.addExecutionListener(eventExecutionListener);
                        progressHandle = this.createProgressHandle(ioTab, handlerToUse);
                        progressHandle.start();
                        handlerToUse.execute(IOTabsController.getInputOutput((IOTabsController.InputOutputTab)ioTab));
                        try {
                            eventProcessed.await();
                        }
                        catch (InterruptedException ex) {
                            Thread.interrupted();
                            handlerToUse.removeExecutionListener(eventExecutionListener);
                            this.activeHandlerRef.set(null);
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            this.stopAction.setEnabled(false);
                            break;
                        }
                        ProjectActionSupport.refreshProjectFilesOnFinish(currentEvent, this.fon);
                        if (!stepFailed.get()) continue;
                        break;
                    }
                    finally {
                        handlerToUse.removeExecutionListener(eventExecutionListener);
                        this.activeHandlerRef.set(null);
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                        this.stopAction.setEnabled(false);
                    }
                }
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
            finally {
                this.tabs.unlockAndCloseOutput();
                this.rerunAction.setEnabled(true);
                this.rerunModAction.setEnabled(true);
                this.stopAction.setEnabled(false);
                this.fon.finishAll();
            }
        }

        private void initHandler(ProjectActionHandler handler, ProjectActionEvent pae, ProjectActionEvent[] paes) {
            if (this.additional == null) {
                this.additional = BuildActionsProvider.getDefault().getActions(pae.getActionName(), paes);
            }
            ArrayList<BuildActionsProvider.OutputStreamHandler> streamHandlers = new ArrayList<BuildActionsProvider.OutputStreamHandler>();
            for (BuildActionsProvider.BuildAction action : this.additional) {
                if (!(action instanceof BuildActionsProvider.OutputStreamHandler)) continue;
                streamHandlers.add((BuildActionsProvider.OutputStreamHandler)((Object)action));
            }
            handler.init(pae, paes, streamHandlers);
        }

        private FileOperationsNotifier getFileOperationsNotifier(ProjectActionEvent[] paes) {
            HashMap<Project, ProjectFileOperationsNotifier> prj2Notifier = new HashMap<Project, ProjectFileOperationsNotifier>();
            for (ProjectActionEvent pae : paes) {
                if (!ProjectActionSupport.isFileOperationsIntensive(pae)) continue;
                Project project = pae.getProject();
                ProjectFileOperationsNotifier notifer = (ProjectFileOperationsNotifier)prj2Notifier.get(project);
                if (notifer == null) {
                    NativeProjectChangeSupport npcs = null;
                    try {
                        NativeProject nativeProject;
                        npcs = (NativeProjectChangeSupport)project.getLookup().lookup(NativeProjectChangeSupport.class);
                        if (npcs == null && (nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) instanceof NativeProjectChangeSupport) {
                            npcs = (NativeProjectChangeSupport)nativeProject;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("getNativeProject " + e);
                    }
                    notifer = new ProjectFileOperationsNotifier(npcs, pae);
                    prj2Notifier.put(project, notifer);
                }
                notifer.finishPAE = pae;
            }
            return new FileOperationsNotifier(prj2Notifier);
        }

        public NativeProjectChangeSupport getNativeProjectChangeSupport(Project project) {
            NativeProject nativeProject = null;
            try {
                nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            }
            catch (Exception e) {
                System.err.println("getNativeProject " + e);
            }
            if (nativeProject instanceof NativeProjectChangeSupport) {
                return (NativeProjectChangeSupport)nativeProject;
            }
            return null;
        }

        private boolean checkExecutable(ProjectActionEvent pae) {
            String executable = pae.getExecutable();
            if (executable.length() == 0) {
                SelectExecutablePanel panel = new SelectExecutablePanel(pae);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, ProjectActionSupport.getString("SELECT_EXECUTABLE"));
                panel.setDialogDescriptor(descriptor);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    String currentValue;
                    String selectedExecutable = panel.getExecutable();
                    MakeConfiguration projectConfiguration = pae.getConfiguration();
                    RunProfile runProfile = projectConfiguration.getProfile();
                    if (runProfile != null && (currentValue = runProfile.getRunCommand().getValue()).isEmpty()) {
                        runProfile.getRunCommand().setValue("\"${OUTPUT_PATH}\"");
                    }
                    String relativeToBaseDir = ProjectSupport.toProperPath(projectConfiguration.getBaseFSPath(), selectedExecutable, pae.getProject());
                    projectConfiguration.getMakefileConfiguration().getOutput().setValue(relativeToBaseDir);
                    pae.setExecutable(selectedExecutable);
                    pae.setFinalExecutable();
                    return true;
                }
                return false;
            }
            if (!CndPathUtilities.isPathAbsolute((CharSequence)executable)) {
                String runDir = pae.getProfile().getRunDir();
                if (runDir != null && ((runDir = runDir.trim()).startsWith("~/") || runDir.startsWith("~\\") || runDir.equals("~"))) {
                    try {
                        runDir = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment().isLocal() ? HostInfoUtils.getHostInfo((ExecutionEnvironment)pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment()).getUserDirFile().getAbsolutePath() + runDir.substring(1) : HostInfoUtils.getHostInfo((ExecutionEnvironment)pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment()).getUserDir() + runDir.substring(1);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProjectActionSupport.class.getName()).log(Level.INFO, "", ex);
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Logger.getLogger(ProjectActionSupport.class.getName()).log(Level.INFO, "", ex);
                    }
                }
                if (runDir == null || runDir.length() == 0) {
                    executable = CndPathUtilities.toAbsolutePath((FSPath)pae.getConfiguration().getBaseFSPath(), (String)executable);
                } else {
                    runDir = CndPathUtilities.toAbsolutePath((FSPath)pae.getConfiguration().getBaseFSPath(), (String)runDir);
                    FileSystem fs = pae.getConfiguration().getFileSystem();
                    executable = pae.getConfiguration().getBaseDir().equals(runDir) ? CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)runDir, (String)executable) : CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)runDir, (String)CndPathUtilities.getBaseName((String)executable));
                }
                executable = CndPathUtilities.normalizeSlashes((String)executable);
            }
            if (CndPathUtilities.isPathAbsolute((CharSequence)executable)) {
                MakeConfiguration conf = pae.getConfiguration();
                boolean ok = true;
                if (conf != null && !conf.getDevelopmentHost().isLocalhost()) {
                    String testUtility;
                    ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
                    if (!pae.isFinalExecutable()) {
                        PathMap mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)pae.getProject());
                        if (mapper != null) {
                            String anExecutable = mapper.getRemotePath(executable, true);
                            if (anExecutable != null) {
                                executable = anExecutable;
                            }
                        } else {
                            LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{pae.getProject(), executable});
                        }
                    }
                    if ((testUtility = HostInfoUtils.searchFile((ExecutionEnvironment)execEnv, Arrays.asList(this.FILE_LOCATIONS), (String)"test", (boolean)true)) != null) {
                        ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)testUtility, (String[])new String[]{"-x", executable, "-a", "-f", executable});
                        ok = res.isOK();
                    }
                } else {
                    File file = new File(executable);
                    if (!file.exists() && Utilities.isWindows()) {
                        file = CndFileUtils.createLocalFile((String)(executable + ".exe"));
                    }
                    if (!file.exists() || file.isDirectory()) {
                        ok = false;
                    }
                }
                if (!ok) {
                    String value = pae.getProfile().getRunCommand().getValue();
                    String errormsg = ProjectActionSupport.getString("EXECUTABLE_DOESNT_EXISTS", new String[]{executable});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
                    return false;
                }
            }
            pae.setExecutable(executable);
            pae.setFinalExecutable();
            return true;
        }
    }

    private static final class FileOperationsNotifier {
        private final Map<Project, ProjectFileOperationsNotifier> prjNotifier;

        public FileOperationsNotifier(Map<Project, ProjectFileOperationsNotifier> prjNotifier) {
            this.prjNotifier = prjNotifier;
        }

        private void onStart(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            if (notifier != null && notifier.npcs != null && curPAE == notifier.startPAE) {
                notifier.npcs.fireFileOperationsStarted();
            }
        }

        public void onFinish(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            if (notifier != null && notifier.npcs != null && curPAE == notifier.finishPAE) {
                notifier.npcs.fireFileOperationsFinished();
            }
        }

        private void finishAll() {
            for (ProjectFileOperationsNotifier notifier : this.prjNotifier.values()) {
                if (notifier.npcs == null) continue;
                notifier.npcs.fireFileOperationsFinished();
            }
        }

        private boolean isLastExpectedEvent(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            return notifier != null && notifier.npcs != null && curPAE == notifier.finishPAE;
        }
    }

    private static final class ProjectFileOperationsNotifier {
        private final NativeProjectChangeSupport npcs;
        private final ProjectActionEvent startPAE;
        private ProjectActionEvent finishPAE;

        public ProjectFileOperationsNotifier(NativeProjectChangeSupport npcs, ProjectActionEvent startPAE) {
            this.npcs = npcs;
            this.startPAE = startPAE;
        }

        public String toString() {
            return "ProjectFileOperationsNotifier{npcs=" + this.npcs + ", startPAE=" + this.startPAE + ", finishPAE=" + this.finishPAE + '}';
        }
    }
}

