/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.annotations.common.SuppressWarnings;

public class BooleanConfiguration
implements Cloneable {
    private boolean def;
    private boolean value;
    private boolean modified;
    private boolean dirty = false;

    public BooleanConfiguration(boolean def) {
        this.def = def;
        this.reset();
    }

    public void setValue(boolean b) {
        this.value = b;
        this.setModified(b != this.getDefault());
    }

    public boolean getValue() {
        return this.value;
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean getDefault() {
        return this.def;
    }

    public void setDefault(boolean b) {
        this.def = b;
        this.setModified(this.value != this.def);
    }

    public final void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public void assign(BooleanConfiguration conf) {
        this.dirty |= conf.getValue() ^ this.getValue();
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    @SuppressWarnings(value={"CN"})
    public BooleanConfiguration clone() {
        BooleanConfiguration clone = new BooleanConfiguration(this.def);
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        return clone;
    }

    public String toString() {
        return "{value=" + this.value + " modified=" + this.modified + " dirty=" + this.dirty + '}';
    }
}

