/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.BrokenReferencesSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.IncludePathExpansionProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class Item
implements NativeFileItem,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("makeproject.folder");
    private final String path;
    private Folder folder;
    private FileObject file = null;
    private final FileSystem fileSystem;
    private final String normalizedPath;
    private DataObject lastDataObject = null;
    private static final SpiAccessor SPI_ACCESSOR = new SpiAccessor();

    public static Item createInBaseDir(FileObject baseDirFileObject, String path) {
        return new Item(baseDirFileObject, path);
    }

    private Item(FileObject baseDirFileObject, String path) {
        try {
            this.fileSystem = baseDirFileObject.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
        String absPath = CndPathUtilities.toAbsolutePath((FileObject)baseDirFileObject, (String)path);
        this.normalizedPath = FileSystemProvider.normalizeAbsolutePath((String)absPath, (FileSystem)this.fileSystem);
        this.path = CndPathUtilities.normalizeSlashes((String)path);
    }

    public static Item createInFileSystem(FileSystem fileSystem, String path) {
        return new Item(fileSystem, path);
    }

    public static Item createDetachedViewItem(FileSystem fileSystem, String path) {
        CndUtils.assertNonUiThread();
        Item out = new Item(fileSystem, path);
        DataObject dobj = out.getDataObject();
        out.detachFrom(dobj);
        CndUtils.assertTrueInConsole((out.lastDataObject == dobj ? 1 : 0) != 0, (String)"data object should stay the same ", (Object)out.lastDataObject);
        return out;
    }

    private Item(FileSystem fileSystem, String path) {
        CndUtils.assertNotNull((Object)path, (String)"Path should not be null");
        this.path = path;
        this.fileSystem = fileSystem;
        this.normalizedPath = null;
        this.folder = null;
    }

    private void rename(String newname, boolean nameWithoutExtension) {
        String oldname;
        if (newname == null || newname.length() == 0 || this.getFolder() == null) {
            return;
        }
        if (this.path.equals(newname)) {
            return;
        }
        int indexName = this.path.lastIndexOf(47);
        indexName = indexName < 0 ? 0 : ++indexName;
        int indexDot = this.path.lastIndexOf(46);
        if (indexDot < indexName || !nameWithoutExtension) {
            indexDot = -1;
        }
        if ((oldname = indexDot >= 0 ? this.path.substring(indexName, indexDot) : this.path.substring(indexName)).equals(newname)) {
            return;
        }
        String newPath = "";
        if (indexName > 0) {
            newPath = this.path.substring(0, indexName);
        }
        newPath = newPath + newname;
        if (indexDot >= 0) {
            newPath = newPath + this.path.substring(indexDot);
        }
        this.renameTo(newPath);
    }

    private void renameTo(String newPath) {
        Folder f = this.getFolder();
        String oldPath = this.normalizedPath != null ? this.normalizedPath : CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)this.getAbsPath());
        Item item = f.addItem(new Item(this.fileSystem, newPath));
        if (item != null && item.getFolder() != null) {
            if (item.getFolder().isProjectFiles()) {
                Item.copyItemConfigurations(this, item);
            }
            f.removeItem(this);
            f.renameItemAction(oldPath, item);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        return this.getNormalizedPath();
    }

    public String getSortName() {
        return this.getName();
    }

    public String getName() {
        return CndPathUtilities.getBaseName((String)this.path);
    }

    public String getPath(boolean norm) {
        String pat = "./";
        if (norm && this.getPath().startsWith(pat)) {
            return this.getPath().substring(2);
        }
        return this.getPath();
    }

    public String getAbsPath() {
        String retPath = null;
        if (CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)this.getPath())) {
            retPath = this.getPath();
        } else if (this.getFolder() != null) {
            retPath = this.getFolder().getConfigurationDescriptor().getBaseDir() + '/' + this.getPath();
        }
        return retPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Folder folder) {
        if (folder == null && this.file == null) {
            this.ensureFileNotNull();
        }
        if (folder == null) {
            Item item = this;
            synchronized (item) {
                this.detachFrom(this.lastDataObject);
                this.lastDataObject = null;
            }
        } else {
            this.folder = folder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            FileObject fo;
            String newName = (String)evt.getNewValue();
            boolean nameWithoutExtension = true;
            Object o = evt.getSource();
            if (o instanceof DataObject && (fo = ((DataObject)o).getPrimaryFile()) != null) {
                newName = fo.getNameExt();
                nameWithoutExtension = false;
            }
            this.rename(newName, nameWithoutExtension);
        } else if (evt.getPropertyName().equals("valid")) {
            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                DataObject dao;
                FileObject fo;
                Object o = evt.getSource();
                if (o instanceof DataObject && (fo = (dao = (DataObject)o).getPrimaryFile()) != null && fo.isValid()) {
                    this.rename(fo.getNameExt(), false);
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fo);
                        Item item = this;
                        synchronized (item) {
                            if (dataObject != this.lastDataObject) {
                                this.detachFrom(this.lastDataObject);
                                this.attachTo(dataObject);
                            }
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOG.log(Level.FINE, "Can not find data object", ex);
                    }
                    return;
                }
                Folder containingFolder = this.getFolder();
                if (containingFolder != null) {
                    containingFolder.refresh(this);
                }
            } else {
                Object o = evt.getSource();
                if (o instanceof DataObject) {
                    DataObject dao = (DataObject)o;
                    Item item = this;
                    synchronized (item) {
                        if (this.lastDataObject != null) {
                            this.detachFrom(this.lastDataObject);
                        }
                        this.lastDataObject = dao;
                        this.attachTo(this.lastDataObject);
                    }
                }
            }
        } else if (evt.getPropertyName().equals("primaryFile") && this.getFolder() != null) {
            FileObject fo = (FileObject)evt.getNewValue();
            String newPath = fo.getPath();
            if (!CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)this.getPath())) {
                newPath = CndPathUtilities.toRelativePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)newPath);
            }
            newPath = CndPathUtilities.normalizeSlashes((String)newPath);
            this.renameTo(newPath);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public FSPath getFSPath() {
        return new FSPath(this.fileSystem, this.getNormalizedPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNormalizedPath() {
        Item item = this;
        synchronized (item) {
            if (this.normalizedPath != null) {
                return this.normalizedPath;
            }
        }
        String absPath = this.getAbsPath();
        return FileSystemProvider.normalizeAbsolutePath((String)absPath, (FileSystem)this.fileSystem);
    }

    public String getCanonicalPath() {
        FileObject canonicalFile = this.getCanonicalFile();
        if (canonicalFile != null) {
            return canonicalFile.getPath();
        }
        return this.getNormalizedPath();
    }

    private void ensureFileNotNull() {
        if (this.file == null) {
            try {
                this.file = CndFileUtils.getCanonicalFileObject((FileObject)this.getFileObject());
            }
            catch (IOException ioe) {
                this.file = this.getFSPath().getFileObject();
            }
        }
        if (this.file == null) {
            LOG.log(Level.SEVERE, "Can not resolve file {0}", this.getAbsPath());
        }
    }

    public FileObject getCanonicalFile() {
        this.ensureFileNotNull();
        return this.file;
    }

    public String getId() {
        return this.getPath();
    }

    public ItemConfiguration getItemConfiguration(Configuration configuration) {
        if (configuration != null) {
            return (ItemConfiguration)configuration.getAuxObject(this.getId());
        }
        return null;
    }

    public ItemConfiguration[] getItemConfigurations() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return new ItemConfiguration[0];
        }
        Configuration[] configurations = makeConfigurationDescriptor.getConfs().toArray();
        ItemConfiguration[] itemConfigurations = new ItemConfiguration[configurations.length];
        for (int i = 0; i < configurations.length; ++i) {
            itemConfigurations[i] = this.getItemConfiguration(configurations[i]);
        }
        return itemConfigurations;
    }

    public void copyConfigurations(Item src) {
        if (src.getFolder() == null) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getFolder().getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
            ItemConfiguration srcItemConfiguration = src.getItemConfiguration(conf);
            ItemConfiguration dstItemConfiguration = this.getItemConfiguration(conf);
            if (srcItemConfiguration == null || dstItemConfiguration == null) continue;
            dstItemConfiguration.assignValues(srcItemConfiguration);
        }
    }

    private static void copyItemConfigurations(Item src, Item dst) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
                ItemConfiguration newConf = new ItemConfiguration(conf, dst);
                newConf.assignValues(src.getItemConfiguration(conf));
                conf.addAuxObject(newConf);
            }
        }
    }

    public FileObject getFileObject() {
        FileObject fo = this.getFileObjectImpl();
        if (fo == null) {
            String p = this.normalizedPath != null ? this.normalizedPath : this.getAbsPath();
            return InvalidFileObjectSupport.getInvalidFileObject((FileSystem)this.fileSystem, (CharSequence)p);
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getFileObjectImpl() {
        FileObject fileObject;
        PerformanceLogger.PerformaceAction performanceEvent;
        block5: {
            performanceEvent = PerformanceLogger.getLogger().start("GET_ITEM_FILE_OBJECT_PERFORMANCE_EVENT", (Object)this);
            fileObject = null;
            try {
                performanceEvent.setTimeOut(30);
                if (this.normalizedPath != null) {
                    fileObject = this.fileSystem.findResource(this.normalizedPath);
                    break block5;
                }
                Folder f = this.getFolder();
                if (f == null) {
                    String p = this.getPath();
                    if (CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)p)) {
                        p = FileSystemProvider.normalizeAbsolutePath((String)p, (FileSystem)this.fileSystem);
                        fileObject = this.fileSystem.findResource(p);
                    }
                    break block5;
                }
                MakeConfigurationDescriptor cfgDescr = f.getConfigurationDescriptor();
                FileObject baseDirFO = cfgDescr.getBaseDirFileObject();
                fileObject = RemoteFileUtil.getFileObject((FileObject)baseDirFO, (String)this.getPath());
            }
            catch (Throwable throwable) {
                performanceEvent.log(new Object[]{fileObject});
                throw throwable;
            }
        }
        performanceEvent.log(new Object[]{fileObject});
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObject() {
        Item item = this;
        synchronized (item) {
            if (this.lastDataObject != null && this.lastDataObject.isValid()) {
                return this.lastDataObject;
            }
        }
        DataObject dataObject = null;
        FileObject fo = this.getFileObjectImpl();
        if (fo != null && fo.isValid()) {
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException e) {
                LOG.log(Level.FINE, "Can not find data object", e);
            }
        }
        Item item2 = this;
        synchronized (item2) {
            if (dataObject != this.lastDataObject) {
                this.detachFrom(this.lastDataObject);
                this.attachTo(dataObject);
            }
        }
        return dataObject;
    }

    private void attachTo(DataObject dataObject) {
        if (dataObject != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "attaching {0} to {1}", new Object[]{System.identityHashCode(this), dataObject});
            }
            dataObject.removePropertyChangeListener((PropertyChangeListener)this);
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            NativeFileItemSet set = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (set != null) {
                set.add((NativeFileItem)this);
            }
        }
        this.lastDataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onOpen() {
        Item item = this;
        synchronized (item) {
            this.attachTo(this.lastDataObject);
        }
    }

    private void detachFrom(DataObject dao) {
        if (dao != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "detaching {0} from {1}", new Object[]{System.identityHashCode(this), dao});
            }
            dao.removePropertyChangeListener((PropertyChangeListener)this);
            NativeFileItemSet set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
            if (set != null) {
                set.remove((NativeFileItem)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClose() {
        Item item = this;
        synchronized (item) {
            this.detachFrom(this.lastDataObject);
        }
    }

    public final String getMIMEType() {
        return Item.getMIMETypeImpl(this.getDataObject(), this);
    }

    private static String getMIMETypeImpl(DataObject dataObject, Item item) {
        FileObject fobj;
        FileObject fileObject = fobj = dataObject == null ? null : dataObject.getPrimaryFile();
        if (fobj == null) {
            fobj = item.getFileObjectImpl();
        }
        String mimeType = fobj == null || !fobj.isValid() ? MIMESupport.getKnownSourceFileMIMETypeByExtension((String)item.getName()) : MIMESupport.getSourceFileMIMEType((FileObject)fobj);
        return mimeType;
    }

    static PredefinedToolKind getDefaultToolForItem(DataObject dataObject, Item item) {
        PredefinedToolKind tool;
        String mimeType = Item.getMIMETypeImpl(dataObject, item);
        if ("text/x-c".equals(mimeType)) {
            tool = PredefinedToolKind.CCompiler;
        } else if ("text/x-h".equals(mimeType)) {
            tool = PredefinedToolKind.CustomTool;
        } else if ("text/x-c++".equals(mimeType)) {
            tool = PredefinedToolKind.CCCompiler;
        } else if ("text/x-fortran".equals(mimeType)) {
            tool = PredefinedToolKind.FortranCompiler;
        } else if ("text/x-asm".equals(mimeType)) {
            FileObject fobj;
            FileObject fileObject = fobj = dataObject == null ? null : dataObject.getPrimaryFile();
            if (fobj == null) {
                fobj = item.getFileObjectImpl();
            }
            tool = fobj != null && "il".equals(fobj.getExt()) ? PredefinedToolKind.CustomTool : PredefinedToolKind.Assembler;
        } else {
            tool = PredefinedToolKind.CustomTool;
        }
        return tool;
    }

    public PredefinedToolKind getDefaultTool() {
        return Item.getDefaultToolForItem(this.getDataObject(), this);
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        if (this.getFolder() == null) {
            return null;
        }
        return this.getFolder().getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return null;
        }
        return makeConfigurationDescriptor.getActiveConfiguration();
    }

    public NativeProject getNativeProject() {
        Project project;
        Folder curFolder = this.getFolder();
        if (curFolder != null && (project = curFolder.getProject()) != null) {
            return (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return null;
    }

    public List<FSPath> getSystemIncludePaths() {
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(this.getImportantFlags())));
            } else {
                String importantFlags = Item.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(importantFlags)));
            }
        }
        return Item.SPI_ACCESSOR.expandIncludePaths(vec, compilerConfiguration, compiler, makeConfiguration);
    }

    public List<FSPath> getUserIncludePaths() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return Collections.emptyList();
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return Collections.emptyList();
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                list.add(((CCCCompilerConfiguration)master).getIncludeDirectories().getValue());
                if (((CCCCompilerConfiguration)master).getInheritIncludes().getValue()) continue;
                break;
            }
            ArrayList vec2 = new ArrayList();
            for (int i = list.size() - 1; i >= 0; --i) {
                vec2.addAll((Collection)list.get(i));
            }
            ExecutionEnvironment env = compiler.getExecutionEnvironment();
            MacroConverter macroConverter = null;
            FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
            FileSystem projectFS = this.fileSystem;
            ArrayList<Object> result = new ArrayList<Object>();
            for (String p : vec2) {
                if (p.contains("$")) {
                    if (macroConverter == null) {
                        macroConverter = new MacroConverter(env);
                    }
                    p = macroConverter.expand(p);
                }
                if (CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)p)) {
                    result.add(new FSPath(compilerFS, p));
                    continue;
                }
                String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
                result.add(new FSPath(projectFS, absPath));
            }
            List vec3 = new ArrayList();
            vec3 = Item.SPI_ACCESSOR.getItemUserIncludePaths(vec3, cccCompilerConfiguration, compiler, makeConfiguration);
            result.addAll(vec3);
            return Item.SPI_ACCESSOR.expandIncludePaths(result, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return Collections.emptyList();
    }

    public List<String> getIncludeFiles() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return Collections.emptyList();
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return Collections.emptyList();
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                list.add(((CCCCompilerConfiguration)master).getIncludeFiles().getValue());
                if (((CCCCompilerConfiguration)master).getInheritFiles().getValue()) continue;
                break;
            }
            ArrayList vec2 = new ArrayList();
            for (int i = list.size() - 1; i >= 0; --i) {
                vec2.addAll((Collection)list.get(i));
            }
            ExecutionEnvironment env = compiler.getExecutionEnvironment();
            MacroConverter macroConverter = null;
            ArrayList<String> result = new ArrayList<String>();
            for (String p : vec2) {
                if (p.contains("$")) {
                    if (macroConverter == null) {
                        macroConverter = new MacroConverter(env);
                    }
                    p = macroConverter.expand(p);
                }
                String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
                result.add(absPath);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<String> getSystemMacroDefinitions() {
        List<String> undefinedMacros;
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(compiler.getSystemPreprocessorSymbols(this.getImportantFlags()));
            } else {
                String importantFlags = Item.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(compiler.getSystemPreprocessorSymbols(importantFlags));
            }
        }
        if ((undefinedMacros = this.getUndefinedMacros()).size() > 0) {
            ArrayList<String> out = new ArrayList<String>();
            for (String macro : vec) {
                boolean remove = true;
                for (String undef : undefinedMacros) {
                    if (!macro.equals(undef) && !macro.startsWith(undef + "=")) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                out.add(macro);
            }
            vec = out;
        }
        return vec;
    }

    public List<String> getUserMacroDefinitions() {
        List<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            if (cccCompilerConfiguration.getInheritPreprocessor().getValue()) {
                for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(false)) {
                    this.addToMap(res, ((CCCCompilerConfiguration)master).getPreprocessorConfiguration().getValue(), false);
                    if (((CCCCompilerConfiguration)master).getInheritPreprocessor().getValue()) continue;
                    break;
                }
            }
            this.addToMap(res, cccCompilerConfiguration.getPreprocessorConfiguration().getValue(), true);
            this.addToList(res, vec);
            vec = Item.SPI_ACCESSOR.getItemUserMacros(vec, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return vec;
    }

    public List<String> getUndefinedMacros() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                vec.addAll(((CCCCompilerConfiguration)master).getUndefinedPreprocessorConfiguration().getValue());
                if (((CCCCompilerConfiguration)master).getInheritUndefinedPreprocessor().getValue()) continue;
                break;
            }
        }
        return vec;
    }

    public String getImportantFlags() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return "";
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return "";
        }
        if (makeConfiguration.isMakefileConfiguration()) {
            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
            if (compilerConfiguration instanceof CCCCompilerConfiguration) {
                CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
                return cccCompilerConfiguration.getImportantFlags().getValue();
            }
        } else {
            String importantFlags;
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
            if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0 && (importantFlags = Item.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration)) != null) {
                return importantFlags;
            }
        }
        return "";
    }

    private void addToMap(Map<String, String> res, List<String> list, boolean override) {
        for (String macro : list) {
            String value;
            String key;
            int i = macro.indexOf(61);
            if (i > 0) {
                key = macro.substring(0, i).trim();
                value = macro.substring(i + 1).trim();
            } else {
                key = macro;
                value = null;
            }
            if (res.containsKey(key) && !override) continue;
            res.put(key, value);
        }
    }

    private void addToList(Map<String, String> res, List<String> list) {
        for (Map.Entry<String, String> e : res.entrySet()) {
            if (e.getValue() == null) {
                list.add(e.getKey());
                continue;
            }
            list.add(e.getKey() + "=" + e.getValue());
        }
    }

    public boolean hasHeaderOrSourceExtension(boolean cFiles, boolean ccFiles) {
        String mimeType = this.getMIMEType();
        return "text/x-h".equals(mimeType) || ccFiles && "text/x-c++".equals(mimeType) || cFiles && "text/x-c".equals(mimeType);
    }

    public NativeFileItem.Language getLanguage() {
        PredefinedToolKind tool;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        NativeFileItem.Language language = (tool = itemConfiguration != null ? itemConfiguration.getTool() : this.getDefaultTool()) == PredefinedToolKind.CCompiler ? NativeFileItem.Language.C : (tool == PredefinedToolKind.CCCompiler ? NativeFileItem.Language.CPP : (tool == PredefinedToolKind.FortranCompiler ? NativeFileItem.Language.FORTRAN : (this.hasHeaderOrSourceExtension(true, true) ? NativeFileItem.Language.C_HEADER : NativeFileItem.Language.OTHER)));
        return language;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        CCCompilerConfiguration ccCompilerConfiguration;
        NativeFileItem.LanguageFlavor flavor = NativeFileItem.LanguageFlavor.UNKNOWN;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        if (itemConfiguration != null && itemConfiguration.isCompilerToolConfiguration()) {
            Tool tool;
            CompilerSet compilerSet;
            flavor = itemConfiguration.getLanguageFlavor();
            if ((flavor == NativeFileItem.LanguageFlavor.UNKNOWN || flavor == NativeFileItem.LanguageFlavor.DEFAULT) && (compilerSet = makeConfiguration.getCompilerSet().getCompilerSet()) != null && (tool = compilerSet.getTool((ToolKind)itemConfiguration.getTool())) instanceof AbstractCompiler) {
                NativeFileItem.LanguageFlavor aFlavor;
                BasicCompilerConfiguration compilerConfiguration;
                AbstractCompiler compiler = (AbstractCompiler)tool;
                if (itemConfiguration.isCompilerToolConfiguration() && (compilerConfiguration = itemConfiguration.getCompilerConfiguration()) != null && (aFlavor = Item.SPI_ACCESSOR.getLanguageFlavor(compilerConfiguration, compiler, makeConfiguration)) != NativeFileItem.LanguageFlavor.UNKNOWN) {
                    flavor = aFlavor;
                }
            }
            if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN) {
                if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                    switch (itemConfiguration.getCCompilerConfiguration().getInheritedCStandard()) {
                        case 2: {
                            return NativeFileItem.LanguageFlavor.C99;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.C11;
                        }
                        case 0: 
                        case 1: {
                            return NativeFileItem.LanguageFlavor.C89;
                        }
                    }
                } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                    switch (itemConfiguration.getCCCompilerConfiguration().getInheritedCppStandard()) {
                        case 2: {
                            return NativeFileItem.LanguageFlavor.CPP11;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.CPP14;
                        }
                        case 0: 
                        case 1: {
                            return NativeFileItem.LanguageFlavor.CPP;
                        }
                    }
                }
            }
        }
        if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN && makeConfiguration != null && (ccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration()) != null) {
            switch (ccCompilerConfiguration.getInheritedCppStandard()) {
                case 2: {
                    return NativeFileItem.LanguageFlavor.CPP11;
                }
                case 3: {
                    return NativeFileItem.LanguageFlavor.CPP14;
                }
            }
        }
        return flavor;
    }

    public boolean isExcluded() {
        ItemConfiguration itemConfiguration = this.getItemConfiguration(this.getMakeConfiguration());
        if (itemConfiguration != null) {
            boolean value = itemConfiguration.getExcluded().getValue();
            if (value) {
                if (this.getMakeConfiguration().getCodeAssistanceConfiguration().includeInCA(this)) {
                    return false;
                }
            } else if (this.getMakeConfiguration().getCodeAssistanceConfiguration().excludeInCA(this)) {
                return true;
            }
            return value;
        }
        return true;
    }

    int getCRC() {
        int res = 0;
        for (FSPath fSPath : this.getUserIncludePaths()) {
            res += 37 * fSPath.getPath().hashCode();
        }
        for (String string : this.getIncludeFiles()) {
            res += 37 * string.hashCode();
        }
        for (String string : this.getUserMacroDefinitions()) {
            res += 37 * string.hashCode();
        }
        for (String string : this.getUndefinedMacros()) {
            res += 37 * string.hashCode();
        }
        for (FSPath fSPath : this.getSystemIncludePaths()) {
            res += 37 * fSPath.getPath().hashCode();
        }
        for (String string : this.getSystemMacroDefinitions()) {
            res += 37 * string.hashCode();
        }
        res += 37 * this.getLanguage().hashCode();
        return res += 37 * this.getLanguageFlavor().hashCode();
    }

    public String toString() {
        return this.path;
    }

    public boolean hasImportantAttributes() {
        for (ItemConfiguration conf : this.getItemConfigurations()) {
            if (conf == null || conf.isDefaultConfiguration()) continue;
            return true;
        }
        return false;
    }

    private static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables = new HashMap<String, String>();

        public MacroConverter(ExecutionEnvironment env) {
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            BrokenReferencesSupport.addTemporaryEnv(env, this.envVariables);
            this.expander = this.envVariables == null ? null : MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        public String expand(String in) {
            try {
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return in;
            }
        }
    }

    private static final class SpiAccessor {
        private Collection<? extends UserOptionsProvider> uoProviders;
        private Collection<? extends IncludePathExpansionProvider> ipeProviders;

        private synchronized Collection<? extends UserOptionsProvider> getUserOptionsProviders() {
            if (this.uoProviders == null) {
                this.uoProviders = Lookup.getDefault().lookupAll(UserOptionsProvider.class);
            }
            return this.uoProviders;
        }

        private synchronized Collection<? extends IncludePathExpansionProvider> getIncludePathExpansionProviders() {
            if (this.ipeProviders == null) {
                this.ipeProviders = Lookup.getDefault().lookupAll(IncludePathExpansionProvider.class);
            }
            return this.ipeProviders;
        }

        private SpiAccessor() {
        }

        private List<FSPath> getItemUserIncludePaths(List<FSPath> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                ArrayList<FSPath> res = new ArrayList<FSPath>(includes);
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    res.addAll(userOptionsProvider.getItemUserIncludePaths(includes, compilerOptions, compiler, makeConfiguration));
                }
                return res;
            }
            return includes;
        }

        private List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                ArrayList<String> res = new ArrayList<String>(macros);
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    res.addAll(userOptionsProvider.getItemUserMacros(macros, compilerOptions, compiler, makeConfiguration));
                }
                return res;
            }
            return macros;
        }

        private String getImportantFlags(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    String itemImportantFlags = userOptionsProvider.getItemImportantFlags(compilerOptions, compiler, makeConfiguration);
                    if (itemImportantFlags == null) continue;
                    return itemImportantFlags;
                }
            }
            return null;
        }

        private NativeFileItem.LanguageFlavor getLanguageFlavor(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    NativeFileItem.LanguageFlavor languageFlavor = userOptionsProvider.getLanguageFlavor(compilerOptions, compiler, makeConfiguration);
                    if (languageFlavor == null || languageFlavor == NativeFileItem.LanguageFlavor.UNKNOWN) continue;
                    return languageFlavor;
                }
                return NativeFileItem.LanguageFlavor.UNKNOWN;
            }
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        private List<FSPath> expandIncludePaths(List<FSPath> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            for (IncludePathExpansionProvider includePathExpansionProvider : this.getIncludePathExpansionProviders()) {
                includes = includePathExpansionProvider.expandIncludePaths(includes, compilerOptions, compiler, makeConfiguration);
            }
            return includes;
        }
    }
}

