/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class BuildSupport {
    public static final String MAKE_MACRO = "${MAKE}";

    private BuildSupport() {
    }

    public static BuildFile findBuildFileInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        BuildFileProvider provider;
        BuildFile findConfigureScript = null;
        Iterator<? extends BuildFileProvider> i$ = BuildSupport.getBuildFileProviders().iterator();
        while (i$.hasNext() && (findConfigureScript = (provider = i$.next()).findBuildFileInFolder(folder, ee, compilerSet)) == null) {
        }
        return findConfigureScript;
    }

    public static BuildFile scriptToBuildFile(String script) {
        BuildFileProvider provider;
        BuildFile findConfigureScript = null;
        Iterator<? extends BuildFileProvider> i$ = BuildSupport.getBuildFileProviders().iterator();
        while (i$.hasNext() && (findConfigureScript = (provider = i$.next()).scriptToBuildFile(script)) == null) {
        }
        return findConfigureScript;
    }

    public static BuildFileProvider getBuildFileProvider(BuildFile script) {
        for (BuildFileProvider buildFileProvider : BuildSupport.getBuildFileProviders()) {
            if (!buildFileProvider.isSupported(script)) continue;
            return buildFileProvider;
        }
        return null;
    }

    public static Collection<? extends BuildFileProvider> getBuildFileProviders() {
        Lookup.Result res = Lookup.getDefault().lookupResult(BuildFileProvider.class);
        return res.allInstances();
    }

    public static interface BuildFileProvider {
        public BuildFile findBuildFileInFolder(FileObject var1, ExecutionEnvironment var2, CompilerSet var3);

        public BuildFile scriptToBuildFile(String var1);

        public boolean isSupported(BuildFile var1);

        public FileFilter[] getFileFilter();

        public String getHint();
    }

    public static interface BuildFile {
        public String getFile();

        public String getCleanCommandLine(String var1, String var2);

        public String getBuildCommandLine(String var1, String var2);

        public String validate(ExecutionEnvironment var1, CompilerSet var2);
    }
}

