/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingAddingFilesProgressPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFilesOuterPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNewLinkPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class PackagingFilesPanel
extends ListEditorPanel<PackagerFileElement> {
    private final FSPath baseDir;
    private JTable targetList;
    private final MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private final JButton addButton;
    private final JButton addFileOrDirectoryButton;
    private final JButton addFilesButton;
    private final JButton addLinkButton;
    private PackagingFilesOuterPanel packagingFilesOuterPanel;
    private static ResourceBundle bundle;

    public PackagingFilesPanel(List<PackagerFileElement> fileList, FSPath baseDir) {
        super(fileList, new JButton[]{new JButton(), new JButton(), new JButton(), new JButton()});
        this.getAddButton().setVisible(false);
        this.baseDir = baseDir;
        this.addButton = this.extraButtons[0];
        this.addFileOrDirectoryButton = this.extraButtons[1];
        this.addFilesButton = this.extraButtons[2];
        this.addLinkButton = this.extraButtons[3];
        this.addButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.text"));
        this.addButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.mn").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.ad"));
        this.addButton.addActionListener(new AddButtonAction());
        this.addFileOrDirectoryButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.text"));
        this.addFileOrDirectoryButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.mn").charAt(0));
        this.addFileOrDirectoryButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.ad"));
        this.addFileOrDirectoryButton.addActionListener(new AddFileOrDirectoryButtonAction());
        this.addFilesButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.text"));
        this.addFilesButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.mn").charAt(0));
        this.addFilesButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.ad"));
        this.addFilesButton.addActionListener(new AddFilesButtonAction());
        this.addLinkButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.text"));
        this.addLinkButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.mn").charAt(0));
        this.addLinkButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.ad"));
        this.addLinkButton.addActionListener(new AddLinkButtonAction());
        this.getEditButton().setVisible(false);
        this.getDefaultButton().setVisible(false);
    }

    private void refresh() {
        this.packagingFilesOuterPanel.getPackagingConfiguration().getTopDir().setValue(this.packagingFilesOuterPanel.getTopDirectoryTextField().getText());
        this.getTargetList().validate();
        this.getTargetList().repaint();
    }

    public void setOuterPanel(PackagingFilesOuterPanel packagingFilesOuterPanel) {
        this.packagingFilesOuterPanel = packagingFilesOuterPanel;
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PackagingFilesPanel.this.refresh();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PackagingFilesPanel.this.refresh();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PackagingFilesPanel.this.refresh();
            }
        };
        packagingFilesOuterPanel.getTopDirectoryTextField().getDocument().addDocumentListener(documentListener);
    }

    private boolean isExecutable(File file) {
        FileObject fo = null;
        if (file.getName().endsWith(".exe")) {
            return true;
        }
        try {
            fo = CndFileUtils.toFileObject((File)file.getCanonicalFile());
        }
        catch (IOException e) {
            return false;
        }
        if (fo == null || !fo.isValid()) {
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
        String mime = dataObject.getPrimaryFile().getMIMEType();
        return mime.equals("text/sh") || mime.equals("text/bat") || mime.equals("application/x-shobj+elf") || MIMENames.isBinaryExecutable((String)mime);
    }

    public PackagerFileElement copyAction(PackagerFileElement o) {
        PackagerFileElement elem = o;
        PackagerFileElement copy = new PackagerFileElement(elem.getType(), new String(elem.getFrom()), new String(elem.getTo()));
        copy.setOwner(elem.getOwner());
        copy.setPermission(elem.getPermission());
        copy.setGroup(elem.getGroup());
        return copy;
    }

    public String getCopyButtonText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.text");
    }

    public char getCopyButtonMnemonics() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.mn").charAt(0);
    }

    public String getCopyButtonAD() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.ad");
    }

    public String getListLabelText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.text");
    }

    public char getListLabelMnemonic() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.mn").charAt(0);
    }

    public int getSelectedIndex() {
        int index = this.getTargetList().getSelectedRow();
        if (index >= 0 && index < this.getListDataSize()) {
            return index;
        }
        return 0;
    }

    protected void setSelectedIndex(int i) {
        this.getTargetList().getSelectionModel().setSelectionInterval(i, i);
    }

    protected void setData(List<PackagerFileElement> data) {
        this.getTargetList().setModel(new MyTableModel());
        if (this.getTargetList().getColumnModel().getColumnCount() >= 4) {
            this.getTargetList().getColumnModel().getColumn(0).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(0).setMaxWidth(100);
            this.getTargetList().getColumnModel().getColumn(1).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(1).setMaxWidth(300);
            this.getTargetList().getColumnModel().getColumn(2).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(2).setMaxWidth(300);
            this.getTargetList().getColumnModel().getColumn(3).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(3).setMaxWidth(100);
        }
        if (this.getTargetList().getColumnModel().getColumnCount() >= 6) {
            this.getTargetList().getColumnModel().getColumn(4).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(4).setMaxWidth(100);
            this.getTargetList().getColumnModel().getColumn(5).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(5).setMaxWidth(100);
        }
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    protected void ensureIndexIsVisible(int selectedIndex) {
        Rectangle rect = this.getTargetList().getCellRect(selectedIndex, 0, true);
        this.getTargetList().scrollRectToVisible(rect);
    }

    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.setData(null);
            this.getListLabel().setLabelFor(this.targetList);
            this.getTargetList().getSelectionModel().setSelectionMode(0);
            this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        }
        return this.targetList;
    }

    public int getActualColumnCount() {
        return 6;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingFilesPanel.class);
        }
        return bundle.getString(s);
    }

    private static String getString(String s, String a1) {
        return NbBundle.getMessage(PackagingFilesPanel.class, (String)s, (Object)a1);
    }

    private final class MyTableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.0.text"), PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.1.text"), PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.2.text"), PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.3.text"), PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.4.text"), PackagingFilesPanel.access$700("PackagingFilesOuterPanel.column.5.text")};

        private MyTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return PackagingFilesPanel.this.getActualColumnCount();
        }

        @Override
        public int getRowCount() {
            return PackagingFilesPanel.this.getListDataSize();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PackagerFileElement elem = (PackagerFileElement)PackagingFilesPanel.this.getElementAt(row);
            if (col == 0) {
                return elem.getType();
            }
            if (col == 2) {
                if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    return "";
                }
                return elem.getFrom();
            }
            if (col == 1) {
                return elem.getTo();
            }
            if (col == 3) {
                return elem.getPermission();
            }
            if (col == 4) {
                return elem.getOwner();
            }
            if (col == 5) {
                return elem.getGroup();
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return true;
            }
            return true;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            PackagerFileElement elem = (PackagerFileElement)PackagingFilesPanel.this.getElementAt(row);
            if (col == 0) {
                PackagerFileElement.FileType fileType = (PackagerFileElement.FileType)((Object)val);
                if (fileType == PackagerFileElement.FileType.FILE) {
                    elem.setType(fileType);
                    elem.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText());
                    elem.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    elem.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == PackagerFileElement.FileType.DIRECTORY) {
                    elem.setType(fileType);
                    elem.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText());
                    elem.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    elem.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == PackagerFileElement.FileType.SOFTLINK) {
                    elem.setType(fileType);
                    elem.setPermission("");
                    elem.setOwner("");
                    elem.setGroup("");
                } else assert (false);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else if (col == 2) {
                elem.setFrom((String)val);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else if (col == 1) {
                elem.setTo((String)val);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else if (col == 3) {
                elem.setPermission((String)val);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else if (col == 4) {
                elem.setOwner((String)val);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else if (col == 5) {
                elem.setGroup((String)val);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else assert (false);
        }
    }

    private final class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
            String val;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, col);
            PackagerFileElement elem = (PackagerFileElement)PackagingFilesPanel.this.getElementAt(row);
            if (col == 0) {
                label.setText(elem.getType().toString());
            } else if (col == 1) {
                String msg;
                if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    msg = PackagingFilesPanel.getString("Softlink_tt", elem.getTo() + "->" + elem.getFrom());
                    label.setToolTipText(msg);
                } else if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    msg = PackagingFilesPanel.getString("Directory_tt", elem.getTo());
                    label.setToolTipText(msg);
                } else if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    msg = PackagingFilesPanel.getString("File_tt", new File(CndPathUtilities.toAbsolutePath((FileObject)PackagingFilesPanel.this.baseDir.getFileObject(), (String)elem.getFrom())).getAbsolutePath());
                    label.setToolTipText(msg);
                }
                String val2 = elem.getTo();
                if (val2.contains("${")) {
                    String expandedVal = PackagingFilesPanel.this.packagingFilesOuterPanel.getPackagingConfiguration().expandMacros(val2);
                    label.setText(expandedVal);
                }
            } else if (col == 2 && (val = elem.getFrom()).contains("${")) {
                String expandedVal = PackagingFilesPanel.this.packagingFilesOuterPanel.getPackagingConfiguration().expandMacros(val);
                label.setText(expandedVal);
            }
            return label;
        }
    }

    private final class MyTable
    extends JTable {
        public MyTable() {
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }

        @Override
        public Color getGridColor() {
            return new Color(225, 225, 225);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return PackagingFilesPanel.this.myTableCellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                PackagerFileElement elem = (PackagerFileElement)PackagingFilesPanel.this.getElementAt(row);
                JComboBox<PackagerFileElement.FileType> comboBox = new JComboBox<PackagerFileElement.FileType>();
                comboBox.addItem(PackagerFileElement.FileType.FILE);
                comboBox.addItem(PackagerFileElement.FileType.DIRECTORY);
                comboBox.addItem(PackagerFileElement.FileType.SOFTLINK);
                if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    comboBox.setSelectedIndex(1);
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    comboBox.setSelectedIndex(2);
                } else {
                    comboBox.setSelectedIndex(0);
                }
                return new DefaultCellEditor(comboBox);
            }
            return super.getCellEditor(row, col);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            PackagingFilesPanel.this.checkSelection();
        }
    }

    private final class AddFilesButtonAction
    implements ActionListener {
        private boolean cancelled;

        private AddFilesButtonAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            String chooser_key = "packaging.AddFileOrDirectory";
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)PackagingFilesPanel.this.baseDir.getFileObject());
            String seed = RemoteFileUtil.getCurrentChooserFile((String)"packaging.AddFileOrDirectory", (ExecutionEnvironment)env);
            if (seed == null) {
                seed = PackagingFilesPanel.this.baseDir.getPath();
            }
            JFileChooser fileChooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)env, (String)PackagingFilesPanel.getString("FileChooserFilesTitle"), (String)PackagingFilesPanel.getString("FileChooserButtonText"), (int)1, null, (String)seed, (boolean)false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory(pathPanel);
            fileChooser.setMultiSelectionEnabled(false);
            int ret = fileChooser.showOpenDialog(null);
            if (ret == 1) {
                return;
            }
            final File dir = fileChooser.getSelectedFile();
            RemoteFileUtil.setCurrentChooserFile((String)"packaging.AddFileOrDirectory", (String)dir.getPath(), (ExecutionEnvironment)env);
            this.cancelled = false;
            JButton stopButton = new JButton(PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.Stop.Button.text"));
            stopButton.setMnemonic(PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.Stop.Button.text").charAt(0));
            stopButton.addActionListener(new StopButtonAction());
            final PackagingAddingFilesProgressPanel progressPanel = new PackagingAddingFilesProgressPanel(stopButton);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)progressPanel, PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.title"), true, (Object[])new JButton[]{stopButton}, (Object)stopButton, 1, null, null);
            final Dialog progressDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            progressDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    new AddFilesFromDir(dir, progressPanel, progressDialog).start();
                }
            });
            try {
                progressDialog.setVisible(true);
            }
            catch (Throwable th) {
                if (!(th.getCause() instanceof InterruptedException)) {
                    throw new RuntimeException(th);
                }
                dialogDescriptor.setValue(DialogDescriptor.CLOSED_OPTION);
            }
            finally {
                progressDialog.dispose();
            }
        }

        private void addFilesFromDirectory(ArrayList<PackagerFileElement> listToAdd, File origDir, File dir, PackagingAddingFilesProgressPanel progressPanel) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length && !this.cancelled; ++i) {
                if (files[i].isDirectory()) {
                    this.addFilesFromDirectory(listToAdd, origDir, files[i], progressPanel);
                    continue;
                }
                String path = ProjectSupport.toProperPath(PackagingFilesPanel.this.baseDir.getFileObject(), files[i].getPath(), MakeProjectOptions.getPathMode());
                path = MakeProjectOptions.getPathMode() == MakeProjectOptions.PathMode.REL_OR_ABS ? CndPathUtilities.toAbsoluteOrRelativePath((FileObject)PackagingFilesPanel.this.baseDir.getFileObject(), (String)files[i].getPath()) : (MakeProjectOptions.getPathMode() == MakeProjectOptions.PathMode.REL ? CndPathUtilities.toRelativePath((FileObject)PackagingFilesPanel.this.baseDir.getFileObject(), (String)files[i].getPath()) : files[i].getPath());
                path = CndPathUtilities.normalizeSlashes((String)path);
                String toFile = CndPathUtilities.toRelativePath((String)origDir.getParentFile().getAbsolutePath(), (String)files[i].getPath());
                toFile = CndPathUtilities.normalizeSlashes((String)toFile);
                String topFolder = "${PACKAGE_TOP_DIR}";
                String perm = files[i].getName().endsWith(".exe") || files[i].isDirectory() || PackagingFilesPanel.this.isExecutable(files[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                listToAdd.add(new PackagerFileElement(PackagerFileElement.FileType.FILE, path, topFolder + toFile, perm, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
                progressPanel.setProgress(path);
            }
        }

        private final class StopButtonAction
        implements ActionListener {
            private StopButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddFilesButtonAction.this.cancelled = true;
            }
        }

        private final class AddFilesFromDir
        extends Thread {
            private final PackagingAddingFilesProgressPanel progressPanel;
            private final Dialog progressDialog;
            private final File dir;

            AddFilesFromDir(File dir, PackagingAddingFilesProgressPanel progressPanel, Dialog progressDialog) {
                this.progressPanel = progressPanel;
                this.progressDialog = progressDialog;
                this.dir = dir;
            }

            @Override
            public void run() {
                final ArrayList listToAdd = new ArrayList();
                AddFilesButtonAction.this.addFilesFromDirectory(listToAdd, this.dir, this.dir, this.progressPanel);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PackagingFilesPanel.this.addObjectsAction(listToAdd);
                        AddFilesFromDir.this.progressDialog.setVisible(false);
                    }
                });
            }
        }
    }

    private final class AddFileOrDirectoryButtonAction
    implements ActionListener {
        private AddFileOrDirectoryButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String chooser_key = "packaging.AddFileOrDirectory";
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)PackagingFilesPanel.this.baseDir.getFileObject());
            String seed = RemoteFileUtil.getCurrentChooserFile((String)"packaging.AddFileOrDirectory", (ExecutionEnvironment)env);
            if (seed == null) {
                seed = PackagingFilesPanel.this.baseDir.getPath();
            }
            JFileChooser fileChooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)env, (String)PackagingFilesPanel.getString("FileChooserFileTitle"), (String)PackagingFilesPanel.getString("FileChooserButtonText"), (int)2, null, (String)seed, (boolean)false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory(pathPanel);
            fileChooser.setMultiSelectionEnabled(true);
            int ret = fileChooser.showOpenDialog(null);
            if (ret == 1) {
                return;
            }
            File[] files = fileChooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                return;
            }
            File selectedFolder = files[0].isFile() ? files[0].getParentFile() : files[0];
            RemoteFileUtil.setCurrentChooserFile((String)"packaging.AddFileOrDirectory", (String)selectedFolder.getPath(), (ExecutionEnvironment)env);
            for (int i = 0; i < files.length; ++i) {
                String itemPath = ProjectSupport.toProperPath(PackagingFilesPanel.this.baseDir.getFileObject(), files[i].getPath(), MakeProjectOptions.getPathMode());
                itemPath = CndPathUtilities.normalizeSlashes((String)itemPath);
                String topFolder = "${PACKAGE_TOP_DIR}";
                if (files[i].isDirectory()) {
                    PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.DIRECTORY, "", topFolder + files[i].getName(), PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
                    continue;
                }
                String perm = PackagingFilesPanel.this.isExecutable(files[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.FILE, itemPath, topFolder + files[i].getName(), perm, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
            }
        }
    }

    private final class AddLinkButtonAction
    implements ActionListener {
        private AddLinkButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PackagingNewLinkPanel packagingNewEntryPanel = new PackagingNewLinkPanel(PackagingFilesPanel.this.packagingFilesOuterPanel.getTopDirectoryTextField().getText());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)packagingNewEntryPanel, PackagingFilesPanel.getString("AddNewLinkDialogTitle"));
            packagingNewEntryPanel.setDialogDesriptor(dialogDescriptor);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.SOFTLINK, packagingNewEntryPanel.getLink(), packagingNewEntryPanel.getLinkName(), "", PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
        }
    }

    private final class AddButtonAction
    implements ActionListener {
        private AddButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String topFolder = "${PACKAGE_TOP_DIR}";
            PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.UNKNOWN, "", topFolder));
        }
    }
}

