/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.utils.DirectoryChooserPanel;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;

public abstract class VectorNodeProp
extends PropertySupport<List> {
    private final VectorConfiguration<String> vectorConfiguration;
    private final BooleanConfiguration inheritValues;
    private final FSPath baseDir;
    private final String[] texts;
    private final boolean addPathPanel;
    private final boolean onlyFolder;
    private final HelpCtx helpCtx;

    public VectorNodeProp(VectorConfiguration<String> vectorConfiguration, BooleanConfiguration inheritValues, FSPath baseDir, String[] texts, boolean addPathPanel, boolean onlyFolder, HelpCtx helpCtx) {
        super(texts[0], List.class, texts[1], texts[2], true, true);
        this.vectorConfiguration = vectorConfiguration;
        this.inheritValues = inheritValues;
        this.baseDir = baseDir;
        this.texts = texts;
        this.addPathPanel = addPathPanel;
        this.onlyFolder = onlyFolder;
        this.helpCtx = helpCtx;
    }

    public String getHtmlDisplayName() {
        if (this.vectorConfiguration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public List getValue() {
        return this.vectorConfiguration.getValue();
    }

    public void setValue(List v) {
        this.vectorConfiguration.setValue(v);
    }

    public void restoreDefaultValue() {
        this.vectorConfiguration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.vectorConfiguration.getValue().isEmpty();
    }

    public PropertyEditor getPropertyEditor() {
        ArrayList<String> clone = new ArrayList<String>();
        clone.addAll(this.vectorConfiguration.getValue());
        return new DirectoriesEditor(clone);
    }

    protected abstract List<String> convertToList(String var1);

    protected abstract String convertToString(List<String> var1);

    private class DirectoriesEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private final List<String> value;
        private PropertyEnv env;

        public DirectoriesEditor(List<String> value) {
            this.value = value;
        }

        @Override
        public void setAsText(String text) {
            super.setValue(VectorNodeProp.this.convertToList(text.trim()));
        }

        @Override
        public String getAsText() {
            return VectorNodeProp.this.convertToString(this.value);
        }

        @Override
        public Component getCustomEditor() {
            String text = null;
            if (VectorNodeProp.this.inheritValues != null) {
                text = VectorNodeProp.this.texts[3];
            }
            return new DirectoryChooserPanel(VectorNodeProp.this.baseDir, this.value, VectorNodeProp.this.addPathPanel, VectorNodeProp.this.inheritValues, text, this, this.env, VectorNodeProp.this.onlyFolder, VectorNodeProp.this.helpCtx);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

