/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.util.NbBundle;

public class IPSPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "IPS";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return IPSPackager.getString("IPSPackage");
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        ArrayList<PackagerInfoElement> infoList = new ArrayList<PackagerInfoElement>();
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "name", packagingConfiguration.getOutputName(), false, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "description", "Package description ...", false, true));
        return infoList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> entryComboBox = new ArrayList<String>();
        entryComboBox.add("name");
        entryComboBox.add("description");
        return entryComboBox;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(IPSPackager.class, (String)s);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bw, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyIPS(bw, makeConfiguration);
        }

        private List<String> findUndefinedDirectories(PackagingConfiguration packagingConfiguration) {
            String path;
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            HashSet<String> set = new HashSet<String>();
            ArrayList<String> list = new ArrayList<String>();
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                path = packagingConfiguration.expandMacros(elem.getTo());
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                set.add(path);
            }
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.FILE && elem.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                path = CndPathUtilities.getDirName((String)packagingConfiguration.expandMacros(elem.getTo()));
                String base = "";
                if (path == null || path.length() <= 0) continue;
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    if (set.contains(base = base + "/" + tokenizer.nextToken())) continue;
                    set.add(base);
                    list.add(base);
                }
            }
            return list;
        }

        private void writePackagingScriptBodyIPS(BufferedWriter bw, MakeConfiguration conf) throws IOException {
            PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            bw.write("# Copy files and create directories and links\n");
            for (PackagerFileElement elem : fileList) {
                String toDir;
                bw.write("cd \"${TOP}\"\n");
                if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    toDir = CndPathUtilities.getDirName((String)conf.getPackagingConfiguration().expandMacros(elem.getTo()));
                    if (toDir != null && toDir.length() >= 0) {
                        if (toDir.charAt(0) == '/') {
                            toDir = toDir.substring(1);
                        }
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"\n");
                    }
                    bw.write("copyFileToTmpDir \"" + elem.getFrom() + "\" \"${NBTMPDIR}/" + elem.getTo() + "\" 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bw.write("makeDirectory  \"${NBTMPDIR}/" + elem.getTo() + "\"" + " 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    toDir = CndPathUtilities.getDirName((String)elem.getTo());
                    String toName = CndPathUtilities.getBaseName((String)elem.getTo());
                    if (toDir != null && toDir.length() >= 0) {
                        if (toDir.charAt(0) == '/') {
                            toDir = toDir.substring(1);
                        }
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    }
                    bw.write("cd \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    bw.write("ln -s \"" + elem.getFrom() + "\"" + " " + "\"" + toName + "\"" + "\n");
                } else if (elem.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bw.write("\n");
            }
            bw.write("\n");
            bw.write("# Create manifest file\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("MANIFEST=${NBTMPDIR}/manifest\n");
            bw.write("rm -f ${MANIFEST}\n");
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            bw.write("echo '# header' >> ${MANIFEST}\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            List<PackagerInfoElement> infoList = packagingConfiguration.getHeaderSubList(IPSPackager.PACKAGER_NAME);
            for (PackagerInfoElement elem : infoList) {
                String value = elem.getValue();
                int i = 0;
                int j = value.indexOf("\\n");
                while (j >= 0) {
                    if (i == 0) {
                        bw.write("echo '" + elem.getName() + ": " + value.substring(i, j) + "' >> ${MANIFEST}\n");
                    } else {
                        bw.write("echo '" + value.substring(i, j) + "' >> ${MANIFEST}\n");
                    }
                    i = j + 2;
                    j = value.indexOf("\\n", i);
                }
                if (i >= value.length()) continue;
                if (i == 0) {
                    bw.write("echo 'name=\"" + elem.getName() + "\" value=\"" + value.substring(i) + "\"' >> ${MANIFEST}\n");
                    continue;
                }
                bw.write("echo '" + value.substring(i) + "' >> ${MANIFEST}\n");
            }
            for (String addInfo : packagingConfiguration.getAdditionalInfo().getValue()) {
                bw.write("echo \"" + addInfo + "\" >> ${MANIFEST}\n");
            }
            bw.write("\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            bw.write("echo '# directories' >> ${MANIFEST}\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            List<String> dirList = this.findUndefinedDirectories(packagingConfiguration);
            for (String dir : dirList) {
                bw.write("echo \"");
                bw.write("dir ");
                bw.write("mode=0" + MakeOptions.getInstance().getDefExePerm() + " ");
                bw.write("owner=" + MakeOptions.getInstance().getDefOwner() + " ");
                bw.write("group=" + MakeOptions.getInstance().getDefGroup() + " ");
                bw.write("path=" + dir);
                bw.write("\"");
                bw.write(" >> ${MANIFEST}\n");
            }
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                String path = packagingConfiguration.expandMacros(elem.getTo());
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                bw.write("echo \"");
                bw.write("dir ");
                bw.write("mode=0" + elem.getPermission() + " ");
                bw.write("owner=" + elem.getOwner() + " ");
                bw.write("group=" + elem.getGroup() + " ");
                bw.write("path=" + path);
                bw.write("\"");
                bw.write(" >> ${MANIFEST}\n");
            }
            bw.write("\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            bw.write("echo '# files' >> ${MANIFEST}\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.FILE) continue;
                String path = packagingConfiguration.expandMacros(elem.getTo());
                bw.write("echo \"");
                bw.write("file ");
                bw.write(path.substring(1) + " ");
                bw.write("mode=0" + elem.getPermission() + " ");
                bw.write("owner=" + elem.getOwner() + " ");
                bw.write("group=" + elem.getGroup() + " ");
                bw.write("path=" + path);
                bw.write("\"");
                bw.write(" >> ${MANIFEST}\n");
            }
            bw.write("\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            bw.write("echo '# links' >> ${MANIFEST}\n");
            bw.write("echo '#' >> ${MANIFEST}\n");
            for (PackagerFileElement elem : fileList) {
                if (elem.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                String path = packagingConfiguration.expandMacros(elem.getTo());
                bw.write("echo \"");
                bw.write("hardlink ");
                bw.write("path=" + path + " ");
                bw.write("target=" + packagingConfiguration.expandMacros(elem.getFrom()));
                bw.write("\"");
                bw.write(" >> ${MANIFEST}\n");
            }
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("checkReturnCode\n");
            bw.write("mkdir -p  " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("checkReturnCode\n");
            bw.write("cd \"${NBTMPDIR}\"\n");
            bw.write("for i in *; do cd \"${TOP}\"; rm -rf " + packagingConfiguration.getOutputValue() + "/$i; done" + "\n");
            bw.write("checkReturnCode\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("mv ${NBTMPDIR}/* " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("checkReturnCode\n");
            bw.write("\n");
            bw.write("echo IPS: " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("\n");
        }
    }
}

