/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerListUI;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.BrokenReferencesSupport;
import org.netbeans.modules.cnd.makeproject.MakeProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class RemoteDevelopmentAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final String HOST_ENV = "org.netbeans.modules.cnd.makeproject.ui.RemoteHost";
    private static final String DATA = "org.netbeans.modules.cnd.makeproject.ui.RemoteDevelopmentAction.Data";
    private static final RequestProcessor RP = new RequestProcessor("RemoteDevelopmentAction", 1);
    private JMenu subMenu;
    private final Project[] projects;

    public static RemoteDevelopmentAction create(Project[] projects) {
        for (Project p : projects) {
            if (MakeProjectUtils.canChangeHost(p)) continue;
            return null;
        }
        return new RemoteDevelopmentAction(projects);
    }

    private RemoteDevelopmentAction(Project[] projects) {
        super(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name"), null);
        this.projects = projects;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        if (this.subMenu == null) {
            String label = NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name");
            this.subMenu = new JMenu(label);
        }
        this.subMenu.removeAll();
        ExecutionEnvironment currExecEnv = null;
        boolean envsAreSame = true;
        this.subMenu.setEnabled(true);
        final ArrayList<Pair> projectsAndConfs = new ArrayList<Pair>();
        for (Project project : this.projects) {
            if (!MakeProjectUtils.canChangeHost(project)) {
                this.subMenu.setEnabled(false);
                return;
            }
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (pdp == null || pdp.getConfigurationDescriptor() == null || pdp.getConfigurationDescriptor().getActiveConfiguration() == null) {
                this.subMenu.setEnabled(false);
                return;
            }
            MakeConfiguration mconf = pdp.getConfigurationDescriptor().getActiveConfiguration();
            if (mconf == null) {
                this.subMenu.setEnabled(false);
                return;
            }
            ExecutionEnvironment e = mconf.getDevelopmentHost().getExecutionEnvironment();
            if (e != null && envsAreSame) {
                if (currExecEnv == null) {
                    currExecEnv = e;
                } else if (!currExecEnv.equals((Object)e)) {
                    currExecEnv = null;
                    envsAreSame = false;
                }
            }
            projectsAndConfs.add(Pair.of((Object)project, (Object)mconf));
        }
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        for (ServerRecord record : ServerList.getRecords()) {
            JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(record.getServerDisplayName(), record.getExecutionEnvironment().equals(currExecEnv));
            this.subMenu.add(jmi);
            jmi.putClientProperty(HOST_ENV, record.getExecutionEnvironment());
            jmi.putClientProperty(DATA, projectsAndConfs);
            jmi.addActionListener(jmiActionListener);
        }
        this.subMenu.add(new JSeparator());
        final JMenuItem managePlatformsItem = new JMenuItem(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_ManagePlatforms_Name"));
        this.subMenu.add(managePlatformsItem);
        managePlatformsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExecutionEnvironment env;
                AtomicReference selectedEnv = new AtomicReference();
                if (ServerListUI.showServerListDialog(selectedEnv) && (env = (ExecutionEnvironment)selectedEnv.get()) != null) {
                    RemoteDevelopmentAction.setRemoteDevelopmentHost(managePlatformsItem, env, projectsAndConfs);
                }
            }
        });
    }

    private static void setRemoteDevelopmentHost(final Object source, final ExecutionEnvironment execEnv, final List<Pair<Project, MakeConfiguration>> projectsAndConfs) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RemoteDevelopmentAction._setRemoteDevelopmentHost(source, execEnv, projectsAndConfs);
                }
            });
        } else {
            RemoteDevelopmentAction._setRemoteDevelopmentHost(source, execEnv, projectsAndConfs);
        }
    }

    private static void _setRemoteDevelopmentHost(Object source, ExecutionEnvironment execEnv, List<Pair<Project, MakeConfiguration>> projectsAndConfs) {
        ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
        if (!record.isSetUp() && !record.setUp()) {
            return;
        }
        for (Pair<Project, MakeConfiguration> pac : projectsAndConfs) {
            RemoteDevelopmentAction._setRemoteDevelopmentHost(source, (MakeConfiguration)pac.second(), execEnv, (Project)pac.first());
        }
    }

    private static void _setRemoteDevelopmentHost(Object source, MakeConfiguration mconf, ExecutionEnvironment execEnv, Project project) {
        if (mconf != null && execEnv != null) {
            DevelopmentHostConfiguration dhc = new DevelopmentHostConfiguration(execEnv);
            DevelopmentHostConfiguration oldDhc = mconf.getDevelopmentHost();
            if (dhc.getExecutionEnvironment() == oldDhc.getExecutionEnvironment()) {
                return;
            }
            mconf.setDevelopmentHost(dhc);
            CompilerSet2Configuration oldCS = mconf.getCompilerSet();
            if (oldCS.isDefaultCompilerSet()) {
                mconf.setCompilerSet(new CompilerSet2Configuration(dhc));
            } else {
                String oldCSName = oldCS.getName();
                CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)dhc.getExecutionEnvironment());
                CompilerSet newCS = csm.getCompilerSet(oldCSName);
                newCS = newCS == null ? csm.getDefaultCompilerSet() : newCS;
                mconf.setCompilerSet(new CompilerSet2Configuration(dhc, newCS));
            }
            NativeProject npp = (NativeProject)project.getLookup().lookup(NativeProject.class);
            if (npp instanceof PropertyChangeListener) {
                ((PropertyChangeListener)npp).propertyChange(new PropertyChangeEvent(source, "activeConfiguration", null, mconf));
            }
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor configurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            ((ConfigurationDescriptor)configurationDescriptor).setModified();
            BrokenReferencesSupport.updateProblems(project);
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                ExecutionEnvironment execEnv = (ExecutionEnvironment)jmi.getClientProperty(RemoteDevelopmentAction.HOST_ENV);
                List projectsAndConfs = (List)jmi.getClientProperty(RemoteDevelopmentAction.DATA);
                RemoteDevelopmentAction.setRemoteDevelopmentHost(jmi, execEnv, projectsAndConfs);
            }
        }
    }
}

