/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.api.toolchain.ui.ServerListUIEx;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class DevelopmentHostCustomizer
extends JPanel
implements VetoableChangeListener {
    private final DevelopmentHostConfiguration dhconf;
    private final PropertyEnv propertyEnv;
    private final PropertyEditorSupport editor;
    private final ExecutionEnvironment oldExecEnv;
    private final AtomicReference<ExecutionEnvironment> selectedEnv;
    private final ToolsCacheManager cacheManager;
    private final JComponent component;

    public DevelopmentHostCustomizer(DevelopmentHostConfiguration dhconf, PropertyEditorSupport editor, PropertyEnv propertyEnv) {
        this.dhconf = dhconf;
        this.editor = editor;
        this.propertyEnv = propertyEnv;
        this.oldExecEnv = dhconf == null ? null : dhconf.getExecutionEnvironment();
        this.selectedEnv = new AtomicReference<ExecutionEnvironment>(this.oldExecEnv);
        this.cacheManager = ToolsCacheManager.createInstance((boolean)true);
        this.setLayout(new BorderLayout());
        this.component = ServerListUIEx.getServerListComponent((ToolsCacheManager)this.cacheManager, this.selectedEnv);
        this.add((Component)this.component, "Center");
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean changed = false;
        ExecutionEnvironment env = this.selectedEnv.get();
        if (env == null) {
            throw new PropertyVetoException(NbBundle.getMessage(this.getClass(), (String)"MSG_Null_Host"), evt);
        }
        ServerListUIEx.save((ToolsCacheManager)this.cacheManager, (JComponent)this.component);
        this.cacheManager.applyChanges();
        this.dhconf.setHost(env, true);
    }
}

