/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.BuildSupport;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.DocumentAdapter;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BuildActionsPanel
extends JPanel
implements HelpCtx.Provider {
    private final DocumentListener documentListener;
    private final BuildActionsDescriptorPanel controller;
    private String makefileName = null;
    private static final String DEF_WORKING_DIR = "";
    private static final String DEF_BUILD_COMMAND = "${MAKE}";
    private static final String DEF_CLEAN_COMMAND = "${MAKE} clean";
    private static final String DEF_COMMAND_CLEAN_COMMAND = "echo clean";
    private static final String DEF_COMMAND_BUILD_COMMAND = "echo build";
    private JLabel buildCommandLabel;
    private JTextField buildCommandTextField;
    private JButton buildCommandWorkingDirBrowseButton;
    private JLabel buildCommandWorkingDirLabel;
    private JTextField buildCommandWorkingDirTextField;
    private JButton buildLogButton;
    private JLabel buildLogLabel;
    private JTextField buildLogTextField;
    private JLabel cleanCommandLabel;
    private JTextField cleanCommandTextField;
    private JLabel group2Label;
    private JPanel instructionPanel;
    private JTextPane instructionsTextPane;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JCheckBox makeCheckBox;

    BuildActionsPanel(BuildActionsDescriptorPanel buildActionsDescriptorPanel) {
        this.initComponents();
        this.instructionsTextPane.setEditorKit(new HTMLEditorKit());
        this.instructionsTextPane.setBackground(this.instructionPanel.getBackground());
        this.controller = buildActionsDescriptorPanel;
        this.documentListener = new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                BuildActionsPanel.this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                BuildActionsPanel.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                BuildActionsPanel.this.update();
            }
        };
        this.buildCommandWorkingDirTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.cleanCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildLogTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandWorkingDirTextField.selectAll();
        this.buildCommandWorkingDirTextField.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_ACTIONS_PANEL_AD"));
        this.buildCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_COMMAND_AD"));
        this.buildCommandWorkingDirTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_AD"));
        this.cleanCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("CLEAN_COMMAND_AD"));
        this.buildCommandWorkingDirBrowseButton.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_BROWSE_BUTTON_AD"));
    }

    private void makefileFieldChanged() {
        if (this.makefileName == null || this.makefileName.isEmpty()) {
            String root = WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(this.controller.getWizardDescriptor());
            this.buildCommandWorkingDirTextField.setText(CndPathUtilities.normalizeSlashes((String)root));
            this.buildCommandTextField.setText(DEF_COMMAND_BUILD_COMMAND);
            this.cleanCommandTextField.setText(DEF_COMMAND_CLEAN_COMMAND);
        } else {
            String workinDir = CndPathUtilities.getDirName((String)this.makefileName);
            if (workinDir != null) {
                this.buildCommandWorkingDirTextField.setText(workinDir);
                BuildSupport.BuildFile scriptToBuildFile = BuildSupport.scriptToBuildFile(this.makefileName);
                if (scriptToBuildFile != null) {
                    this.buildCommandTextField.setText(scriptToBuildFile.getBuildCommandLine(null, workinDir));
                    this.cleanCommandTextField.setText(scriptToBuildFile.getCleanCommandLine(null, workinDir));
                }
            }
        }
        this.updateInstriction();
    }

    private void initFields() {
        this.buildCommandWorkingDirTextField.setText(DEF_WORKING_DIR);
        this.buildCommandTextField.setText(DEF_BUILD_COMMAND);
        this.cleanCommandTextField.setText(DEF_CLEAN_COMMAND);
        this.makeCheckBox.setSelected(true);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BuildActionsPanel.class);
    }

    private void update() {
        this.controller.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        String mn = this.initMakeFile(wizardDescriptor);
        if (mn == null || mn.isEmpty()) {
            if (this.makefileName == null) {
                this.initFields();
                this.makefileName = DEF_WORKING_DIR;
                this.makefileFieldChanged();
            }
        } else if (this.makefileName == null || !this.makefileName.equals(mn)) {
            this.initFields();
            this.makefileName = mn;
            this.makefileFieldChanged();
        }
        this.makeCheckBox.setEnabled(true);
    }

    private String initMakeFile(WizardDescriptor wizardDescriptor) {
        String res = null;
        String path = WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(wizardDescriptor);
        if (path != null) {
            if (Boolean.TRUE.equals(WizardConstants.PROPERTY_RUN_CONFIGURE.get(wizardDescriptor))) {
                String folder = WizardConstants.PROPERTY_CONFIGURE_RUN_FOLDER.get(wizardDescriptor);
                res = folder + "/Makefile";
                ExecutionEnvironment env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizardDescriptor);
                if (env != null) {
                    res = RemoteFileUtil.normalizeAbsolutePath((String)res, (ExecutionEnvironment)env);
                }
            }
            if (res == null) {
                ExecutionEnvironment ee = NewProjectWizardUtils.getExecutionEnvironment(wizardDescriptor);
                CompilerSet cs = WizardConstants.PROPERTY_TOOLCHAIN.get(wizardDescriptor);
                BuildSupport.BuildFile buildFile = BuildSupport.findBuildFileInFolder(WizardConstants.PROPERTY_NATIVE_PROJ_FO.get(wizardDescriptor), ee, cs);
                if (buildFile != null) {
                    res = buildFile.getFile();
                }
            }
        }
        return res;
    }

    void store(WizardDescriptor wizardDescriptor) {
        WizardConstants.PROPERTY_WORKING_DIR.put(wizardDescriptor, this.buildCommandWorkingDirTextField.getText());
        WizardConstants.PROPERTY_BUILD_COMMAND.put(wizardDescriptor, this.buildCommandTextField.getText());
        WizardConstants.PROPERTY_CLEAN_COMMAND.put(wizardDescriptor, this.cleanCommandTextField.getText());
        WizardConstants.PROPERTY_BUILD_RESULT.put(wizardDescriptor, DEF_WORKING_DIR);
        WizardConstants.PROPERTY_BUILD_LOG.put(wizardDescriptor, this.buildLogTextField.getText());
        WizardConstants.PROPERTY_RUN_REBUILD.put(wizardDescriptor, this.makeCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        WizardConstants.PROPERTY_USER_MAKEFILE_PATH.put(wizardDescriptor, this.makefileName);
    }

    boolean valid(WizardDescriptor settings) {
        String path;
        String msg;
        if (this.buildCommandWorkingDirTextField.getText().length() == 0) {
            msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOWORKINGDIR");
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
        }
        if (!(this.buildCommandWorkingDirTextField.getText().length() <= 0 || CndPathUtilities.isPathAbsolute((CharSequence)this.buildCommandWorkingDirTextField.getText()) && NewProjectWizardUtils.fileExists(this.buildCommandWorkingDirTextField.getText(), this.controller.getWizardDescriptor()))) {
            msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"WORKINGDIRDOESNOTEXIST");
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
        }
        if (!this.makeCheckBox.isSelected() && !(path = this.buildLogTextField.getText().trim()).isEmpty()) {
            boolean exists;
            FileObject file = NewProjectWizardUtils.getFileObject(path, settings);
            boolean bl = exists = file != null && file.isValid() && file.isData() && file.canRead();
            if (!exists) {
                settings.putProperty("WizardPanel_errorMessage", (Object)BuildActionsPanel.getString("BUILD_LOG_NOT_EXISTS"));
            }
            return exists;
        }
        return true;
    }

    private void updateInstriction() {
        if (this.makeCheckBox.isSelected()) {
            this.instructionsTextPane.setText(NbBundle.getMessage(BuildActionsPanel.class, (String)"BuildActionsInstructions"));
        } else {
            this.instructionsTextPane.setText(NbBundle.getMessage(BuildActionsPanel.class, (String)"BuildActionsInstructionsNoBuild"));
        }
    }

    private void initComponents() {
        this.buildCommandWorkingDirLabel = new JLabel();
        this.buildCommandWorkingDirTextField = new JTextField();
        this.buildCommandWorkingDirBrowseButton = new JButton();
        this.buildCommandLabel = new JLabel();
        this.buildCommandTextField = new JTextField();
        this.cleanCommandLabel = new JLabel();
        this.cleanCommandTextField = new JTextField();
        this.instructionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.instructionsTextPane = new JTextPane();
        this.group2Label = new JLabel();
        this.makeCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.buildLogLabel = new JLabel();
        this.buildLogTextField = new JTextField();
        this.buildLogButton = new JButton();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.buildCommandWorkingDirLabel.setLabelFor(this.buildCommandWorkingDirTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.buildCommandWorkingDirLabel, (String)bundle.getString("WORKING_DIR_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.buildCommandWorkingDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buildCommandWorkingDirBrowseButton, (String)bundle.getString("WORKING_DIR_BROWSE_BUTTON_TXT"));
        this.buildCommandWorkingDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsPanel.this.buildCommandWorkingDirBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirBrowseButton, gridBagConstraints);
        this.buildCommandLabel.setLabelFor(this.buildCommandTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildCommandLabel, (String)bundle.getString("BUILD_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.buildCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.buildCommandTextField, gridBagConstraints);
        this.cleanCommandLabel.setLabelFor(this.cleanCommandTextField);
        Mnemonics.setLocalizedText((JLabel)this.cleanCommandLabel, (String)bundle.getString("CLEAN_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.cleanCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.cleanCommandTextField, gridBagConstraints);
        this.instructionPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportView(this.instructionsTextPane);
        this.instructionPanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.group2Label.setText(bundle.getString("GROUP2_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.group2Label, gridBagConstraints);
        this.makeCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.makeCheckBox, (String)bundle.getString("CLEAN_BUILD_CHECKBOX"));
        this.makeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsPanel.this.makeCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.makeCheckBox, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(BuildActionsPanel.class, (String)"AdditionalBuildAtrifacts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.buildLogLabel.setLabelFor(this.buildLogTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildLogLabel, (String)NbBundle.getMessage(BuildActionsPanel.class, (String)"BUILD_LOG_TEXT_FIELD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.buildLogLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.buildLogTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buildLogButton, (String)NbBundle.getMessage(BuildActionsPanel.class, (String)"BUILD_LOG_BROWSE_BUTTON"));
        this.buildLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsPanel.this.buildLogButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.buildLogButton, gridBagConstraints);
    }

    private void buildCommandWorkingDirBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = !this.buildCommandWorkingDirTextField.getText().isEmpty() ? this.buildCommandWorkingDirTextField.getText() : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), BuildActionsPanel.getString("WORKING_DIR_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("WORKING_DIR_BUTTON_TXT"), 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilities.normalizeSlashes((String)path);
        this.buildCommandWorkingDirTextField.setText(path);
    }

    private void buildLogButtonActionPerformed(ActionEvent evt) {
        String seed = this.buildLogTextField.getText().length() > 0 ? this.buildLogTextField.getText() : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), BuildActionsPanel.getString("BUILD_LOG_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("BUILD_LOG_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{new LogFileFilter()}, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilities.normalizeSlashes((String)path);
        this.buildLogTextField.setText(path);
    }

    private void makeCheckBoxActionPerformed(ActionEvent evt) {
        this.updateInstriction();
    }

    private static String getString(String s) {
        return NbBundle.getBundle(BuildActionsPanel.class).getString(s);
    }

    private static class LogFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return BuildActionsPanel.getString("FILECHOOSER_BUILD_LOG_FILEFILTER");
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.endsWith(".log") || name.endsWith(".json");
            }
            return false;
        }
    }
}

