/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.cnd.utils.CndLanguageStandards;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class PanelProjectLocationVisual
extends SettingsPanel
implements HelpCtx.Provider {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_MAIN_NAME = "mainName";
    private volatile WizardValidationWorkerCheckState currentState = new WizardValidationWorkerCheckState(Boolean.TRUE, new ValidationResult(Boolean.FALSE, NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.Validating_Wizard")));
    private static final RequestProcessor RP = new RequestProcessor("Inot Hosts", 1);
    private static final RequestProcessor validationRP = new RequestProcessor("Wizard Validation", 1);
    static final String[] CPP = new String[]{"C++", CndLanguageStandards.CndLanguageStandard.CPP98.toString(), CndLanguageStandards.CndLanguageStandard.CPP11.toString(), CndLanguageStandards.CndLanguageStandard.CPP14.toString()};
    static final String[] C = new String[]{"C", CndLanguageStandards.CndLanguageStandard.C89.toString(), CndLanguageStandards.CndLanguageStandard.C99.toString(), CndLanguageStandards.CndLanguageStandard.C11.toString()};
    static final String[] FORTRAN = new String[]{"Fortran90 Fixed", "Fortran90 Free", "Fortran95", "Fortran2003", "Fortran2008"};
    private final PanelConfigureProject controller;
    private final String templateName;
    private String name;
    private final int type;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Object FAKE_ITEM = new Object();
    private ExecutionEnvironment env;
    private FileSystem fileSystem;
    private char fsFileSeparator;
    private final WizardValidationWorker validationWorker = new WizardValidationWorker();
    static final int VALIDATION_DELAY = 300;
    private JButton browseButton;
    private JCheckBox createMainCheckBox;
    private JComboBox createMainComboBox;
    private JTextField createMainTextField;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JLabel makefileLabel;
    private JTextField makefileTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JComboBox toolchainComboBox;
    private JLabel toolchainLabel;
    private static ResourceBundle bundle;

    public PanelProjectLocationVisual(PanelConfigureProject panel, String name, boolean showMakefileTextField, int type) {
        this.initComponents();
        this.controller = panel;
        this.controller.addChangeListener(this.validationWorker);
        this.name = name;
        this.templateName = name;
        this.type = type;
        this.projectNameTextField.getDocument().addDocumentListener(this.validationWorker);
        this.projectLocationTextField.getDocument().addDocumentListener(this.validationWorker);
        if (showMakefileTextField) {
            this.makefileTextField.getDocument().addDocumentListener(this.validationWorker);
        } else {
            this.makefileTextField.setVisible(false);
            this.makefileLabel.setVisible(false);
        }
        this.makefileTextField.getAccessibleContext().setAccessibleDescription(PanelProjectLocationVisual.getString("AD_MAKEFILE"));
        this.createMainTextField.setText("main");
        this.createMainTextField.getDocument().addDocumentListener(this.validationWorker);
        if (type == 1) {
            this.createMainCheckBox.setVisible(true);
            this.createMainTextField.setVisible(true);
            this.createMainComboBox.setVisible(true);
            this.fillComboBox("text/x-c", "text/x-c++", "text/x-fortran");
            String prefLanguage = MakeOptions.getInstance().getPrefApplicationLanguage();
            this.createMainComboBox.setSelectedItem(prefLanguage);
        } else if (type == 8) {
            this.createMainCheckBox.setVisible(true);
            this.createMainTextField.setVisible(true);
            this.createMainComboBox.setVisible(true);
            this.fillComboBox("text/x-c", "text/x-c++");
            this.createMainComboBox.setSelectedIndex(0);
        } else if (type == 4) {
            this.createMainCheckBox.setVisible(true);
            this.createMainTextField.setVisible(true);
            this.createMainComboBox.setVisible(true);
            this.fillComboBox("text/x-c++");
            this.createMainComboBox.setSelectedIndex(0);
        } else {
            this.createMainCheckBox.setVisible(false);
            this.createMainCheckBox.setSelected(false);
            this.createMainTextField.setVisible(false);
            this.createMainComboBox.setVisible(false);
        }
        PanelProjectLocationVisual.disableHostsInfo(this.hostComboBox, this.toolchainComboBox);
    }

    private void fillComboBox(String ... mimeTypes) {
        for (String mime : mimeTypes) {
            if (mime.equals("text/x-c")) {
                for (String st : C) {
                    this.createMainComboBox.addItem(st);
                }
                continue;
            }
            if (mime.equals("text/x-c++")) {
                for (String st : CPP) {
                    this.createMainComboBox.addItem(st);
                }
                continue;
            }
            if (!mime.equals("text/x-fortran")) continue;
            for (String st : FORTRAN) {
                this.createMainComboBox.addItem(st);
            }
        }
    }

    static Pair<String, Integer> getLanguageStandard(String value) {
        int i;
        if (value == null) {
            return null;
        }
        for (i = 0; i < C.length; ++i) {
            if (!value.equals(C[i])) continue;
            return Pair.of((Object)C[0], (Object)i);
        }
        for (i = 0; i < CPP.length; ++i) {
            if (!value.equals(CPP[i])) continue;
            return Pair.of((Object)CPP[0], (Object)i);
        }
        for (i = 0; i < FORTRAN.length; ++i) {
            if (!value.equals(FORTRAN[i])) continue;
            return Pair.of((Object)FORTRAN[0], (Object)i);
        }
        return null;
    }

    static void disableHostsInfo(JComboBox hostComboBox, JComboBox toolchainComboBox) {
        hostComboBox.setEnabled(false);
        toolchainComboBox.setEnabled(false);
        hostComboBox.addItem(FAKE_ITEM);
        toolchainComboBox.addItem(FAKE_ITEM);
        hostComboBox.setRenderer(new MyDevHostListCellRenderer(FAKE_ITEM));
        toolchainComboBox.setRenderer(new MyToolchainListCellRenderer(FAKE_ITEM));
    }

    static void updateToolchainsComponents(JComboBox hostComboBox, JComboBox toolchainComboBox, Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean isDefaultCompilerSet, boolean enableHost, boolean enableToolchain) {
        hostComboBox.removeAllItems();
        toolchainComboBox.removeAllItems();
        if (records != null) {
            for (ServerRecord serverRecord : records) {
                hostComboBox.addItem(serverRecord);
            }
            hostComboBox.setSelectedItem(srToSelect);
            PanelProjectLocationVisual.updateToolchains(toolchainComboBox, srToSelect);
            for (int i = 0; i < toolchainComboBox.getModel().getSize(); ++i) {
                Object elementAt = toolchainComboBox.getModel().getElementAt(i);
                if (!(elementAt instanceof ToolCollectionItem)) continue;
                ToolCollectionItem item = (ToolCollectionItem)elementAt;
                if (isDefaultCompilerSet && item.isDefaultCompilerSet()) {
                    toolchainComboBox.setSelectedIndex(i);
                    break;
                }
                if (!item.getCompilerSet().equals(csToSelect)) continue;
                toolchainComboBox.setSelectedIndex(i);
                break;
            }
            hostComboBox.setEnabled(enableHost);
            toolchainComboBox.setEnabled(enableToolchain);
        }
    }

    private static Collection<ServerRecord> initServerRecords(ToolsCacheManager toolsCacheManager, ExecutionEnvironment ee) {
        ServerRecord r;
        ArrayList<ServerRecord> out = new ArrayList<ServerRecord>();
        ArrayList<ServerRecord> records = new ArrayList<ServerRecord>();
        if (toolsCacheManager != null && toolsCacheManager.getServerUpdateCache() != null) {
            records.addAll(toolsCacheManager.getServerUpdateCache().getHosts());
        } else {
            records.addAll(ServerList.getRecords());
        }
        if (ee != null && (r = ServerList.get((ExecutionEnvironment)ee)).isSetUp()) {
            records.add(r);
        }
        for (ServerRecord serverRecord : records) {
            CompilerSetManager csm;
            if (!serverRecord.isSetUp() || serverRecord.isDeleted() || (csm = toolsCacheManager != null && ee != null ? toolsCacheManager.getCompilerSetManagerCopy(ee, false) : CompilerSetManager.get((ExecutionEnvironment)serverRecord.getExecutionEnvironment())) == null) continue;
            csm.finishInitialization();
            if (csm.isEmpty() || csm.isUninitialized()) continue;
            out.add(serverRecord);
        }
        return out;
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewAppWizard");
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.makefileLabel = new JLabel();
        this.makefileTextField = new JTextField();
        this.createMainCheckBox = new JCheckBox();
        this.createMainTextField = new JTextField();
        this.createMainComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.toolchainLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.toolchainComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.projectNameLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectNameLabel"));
        this.projectNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectLocationLabel"));
        this.projectLocationTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_browseButton"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_createdFolderLabel"));
        this.createdFolderTextField.setColumns(20);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.makefileLabel.setLabelFor(this.makefileTextField);
        Mnemonics.setLocalizedText((JLabel)this.makefileLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_MAKEFILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.makefileLabel, gridBagConstraints);
        this.makefileTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.makefileTextField, gridBagConstraints);
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)bundle.getString("LBL_createMainfile"));
        this.createMainCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.createMainCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.createMainCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.createMainTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.createMainComboBox, gridBagConstraints);
        this.hostLabel.setLabelFor(this.hostComboBox);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.toolchainLabel.setLabelFor(this.toolchainComboBox);
        Mnemonics.setLocalizedText((JLabel)this.toolchainLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_TOOLCHAIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.toolchainLabel, gridBagConstraints);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelProjectLocationVisual.this.hostComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.toolchainComboBox, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent evt) {
        String path = this.projectLocationTextField.getText();
        JFileChooser chooser = RemoteFileUtil.createFileChooser((FileSystem)FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env), (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"), null, (int)1, null, (String)path, (boolean)true);
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
        this.controller.fireChangeEvent();
    }

    private void createMainCheckBoxActionPerformed(ActionEvent evt) {
        this.createMainTextField.setEnabled(this.createMainCheckBox.isSelected());
        this.createMainComboBox.setEnabled(this.createMainCheckBox.isSelected());
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initialized.get()) {
            return;
        }
        if (evt.getStateChange() == 1) {
            ServerRecord newItem = (ServerRecord)evt.getItem();
            PanelProjectLocationVisual.updateToolchains(this.toolchainComboBox, newItem);
            this.controller.fireChangeEvent();
        }
    }

    static void updateToolchains(JComboBox toolchainComboBox, ServerRecord newItem) {
        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)newItem.getExecutionEnvironment());
        toolchainComboBox.removeAllItems();
        CompilerSet defaultCompilerSet = csm.getDefaultCompilerSet();
        if (defaultCompilerSet != null) {
            toolchainComboBox.addItem(new ToolCollectionItem(defaultCompilerSet, true));
        }
        for (CompilerSet compilerSet : csm.getCompilerSets()) {
            toolchainComboBox.addItem(new ToolCollectionItem(compilerSet, false));
        }
        if (toolchainComboBox.getModel().getSize() > 0) {
            toolchainComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.validationWorker.shutdown();
    }

    private boolean isValidMakeFile(String text) {
        if (text.length() == 0) {
            return false;
        }
        return !text.contains("\\") && !text.contains("/") && !text.contains("..") && !PanelProjectLocationVisual.hasIllegalChar(text);
    }

    private boolean isValidMainFile(String text) {
        if (text.length() == 0) {
            return true;
        }
        return !text.startsWith(" ") && !text.startsWith("\\") && !text.startsWith("/") && !text.contains("..") && !PanelProjectLocationVisual.hasIllegalChar(text);
    }

    public static boolean isValidProjectName(String text) {
        if (text.length() == 0 || text.startsWith(" ") || text.contains("\\") || text.contains("/") || PanelProjectLocationVisual.hasIllegalChar(text)) {
            return false;
        }
        boolean ok = false;
        try {
            File file = File.createTempFile(text + "dummy", "");
            ok = true;
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    private static boolean hasIllegalChar(String text) {
        return text.contains(":") || text.contains("*") || text.contains("?") || text.contains("\"") || text.contains("<") || text.contains(">") || text.contains("|");
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!this.initialized.get() || this.currentState == null) {
            return false;
        }
        ValidationResult result = this.currentState.validationResult;
        boolean valid = result.isValid;
        wizardDescriptor.putProperty(result.isValid != false ? "WizardPanel_warningMessage" : "WizardPanel_errorMessage", (Object)result.msgError);
        return valid;
    }

    void setError() {
        this.controller.fireChangeEvent(new ChangeEvent(this.validationWorker));
    }

    private FileObject getExistingParent(String path) {
        path = PathUtilities.getDirName((String)path);
        FileObject fo = this.fileSystem.findResource(path);
        while (fo == null) {
            if ((path = PathUtilities.getDirName((String)path)) == null || path.length() == 0) {
                return null;
            }
            fo = this.fileSystem.findResource(path);
        }
        return fo;
    }

    @Override
    void store(WizardDescriptor d) {
        Object selectedItem;
        Object obj;
        String projectName = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        Boolean valid = this.currentState.validationResult.isValid;
        if (valid.booleanValue()) {
            if (CndPathUtilities.isPathAbsolute((CharSequence)folder)) {
                String normalizeAbsolutePath = RemoteFileUtil.normalizeAbsolutePath((String)folder, (ExecutionEnvironment)this.env);
                FSPath path = new FSPath(this.fileSystem, normalizeAbsolutePath);
                WizardConstants.PROPERTY_PROJECT_FOLDER.put(d, path);
            }
        } else {
            WizardConstants.PROPERTY_PROJECT_FOLDER_STRING_VALUE.put(d, this.projectLocationTextField.getText().trim());
        }
        WizardConstants.PROPERTY_NAME.put(d, projectName);
        WizardConstants.PROPERTY_GENERATED_MAKEFILE_NAME.put(d, this.makefileTextField.getText());
        if (valid.booleanValue() && CndPathUtilities.isPathAbsolute((CharSequence)this.projectLocationTextField.getText())) {
            if (this.env.isLocal()) {
                File projectsDir = CndFileUtils.createLocalFile((String)this.projectLocationTextField.getText());
                if (projectsDir.isDirectory()) {
                    ProjectChooser.setProjectsFolder((File)projectsDir);
                }
            } else {
                RemoteFileUtil.setProjectsFolder((String)this.projectLocationTextField.getText(), (ExecutionEnvironment)this.env);
            }
        }
        WizardConstants.MAIN_CLASS.put(d, null);
        MIMEExtensions cExtensions = MIMEExtensions.get((String)"text/x-c");
        MIMEExtensions ccExtensions = MIMEExtensions.get((String)"text/x-c++");
        MIMEExtensions fortranExtensions = MIMEExtensions.get((String)"text/x-fortran");
        WizardConstants.PROPERTY_CREATE_MAIN_FILE.put(d, this.createMainCheckBox.isSelected());
        if (this.createMainCheckBox.isSelected() && this.createMainTextField.getText().length() > 0) {
            Pair<String, Integer> languageStandard;
            if (this.type == 1) {
                languageStandard = PanelProjectLocationVisual.getLanguageStandard((String)this.createMainComboBox.getSelectedItem());
                if (languageStandard != null) {
                    WizardConstants.PROPERTY_LANGUAGE_STANDARD.put(d, (String)this.createMainComboBox.getSelectedItem());
                    if (((String)languageStandard.first()).equals(C[0])) {
                        WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + "." + cExtensions.getDefaultExtension());
                        WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/cFiles/main.c");
                    } else if (((String)languageStandard.first()).equals(CPP[0])) {
                        WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + "." + ccExtensions.getDefaultExtension());
                        WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/cppFiles/main.cc");
                    } else if (((String)languageStandard.first()).equals(FORTRAN[0])) {
                        switch ((Integer)languageStandard.second()) {
                            case 0: {
                                WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".f");
                                WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/fortranFiles/fortranFixedFormatFile.f");
                                break;
                            }
                            case 1: {
                                WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".f90");
                                WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/fortranFiles/fortranFreeFormatFile.f90");
                                break;
                            }
                            case 2: {
                                WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".f95");
                                WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/fortranFiles/fortranFreeFormatFile.f90");
                                break;
                            }
                            case 3: {
                                WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".f03");
                                WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/fortranFiles/fortranFreeFormatFile.f90");
                                break;
                            }
                            case 4: {
                                WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".f08");
                                WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/fortranFiles/fortranFreeFormatFile.f90");
                            }
                        }
                    }
                }
                MakeOptions.getInstance().setPrefApplicationLanguage((String)this.createMainComboBox.getSelectedItem());
            } else if (this.type == 8) {
                languageStandard = PanelProjectLocationVisual.getLanguageStandard((String)this.createMainComboBox.getSelectedItem());
                if (languageStandard != null) {
                    WizardConstants.PROPERTY_LANGUAGE_STANDARD.put(d, (String)this.createMainComboBox.getSelectedItem());
                    if (((String)languageStandard.first()).equals(C[0])) {
                        WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".pc");
                        WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/cFiles/main.pc");
                    } else if (((String)languageStandard.first()).equals(CPP[0])) {
                        WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + ".pc");
                        WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/ccFiles/main.pc");
                    }
                }
            } else if (this.type == 4 && (languageStandard = PanelProjectLocationVisual.getLanguageStandard((String)this.createMainComboBox.getSelectedItem())) != null) {
                WizardConstants.PROPERTY_LANGUAGE_STANDARD.put(d, (String)this.createMainComboBox.getSelectedItem());
                if (((String)languageStandard.first()).equals(CPP[0])) {
                    WizardConstants.PROPERTY_MAIN_FILE_NAME.put(d, this.createMainTextField.getText() + "." + ccExtensions.getDefaultExtension());
                    WizardConstants.PROPERTY_MAIN_TEMPLATE_NAME.put(d, "Templates/qtFiles/main.cc");
                }
            }
        }
        if ((obj = this.hostComboBox.getSelectedItem()) != null && obj instanceof ServerRecord) {
            ServerRecord sr = (ServerRecord)obj;
            WizardConstants.PROPERTY_HOST_UID.put(d, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)sr.getExecutionEnvironment()));
        }
        if ((selectedItem = this.toolchainComboBox.getSelectedItem()) instanceof ToolCollectionItem) {
            ToolCollectionItem item = (ToolCollectionItem)selectedItem;
            WizardConstants.PROPERTY_TOOLCHAIN.put(d, item.getCompilerSet());
            WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.put(d, item.isDefaultCompilerSet());
        }
    }

    @Override
    void read(final WizardDescriptor settings) {
        String project;
        String projectLocation;
        boolean enabledHost;
        this.initialized.set(false);
        this.env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(settings);
        if (this.env != null) {
            WizardConstants.PROPERTY_HOST_UID.put(settings, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env));
            enabledHost = false;
        } else {
            this.env = ExecutionEnvironmentFactory.getLocal();
            enabledHost = true;
        }
        this.fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env);
        this.fsFileSeparator = FileSystemProvider.getFileSeparatorChar((FileSystem)this.fileSystem);
        FSPath projectLocationFSPath = WizardConstants.PROPERTY_PROJECT_FOLDER.get(settings);
        String projectName = null;
        if (projectLocationFSPath == null) {
            String projectLocationStringValue = WizardConstants.PROPERTY_PROJECT_FOLDER_STRING_VALUE.get(settings);
            if (projectLocationStringValue != null && !projectLocationStringValue.trim().isEmpty()) {
                projectLocation = projectLocationStringValue;
            } else {
                projectLocation = RemoteFileUtil.getProjectsFolder((ExecutionEnvironment)this.env);
                if (projectLocation == null) {
                    projectLocation = this.getDefaultProjectDir(this.env);
                }
            }
        } else {
            projectLocation = projectLocationFSPath.getPath();
            int i = projectLocation.lastIndexOf(this.fsFileSeparator);
            if (i > 0) {
                projectName = projectLocation.substring(i + 1);
                projectLocation = projectLocation.substring(0, i);
            }
        }
        String projectNameText = projectName;
        final String projectLocationText = projectLocation;
        this.projectLocationTextField.setText(projectLocationText);
        this.projectLocationTextField.setText(projectLocationText);
        if (projectNameText != null) {
            this.projectNameTextField.setText(projectNameText);
            this.projectNameTextField.selectAll();
        }
        String hostUID = WizardConstants.PROPERTY_HOST_UID.get(settings);
        CompilerSet cs = WizardConstants.PROPERTY_TOOLCHAIN.get(settings);
        boolean isDefaultCompilerSet = Boolean.TRUE.equals(WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.get(settings));
        Boolean readOnlyToolchain = WizardConstants.PROPERTY_READ_ONLY_TOOLCHAIN.get(settings);
        if (Boolean.TRUE.equals(readOnlyToolchain)) {
            enabledHost = false;
        }
        final boolean enabledHostFinal = enabledHost;
        RP.post((Runnable)new DevHostsInitializer(hostUID, cs, isDefaultCompilerSet, readOnlyToolchain, WizardConstants.PROPERTY_TOOLS_CACHE_MANAGER.get(settings)){

            @Override
            public void updateComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean isDefaultCompilerSet, boolean enabled) {
                PanelProjectLocationVisual.updateToolchainsComponents(PanelProjectLocationVisual.this.hostComboBox, PanelProjectLocationVisual.this.toolchainComboBox, records, srToSelect, csToSelect, isDefaultCompilerSet, enabledHostFinal, enabled);
                PanelProjectLocationVisual.this.initialized.set(true);
                PanelProjectLocationVisual.this.controller.fireChangeEvent();
            }
        });
        String prefferedName = WizardConstants.PROPERTY_PREFERED_PROJECT_NAME.get(settings);
        if (prefferedName != null && prefferedName.length() > 0) {
            this.name = prefferedName;
        }
        if ((project = projectNameText) == null) {
            if (this.name == null) {
                String workingDir = WizardConstants.PROPERTY_WORKING_DIR.get(settings);
                if (workingDir != null && workingDir.length() > 0 && (this.templateName.equals("MakefileProject") || this.templateName.equals("FullRemoteProject"))) {
                    this.name = CndPathUtilities.getBaseName((String)workingDir);
                } else {
                    String sourcesPath = WizardConstants.PROPERTY_SOURCE_FOLDER_PATH.get(settings);
                    if (sourcesPath != null && sourcesPath.length() > 0) {
                        this.name = CndPathUtilities.getBaseName((String)sourcesPath);
                    }
                }
            }
            int baseCount = 1;
            final String formater = this.name + "_{0}";
            final String firstName = MessageFormat.format(formater, baseCount);
            this.projectNameTextField.setText(firstName);
            this.projectNameTextField.selectAll();
            validationRP.post(new Runnable(){

                @Override
                public void run() {
                    int baseCount = 1;
                    String project = firstName;
                    while ((project = PanelProjectLocationVisual.this.validFreeProjectName(projectLocationText, PanelProjectLocationVisual.this.fsFileSeparator, formater, baseCount)) == null) {
                        ++baseCount;
                    }
                    settings.putProperty("nameIndex", (Object)baseCount);
                    if (!project.equals(firstName)) {
                        final String projectNameRecalculated = project;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PanelProjectLocationVisual.this.projectNameTextField.setText(projectNameRecalculated);
                                PanelProjectLocationVisual.this.projectNameTextField.selectAll();
                            }
                        });
                    }
                }
            });
        }
    }

    private String getDefaultProjectDir(ExecutionEnvironment env) {
        String res = null;
        try {
            if (env.isLocal()) {
                res = ProjectChooser.getProjectsFolder().getPath();
            } else if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                res = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + this.fsFileSeparator + ProjectChooser.getProjectsFolder().getName();
            }
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return res == null ? this.fileSystem.getRoot().getPath() : res;
    }

    private String validFreeProjectName(String parentFolder, char fs, String formater, int index) {
        String projectName = MessageFormat.format(formater, index);
        if (RemoteFileUtil.fileExists((String)(parentFolder + fs + projectName), (ExecutionEnvironment)this.env)) {
            return null;
        }
        return projectName;
    }

    private static ValidationResult isValidLocalProjectNameAndLocation(String projectNameTextField, String projectLocationTextField, String createdFolderTextField) {
        if (!PanelProjectLocationVisual.isValidProjectName(projectNameTextField)) {
            return new ValidationResult(Boolean.FALSE, NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
        }
        if (!CndPathUtilities.isPathAbsolute((CharSequence)projectLocationTextField)) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            return new ValidationResult(Boolean.FALSE, message);
        }
        File f = CndFileUtils.createLocalFile((String)projectLocationTextField).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(f) == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            return new ValidationResult(Boolean.FALSE, message);
        }
        File destFolder = PanelProjectLocationVisual.getCanonicalFile(CndFileUtils.createLocalFile((String)createdFolderTextField).getAbsoluteFile());
        if (destFolder == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName");
            return new ValidationResult(Boolean.FALSE, message);
        }
        return new ValidationResult(Boolean.TRUE, null);
    }

    private String contructProjectMakefileName(String projectName, int count) {
        String makefileName = projectName + "-" + "Makefile";
        makefileName = count > 0 ? makefileName + "" + count + ".mk" : makefileName + ".mk";
        return makefileName;
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PanelProjectLocationVisual.class);
        }
        return bundle.getString(s);
    }

    private class WizardValidationWorker
    implements Runnable,
    DocumentListener,
    ChangeListener {
        private final Object wizardValidationExecutorLock = new Object();
        private final ScheduledExecutorService wizardValidationExecutor;
        private ScheduledFuture<?> wizardValidationTask;
        private long lastEventID = 0L;
        private WizardValidationWorkerCheckState lastCheck = null;
        private ProjectValidationParams projectParams;
        private final AtomicBoolean makefileNameChangedManually = new AtomicBoolean(false);

        WizardValidationWorker() {
            this.wizardValidationExecutor = Executors.newScheduledThreadPool(1);
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                WizardValidationWorkerCheckState curStatus = this.lastCheck;
                PanelProjectLocationVisual.this.currentState = curStatus;
                ValidationResult validationResult = null;
                if (curStatus != null) {
                    validationResult = curStatus.validationResult;
                }
                if (curStatus == null || curStatus.checking == null) {
                    if (validationResult != null) {
                        validationResult = new ValidationResult(Boolean.TRUE, validationResult.msgError);
                    }
                    PanelProjectLocationVisual.this.currentState = new WizardValidationWorkerCheckState(null, validationResult);
                }
                PanelProjectLocationVisual.this.setError();
            } else {
                this.recalculateProjectParams();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ValidationResult result = this.validate();
                if (Thread.interrupted()) {
                    return;
                }
                this.lastCheck = new WizardValidationWorkerCheckState(result.isValid != false ? null : Boolean.FALSE, result);
                SwingUtilities.invokeLater(this);
            }
        }

        void recalculateProjectParams() {
            if (this.makefileNameChangedManually.get()) {
                return;
            }
            String createdFolderTextFieldValue = this.projectParams.createdProjectFolder.trim();
            String projectName = this.projectParams.projectName;
            String makefileName = !PanelProjectLocationVisual.this.templateName.equals("MakefileProject") ? "Makefile" : PanelProjectLocationVisual.this.contructProjectMakefileName(projectName, 0);
            if (CndFileUtils.isExistingDirectory((FileSystem)PanelProjectLocationVisual.this.fileSystem, (String)createdFolderTextFieldValue)) {
                int count = 0;
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    String proposedMakefile = createdFolderTextFieldValue + PanelProjectLocationVisual.this.fsFileSeparator + makefileName;
                    if (!CndFileUtils.isExistingFile((FileSystem)PanelProjectLocationVisual.this.fileSystem, (String)proposedMakefile) && !CndFileUtils.isExistingFile((FileSystem)PanelProjectLocationVisual.this.fileSystem, (String)proposedMakefile.toLowerCase(Locale.getDefault())) && !CndFileUtils.isExistingFile((FileSystem)PanelProjectLocationVisual.this.fileSystem, (String)proposedMakefile.toUpperCase(Locale.getDefault()))) break;
                    makefileName = PanelProjectLocationVisual.this.contructProjectMakefileName(projectName, count++);
                }
            }
            final String makefileNameText = makefileName;
            final long currentEventID = this.projectParams.eventID;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (currentEventID < WizardValidationWorker.this.lastEventID) {
                        return;
                    }
                    PanelProjectLocationVisual.this.makefileTextField.getDocument().removeDocumentListener(WizardValidationWorker.this);
                    PanelProjectLocationVisual.this.makefileTextField.setText(makefileNameText);
                    WizardValidationWorker.this.projectParams.setMakefile(makefileNameText);
                    PanelProjectLocationVisual.this.makefileTextField.getDocument().addDocumentListener(WizardValidationWorker.this);
                }
            });
        }

        public ValidationResult validate() {
            if (this.projectParams.eventID < this.lastEventID) {
                return new ValidationResult(Boolean.FALSE, null);
            }
            String projectFolder = this.projectParams.createdProjectFolder.trim();
            String projectLocation = this.projectParams.projectLocation.trim();
            if (projectFolder.isEmpty() || projectLocation.isEmpty()) {
                String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
                return new ValidationResult(Boolean.FALSE, message);
            }
            ValidationResult result = PanelProjectLocationVisual.isValidLocalProjectNameAndLocation(PanelProjectLocationVisual.this.projectNameTextField.getText(), projectLocation, projectFolder);
            if (!result.isValid.booleanValue()) {
                return result;
            }
            String makefileName = this.projectParams.makefileTextField;
            if (makefileName.contains(" ")) {
                String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_SpacesInMakefile");
                return new ValidationResult(Boolean.FALSE, message);
            }
            if (!PanelProjectLocationVisual.this.isValidMakeFile(makefileName)) {
                String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalMakefileName");
                return new ValidationResult(Boolean.FALSE, message);
            }
            if (this.projectParams.isMainCreated && !PanelProjectLocationVisual.this.isValidMainFile(this.projectParams.createdMain)) {
                String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalMainFileName");
                return new ValidationResult(Boolean.FALSE, message);
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null);
            }
            FileObject projectDirFO = PanelProjectLocationVisual.this.fileSystem.findResource(projectFolder);
            if (projectDirFO != null && projectDirFO.isValid()) {
                if (projectDirFO.isData()) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectfolderNotEmpty", (Object)makefileName);
                    return new ValidationResult(Boolean.FALSE, message);
                }
                if (Thread.interrupted()) {
                    return new ValidationResult(Boolean.FALSE, null);
                }
                FileObject nbProjFO = projectDirFO.getFileObject("nbproject");
                if (nbProjFO != null && nbProjFO.isValid()) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectfolderNotEmpty", (Object)"nbproject");
                    return new ValidationResult(Boolean.FALSE, message);
                }
                if (Thread.interrupted()) {
                    return new ValidationResult(Boolean.FALSE, null);
                }
                FileObject makeFO = PanelProjectLocationVisual.this.fileSystem.findResource(projectDirFO.getPath() + PanelProjectLocationVisual.this.fsFileSeparator + makefileName);
                if (makeFO != null && makeFO.isValid()) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectfolderNotEmpty", (Object)makefileName);
                    return new ValidationResult(Boolean.FALSE, message);
                }
                if (Thread.interrupted()) {
                    return new ValidationResult(Boolean.FALSE, null);
                }
                FileObject nbFO = PanelProjectLocationVisual.this.fileSystem.findResource(projectDirFO.getPath() + PanelProjectLocationVisual.this.fsFileSeparator + "nbproject");
                if (nbFO != null && nbFO.isValid()) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectfolderNotEmpty", (Object)"nbproject");
                    return new ValidationResult(Boolean.FALSE, message);
                }
                if (Thread.interrupted()) {
                    return new ValidationResult(Boolean.FALSE, null);
                }
                if (PanelProjectLocationVisual.this.type != 0 && PanelProjectLocationVisual.this.type != 7) {
                    FileObject destFO = PanelProjectLocationVisual.this.fileSystem.findResource(projectDirFO.getPath() + PanelProjectLocationVisual.this.fsFileSeparator + "dist");
                    if (destFO != null && destFO.isValid()) {
                        String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists");
                        return new ValidationResult(Boolean.FALSE, message);
                    }
                    FileObject buildFO = PanelProjectLocationVisual.this.fileSystem.findResource(projectDirFO.getPath() + PanelProjectLocationVisual.this.fsFileSeparator + "build");
                    if (buildFO != null && buildFO.isValid()) {
                        String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists");
                        return new ValidationResult(Boolean.FALSE, message);
                    }
                }
            } else {
                if (Thread.interrupted()) {
                    return new ValidationResult(Boolean.FALSE, null);
                }
                FileObject existingParent = PanelProjectLocationVisual.this.getExistingParent(projectFolder);
                if (existingParent == null) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly");
                    return new ValidationResult(Boolean.FALSE, message);
                }
                if (!existingParent.canWrite()) {
                    String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly");
                    return new ValidationResult(Boolean.FALSE, message);
                }
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null);
            }
            Object sr = PanelProjectLocationVisual.this.hostComboBox.getSelectedItem();
            if (!(sr instanceof ServerRecord) || !((ServerRecord)sr).isOnline()) {
                String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_OfflineHost");
                return new ValidationResult(Boolean.TRUE, message);
            }
            return new ValidationResult(Boolean.TRUE, null);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateDocument(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateDocument(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateDocument(e);
        }

        private void updateDocument(DocumentEvent e) {
            String projectName = PanelProjectLocationVisual.this.projectNameTextField.getText().trim();
            String projectFolder = PanelProjectLocationVisual.this.projectLocationTextField.getText().trim();
            if (e.getDocument() == PanelProjectLocationVisual.this.projectNameTextField.getDocument() || e.getDocument() == PanelProjectLocationVisual.this.projectLocationTextField.getDocument()) {
                while (projectFolder.endsWith("/") || projectFolder.endsWith("\\")) {
                    projectFolder = projectFolder.substring(0, projectFolder.length() - 1);
                }
                String projectFolderText = projectFolder;
                String createdFolderTextFieldValue = projectFolderText + PanelProjectLocationVisual.this.fsFileSeparator + projectName;
                PanelProjectLocationVisual.this.createdFolderTextField.setText(createdFolderTextFieldValue);
                if (PanelProjectLocationVisual.this.makefileTextField.getText().trim().isEmpty()) {
                    String makefileName = !PanelProjectLocationVisual.this.templateName.equals("MakefileProject") ? "Makefile" : PanelProjectLocationVisual.this.contructProjectMakefileName(projectName, 0);
                    PanelProjectLocationVisual.this.makefileTextField.getDocument().removeDocumentListener(this);
                    PanelProjectLocationVisual.this.makefileTextField.setText(makefileName);
                    PanelProjectLocationVisual.this.makefileTextField.getDocument().addDocumentListener(this);
                }
            }
            if (e.getDocument() == PanelProjectLocationVisual.this.makefileTextField.getDocument()) {
                this.makefileNameChangedManually.set(true);
            }
            String createdFolderTextFieldValue = PanelProjectLocationVisual.this.createdFolderTextField.getText().trim();
            this.projectParams = new ProjectValidationParams(projectName, projectFolder, createdFolderTextFieldValue);
            this.projectParams.setMainAttributes(PanelProjectLocationVisual.this.createMainCheckBox.isSelected(), PanelProjectLocationVisual.this.createMainTextField.getText().trim());
            this.projectParams.setMakefile(PanelProjectLocationVisual.this.makefileTextField.getText().trim());
            this.handleProjectParamsChanges();
            if (PanelProjectLocationVisual.this.projectNameTextField.getDocument() == e.getDocument()) {
                PanelProjectLocationVisual.this.firePropertyChange(PanelProjectLocationVisual.PROP_PROJECT_NAME, null, PanelProjectLocationVisual.this.projectNameTextField.getText());
            }
            if (PanelProjectLocationVisual.this.createMainTextField.getDocument() == e.getDocument()) {
                PanelProjectLocationVisual.this.firePropertyChange(PanelProjectLocationVisual.PROP_MAIN_NAME, null, PanelProjectLocationVisual.this.createMainTextField.getText());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleProjectParamsChanges() {
            Object object = this.wizardValidationExecutorLock;
            synchronized (object) {
                if (this.wizardValidationExecutor.isShutdown()) {
                    return;
                }
            }
            if (this.projectParams != null) {
                this.projectParams.setRequestID(++this.lastEventID);
            }
            ValidationResult validationResult = new ValidationResult(Boolean.FALSE, NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.Validating_Wizard"));
            PanelProjectLocationVisual.this.currentState = new WizardValidationWorkerCheckState(Boolean.TRUE, validationResult);
            PanelProjectLocationVisual.this.setError();
            Object object2 = this.wizardValidationExecutorLock;
            synchronized (object2) {
                if (this.wizardValidationTask != null) {
                    this.wizardValidationTask.cancel(true);
                }
                this.wizardValidationTask = this.wizardValidationExecutor.schedule(this, 300L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = this.wizardValidationExecutorLock;
            synchronized (object) {
                if (this.wizardValidationTask != null) {
                    this.wizardValidationTask.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            Object object = this.wizardValidationExecutorLock;
            synchronized (object) {
                if (this.wizardValidationTask != null) {
                    this.wizardValidationTask.cancel(true);
                }
                this.wizardValidationExecutor.shutdown();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this) {
                return;
            }
            this.handleProjectParamsChanges();
        }
    }

    private static final class ProjectValidationParams {
        private final String projectName;
        private final String projectLocation;
        private final String createdProjectFolder;
        private String makefileTextField;
        private long eventID;
        private String createdMain;
        private boolean isMainCreated;

        ProjectValidationParams(String projectName, String projectLocation, String createdProjectFolder) {
            this.projectName = projectName;
            this.projectLocation = projectLocation;
            this.createdProjectFolder = createdProjectFolder;
        }

        void setRequestID(long eventID) {
            this.eventID = eventID;
        }

        void setMakefile(String makefileTextField) {
            this.makefileTextField = makefileTextField;
        }

        void setMainAttributes(boolean isMainCreated, String createdMain) {
            this.isMainCreated = isMainCreated;
            this.createdMain = createdMain;
        }
    }

    private static final class WizardValidationWorkerCheckState {
        private final Boolean checking;
        private final ValidationResult validationResult;

        private WizardValidationWorkerCheckState(Boolean checking, ValidationResult validationResult) {
            this.checking = checking;
            this.validationResult = validationResult;
        }
    }

    public static final class ToolCollectionItem {
        private final boolean defaultCompilerSet;
        private final CompilerSet compilerSet;

        private ToolCollectionItem(CompilerSet compilerSet, boolean defaultCompilerSet) {
            this.defaultCompilerSet = defaultCompilerSet;
            this.compilerSet = compilerSet;
        }

        public String toString() {
            String name = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Toolchain_Name_Text", (Object)this.compilerSet.getName(), (Object)this.compilerSet.getDisplayName());
            if (this.isDefaultCompilerSet()) {
                return PanelProjectLocationVisual.getString("DefaultToolCollection") + " (" + name + ")";
            }
            return name;
        }

        public boolean isDefaultCompilerSet() {
            return this.defaultCompilerSet;
        }

        public CompilerSet getCompilerSet() {
            return this.compilerSet;
        }
    }

    static abstract class DevHostsInitializer
    implements Runnable {
        private final String hostUID;
        private final CompilerSet cs;
        private final boolean isDefaultCompilerSet;
        private final boolean readOnlyUI;
        private final ToolsCacheManager toolsCacheManager;
        private Collection<ServerRecord> records;
        private ServerRecord srToSelect;
        private CompilerSet csToSelect;

        public DevHostsInitializer(String hostUID, CompilerSet cs, boolean isDefaultCompilerSet, Boolean readOnlyToolchain, ToolsCacheManager toolsCacheManager) {
            this.hostUID = hostUID;
            this.cs = cs;
            this.isDefaultCompilerSet = isDefaultCompilerSet;
            this.readOnlyUI = readOnlyToolchain == null ? false : readOnlyToolchain;
            this.toolsCacheManager = toolsCacheManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    ExecutionEnvironment ee = this.hostUID == null ? null : ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID);
                    this.records = PanelProjectLocationVisual.initServerRecords(this.toolsCacheManager, ee);
                    this.srToSelect = null;
                    if (ee != null) {
                        this.srToSelect = ServerList.get((ExecutionEnvironment)ee);
                    }
                    if (!this.records.contains(this.srToSelect)) {
                        this.srToSelect = null;
                    }
                    if (this.srToSelect == null || this.srToSelect.isDeleted()) {
                        this.srToSelect = ServerList.getDefaultRecord();
                        if (!this.records.contains(this.srToSelect) && !this.records.isEmpty()) {
                            this.srToSelect = this.records.iterator().next();
                        }
                    }
                    if (this.cs == null) {
                        CompilerSetManager csm = this.toolsCacheManager == null ? CompilerSetManager.get((ExecutionEnvironment)this.srToSelect.getExecutionEnvironment()) : this.toolsCacheManager.getCompilerSetManagerCopy(this.srToSelect.getExecutionEnvironment(), false);
                        this.csToSelect = csm.getDefaultCompilerSet();
                    }
                    this.csToSelect = this.cs;
                }
                finally {
                    SwingUtilities.invokeLater(this);
                }
            } else {
                this.updateComponents(this.records, this.srToSelect, this.csToSelect, this.isDefaultCompilerSet, !this.readOnlyUI);
            }
        }

        public abstract void updateComponents(Collection<ServerRecord> var1, ServerRecord var2, CompilerSet var3, boolean var4, boolean var5);
    }

    static final class MyToolchainListCellRenderer
    extends DefaultListCellRenderer {
        private final Object loadingMarker;

        public MyToolchainListCellRenderer(Object loadingItem) {
            this.loadingMarker = loadingItem;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.loadingMarker.equals(value)) {
                label.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Loading_Toolchain_Text"));
            } else {
                label.setText(value.toString());
            }
            return label;
        }
    }

    static final class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        private final Object loadingMarker;

        public MyDevHostListCellRenderer(Object loadingItem) {
            this.loadingMarker = loadingItem;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.loadingMarker.equals(value)) {
                label.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"Loading_Host_Text"));
            } else {
                ServerRecord rec = (ServerRecord)value;
                if (rec != null) {
                    label.setText(rec.getDisplayName());
                }
            }
            return label;
        }
    }

    private static class ValidationResult {
        private Boolean isValid;
        private String msgError;

        ValidationResult(Boolean isValid, String msgError) {
            this.isValid = isValid;
            this.msgError = msgError;
        }
    }
}

