/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.netbeans.modules.spring.java.PropertyType;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Node;

public class PropertyCompletor
extends Completor {
    public PropertyCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        int idx = context.getCurrentToken().getOffset() + 1;
        String typedPrefix = context.getTypedPrefix();
        int offset = typedPrefix.lastIndexOf(46);
        return idx + offset + 1;
    }

    @Override
    protected void compute(final CompletionContext context) throws IOException {
        final String propertyPrefix = context.getTypedPrefix();
        JavaSource js = JavaUtils.getJavaSource(context.getFileObject());
        if (js == null) {
            return;
        }
        final int dotIndex = propertyPrefix.lastIndexOf(".");
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Tag beanTag = (Tag)SpringXMLConfigEditorUtils.getBean(context.getTag());
                if (beanTag == null) {
                    return;
                }
                String className = new BeanClassFinder(SpringXMLConfigEditorUtils.getTagAttributes((Node)beanTag), context.getFileObject()).findImplementationClass(true);
                if (className == null) {
                    return;
                }
                TypeElement te = JavaUtils.findClassElementByBinaryName(className, cc);
                if (te == null) {
                    return;
                }
                TypeMirror startType = te.asType();
                ElementUtilities eu = cc.getElementUtilities();
                if (dotIndex != -1) {
                    String getterChain = propertyPrefix.substring(0, dotIndex);
                    StringTokenizer tokenizer = new StringTokenizer(getterChain, ".");
                    while (tokenizer.hasMoreTokens() && startType != null) {
                        String propertyName = tokenizer.nextToken();
                        Property[] props = new PropertyFinder(startType, propertyName, eu, MatchType.PREFIX).findProperties();
                        if (props.length == 0 || props[0].getGetter() == null) {
                            startType = null;
                            break;
                        }
                        TypeMirror retType = props[0].getGetter().getReturnType();
                        if (retType.getKind() == TypeKind.DECLARED) {
                            startType = retType;
                            continue;
                        }
                        startType = null;
                    }
                }
                if (startType == null) {
                    return;
                }
                String setterPrefix = "";
                if (dotIndex != propertyPrefix.length() - 1) {
                    setterPrefix = propertyPrefix.substring(dotIndex + 1);
                }
                Property[] props = new PropertyFinder(startType, setterPrefix, eu, MatchType.PREFIX).findProperties();
                EnumSet<PropertyType> typeWithSetters = EnumSet.of(PropertyType.READ_WRITE, PropertyType.WRITE_ONLY);
                for (Property prop : props) {
                    boolean hasSetter = typeWithSetters.contains((Object)prop.getType());
                    if (!hasSetter) continue;
                    PropertyCompletor.this.addCacheItem(SpringXMLConfigCompletionItem.createPropertyItem(PropertyCompletor.this.getAnchorOffset(), prop));
                }
            }
        }, false);
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.RESOURCE_PATH_ELEMENT_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }
}

