/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class FloatingPointExponent
extends AbstractDatatype {
    public static final FloatingPointExponent THE_INSTANCE = new FloatingPointExponent();

    private FloatingPointExponent() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        block18: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state) {
                case AT_START: {
                    if (c == '-') {
                        state = State.AT_START_MINUS_SEEN;
                        continue block18;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign or a digit but saw ", c, " instead.");
                }
                case AT_START_MINUS_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case IN_INTEGER_PART_DIGITS_SEEN: {
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block18;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block18;
                    }
                    if (this.isAsciiDigit(c)) continue block18;
                    throw this.newDatatypeException(i, "Expected a decimal point, \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case DOT_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_DECIMAL_PART_DIGITS_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected a digit after the decimal point but saw ", c, " instead.");
                }
                case IN_DECIMAL_PART_DIGITS_SEEN: {
                    if (this.isAsciiDigit(c)) continue block18;
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case E_SEEN: {
                    if (c == '-' || c == '+') {
                        state = State.IN_EXPONENT_SIGN_SEEN;
                        continue block18;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign, a plus sign or a digit but saw ", c, " instead.");
                }
                case IN_EXPONENT_SIGN_SEEN: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block18;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case IN_EXPONENT_DIGITS_SEEN: {
                    if (this.isAsciiDigit(c)) continue block18;
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
            }
        }
        switch (state) {
            case IN_INTEGER_PART_DIGITS_SEEN: 
            case IN_DECIMAL_PART_DIGITS_SEEN: 
            case IN_EXPONENT_DIGITS_SEEN: {
                return;
            }
            case AT_START: {
                throw this.newDatatypeException("The empty string is not a valid floating point number.");
            }
            case AT_START_MINUS_SEEN: {
                throw this.newDatatypeException("The minus sign alone is not a valid floating point number.");
            }
            case DOT_SEEN: {
                throw this.newDatatypeException("A floating point number must not end with the decimal point.");
            }
            case E_SEEN: {
                throw this.newDatatypeException("A floating point number must not end with the exponent \u201ce\u201d.");
            }
            case IN_EXPONENT_SIGN_SEEN: {
                throw this.newDatatypeException("A floating point number must not end with only a sign in the exponent.");
            }
        }
    }

    @Override
    public String getName() {
        return "floating point number";
    }

    private static enum State {
        AT_START,
        AT_START_MINUS_SEEN,
        IN_INTEGER_PART_DIGITS_SEEN,
        DOT_SEEN,
        E_SEEN,
        IN_DECIMAL_PART_DIGITS_SEEN,
        IN_EXPONENT_SIGN_SEEN,
        IN_EXPONENT_DIGITS_SEEN;

    }
}

