/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.IriRef;

public final class Refresh
extends IriRef {
    public static final Refresh THE_INSTANCE = new Refresh();

    private Refresh() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("Empty literal.");
        }
        State state = State.AT_START;
        block20: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state) {
                case AT_START: {
                    if (this.isAsciiDigit(c)) {
                        state = State.DIGIT_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit, but saw ", c, " instead.");
                }
                case DIGIT_SEEN: {
                    if (this.isAsciiDigit(c)) continue block20;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a digit or a semicolon, but saw ", c, " instead.");
                }
                case SEMICOLON_SEEN: {
                    if (this.isWhitespace(c)) {
                        state = State.SPACE_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a space character, but saw ", c, " instead.");
                }
                case SPACE_SEEN: {
                    if (this.isWhitespace(c)) continue block20;
                    if (c == 'u' || c == 'U') {
                        state = State.U_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected a space character or the letter \u201cu\u201d, but saw ", c, " instead.");
                }
                case U_SEEN: {
                    if (c == 'r' || c == 'R') {
                        state = State.R_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected the letter \u201cr\u201d, but saw ", c, " instead.");
                }
                case R_SEEN: {
                    if (c == 'l' || c == 'L') {
                        state = State.L_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected the letter \u201cl\u201d, but saw ", c, " instead.");
                }
                case L_SEEN: {
                    if (c == '=') {
                        state = State.EQUALS_SEEN;
                        continue block20;
                    }
                    throw this.newDatatypeException(i, "Expected \u201c=\u201d, but saw ", c, " instead.");
                }
                case EQUALS_SEEN: {
                    if (c == '\"' || c == '\'') {
                        throw this.newDatatypeException("Expected an unquoted IRI reference, but saw ", c, " instead.");
                    }
                    if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) {
                        throw this.newDatatypeException("Expected an IRI reference, but saw whitespace instead.");
                    }
                    char l = literal.charAt(literal.length() - 1);
                    if (' ' == l || '\t' == l || '\n' == l || '\f' == l || '\r' == l) {
                        throw this.newDatatypeException("Trailing whitespace.");
                    }
                    super.checkValid(literal.subSequence(i, literal.length()));
                    return;
                }
            }
        }
        switch (state) {
            case AT_START: {
                throw this.newDatatypeException("Expected a digit, but the literal ended.");
            }
            case DIGIT_SEEN: {
                return;
            }
            case SEMICOLON_SEEN: {
                throw this.newDatatypeException("Expected a space character, but the literal ended.");
            }
            case SPACE_SEEN: {
                throw this.newDatatypeException("Expected a space character or the letter \u201cu\u201d, but the literal ended.");
            }
            case U_SEEN: {
                throw this.newDatatypeException("Expected the letter \u201cr\u201d, but the literal ended.");
            }
            case R_SEEN: {
                throw this.newDatatypeException("Expected the letter \u201cl\u201d, but the literal ended.");
            }
            case L_SEEN: {
                throw this.newDatatypeException("Expected \u201c=\u201d, but the literal ended.");
            }
            case EQUALS_SEEN: {
                throw this.newDatatypeException("Expected an IRI reference, but the literal ended.");
            }
        }
    }

    @Override
    public String getName() {
        return "refresh";
    }

    private static enum State {
        AT_START,
        DIGIT_SEEN,
        SEMICOLON_SEEN,
        SPACE_SEEN,
        U_SEEN,
        R_SEEN,
        L_SEEN,
        EQUALS_SEEN;

    }
}

