/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.build.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.Parameters;

public final class AdvancedTasks {
    private static final int TASKS_NUMBER = 3;
    private static final String TASK_KEY = "%s.task.%d";
    private final Project project;
    private final String ident;

    AdvancedTasks(Project project, String ident) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notEmpty((CharSequence)"ident", (CharSequence)ident);
        this.project = project;
        this.ident = ident;
    }

    List<String> getTasks() {
        LinkedHashSet<String> tasks = new LinkedHashSet<String>();
        tasks.addAll(this.getTasks(this.getPreferences(true)));
        tasks.addAll(this.getTasks(this.getPreferences(false)));
        return new ArrayList<String>(tasks);
    }

    void addTask(boolean shared, String task) {
        Preferences preferences = this.getPreferences(shared);
        List<String> tasks = this.getTasks(preferences);
        tasks.add(0, task);
        tasks = new ArrayList<String>(new LinkedHashSet<String>(tasks));
        while (tasks.size() > 3) {
            tasks.remove(tasks.size() - 1);
        }
        for (int i = 0; i < tasks.size(); ++i) {
            preferences.put(String.format(TASK_KEY, this.ident, i + 1), tasks.get(i));
        }
    }

    private List<String> getTasks(Preferences preferences) {
        ArrayList<String> tasks = new ArrayList<String>(3);
        for (int i = 1; i <= 3; ++i) {
            String task = preferences.get(String.format(TASK_KEY, this.ident, i), null);
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private Preferences getPreferences(boolean shared) {
        return ProjectUtils.getPreferences((Project)this.project, AdvancedTasks.class, (boolean)shared);
    }
}

