/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.build.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.api.build.ui.AdvancedTaskPanel;
import org.netbeans.modules.web.clientproject.api.build.ui.AdvancedTasks;
import org.netbeans.modules.web.clientproject.api.build.ui.Bundle;
import org.netbeans.modules.web.clientproject.api.build.ui.VerticalGridLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class TasksMenu
extends JMenu {
    static final Logger LOGGER = Logger.getLogger(TasksMenu.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(TasksMenu.class);
    final BuildTools.TasksMenuSupport support;
    final AdvancedTasks advancedTasks;
    private boolean menuBuilt = false;

    public TasksMenu(BuildTools.TasksMenuSupport support) {
        super(support.getTitle(BuildTools.TasksMenuSupport.Title.MENU));
        this.support = support;
        this.advancedTasks = new AdvancedTasks(support.getProject(), support.getIdentifier());
    }

    boolean isMenuBuilt() {
        assert (EventQueue.isDispatchThread());
        return this.menuBuilt;
    }

    void setMenuBuilt(boolean menuBuilt) {
        assert (EventQueue.isDispatchThread());
        this.menuBuilt = menuBuilt;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        assert (EventQueue.isDispatchThread());
        if (!this.isMenuBuilt()) {
            this.setMenuBuilt(true);
            this.buildMenu();
        }
        return super.getPopupMenu();
    }

    private void buildMenu() {
        assert (EventQueue.isDispatchThread());
        final Future<List<String>> tasks = this.support.getTasks();
        if (tasks.isDone()) {
            try {
                this.addMenuItems(tasks.get());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            return;
        }
        this.addLoadingMenuItem();
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    TasksMenu.this.rebuildMenu((List)tasks.get(1L, TimeUnit.MINUTES));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    TasksMenu.this.errorOccured(Bundle.TasksMenu_error_execution(TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.MENU), ProjectUtils.getInformation((Project)TasksMenu.this.support.getProject()).getDisplayName()));
                    TasksMenu.this.rebuildMenu(null);
                }
                catch (TimeoutException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    TasksMenu.this.errorOccured(Bundle.TasksMenu_error_timeout(TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.MENU), ProjectUtils.getInformation((Project)TasksMenu.this.support.getProject()).getDisplayName()));
                    TasksMenu.this.rebuildMenu(null);
                }
            }
        });
    }

    void rebuildMenu(@NullAllowed List<String> tasks) {
        final CopyOnWriteArrayList<String> tasksRef = tasks == null ? null : new CopyOnWriteArrayList<String>(tasks);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TasksMenu.this.removeAll();
                TasksMenu.this.addMenuItems(tasksRef);
                TasksMenu.this.refreshMenu();
            }
        });
    }

    void errorOccured(String message) {
        if (this.isShowing()) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    void refreshMenu() {
        JPopupMenu popupMenu = this.getPopupMenu();
        popupMenu.pack();
        popupMenu.invalidate();
        popupMenu.revalidate();
        popupMenu.repaint();
    }

    void addMenuItems(@NullAllowed List<String> tasks) {
        assert (EventQueue.isDispatchThread());
        if (tasks == null) {
            this.addConfigureToolMenuItem();
            return;
        }
        VerticalGridLayout vgl = new VerticalGridLayout();
        this.getPopupMenu().setLayout(vgl);
        LinkedHashSet<String> allTasks = new LinkedHashSet<String>(tasks);
        String defaultTaskName = this.support.getDefaultTaskName();
        if (defaultTaskName != null) {
            allTasks.remove(defaultTaskName);
            this.addTaskMenuItem(true, defaultTaskName, false);
            this.addSeparator();
        }
        this.addAdvancedMenuItems(allTasks);
        this.addTasksMenuItems(allTasks);
        this.addReloadTasksMenuItem();
    }

    @CheckForNull
    private void addTasksMenuItems(Collection<String> tasks) {
        assert (EventQueue.isDispatchThread());
        assert (tasks != null);
        for (String task : tasks) {
            this.addTaskMenuItem(false, task, false);
        }
        if (!tasks.isEmpty()) {
            this.addSeparator();
        }
    }

    private void addAdvancedMenuItems(final Collection<String> tasks) {
        assert (EventQueue.isDispatchThread());
        assert (tasks != null);
        for (String task : this.advancedTasks.getTasks()) {
            this.addTaskMenuItem(false, task, true);
        }
        JMenuItem menuItem = new JMenuItem(Bundle.TasksMenu_menu_advanced());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (EventQueue.isDispatchThread());
                ArrayList<String> tasksWithDefaultTask = new ArrayList<String>(tasks.size() + 1);
                tasksWithDefaultTask.add("");
                tasksWithDefaultTask.addAll(tasks);
                final Pair<Boolean, String> advancedTask = AdvancedTaskPanel.open(TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.RUN_ADVANCED), TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.TASKS_LABEL), TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.BUILD_TOOL_EXEC), tasksWithDefaultTask);
                if (advancedTask != null) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            String task = (String)advancedTask.second();
                            TasksMenu.this.support.runTask(Utilities.parseParameters((String)task));
                            TasksMenu.this.advancedTasks.addTask((Boolean)advancedTask.first(), task);
                        }
                    });
                }
            }
        });
        this.add(menuItem);
        this.addSeparator();
    }

    private void addTaskMenuItem(final boolean isDefault, final String task, final boolean isAdvanced) {
        JMenuItem menuitem = new JMenuItem(task);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (isDefault) {
                            TasksMenu.this.support.runTask(new String[0]);
                        } else if (isAdvanced) {
                            TasksMenu.this.support.runTask(Utilities.parseParameters((String)task));
                        } else {
                            TasksMenu.this.support.runTask(task);
                        }
                    }
                });
            }
        });
        this.add(menuitem);
    }

    private void addLoadingMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.support.getTitle(BuildTools.TasksMenuSupport.Title.LOADING_TASKS));
        menuItem.setEnabled(false);
        this.add(menuItem);
    }

    private void addConfigureToolMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.support.getTitle(BuildTools.TasksMenuSupport.Title.CONFIGURE_TOOL));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksMenu.this.support.configure();
            }
        });
        this.add(menuItem);
    }

    private void addReloadTasksMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.support.getTitle(BuildTools.TasksMenuSupport.Title.RELOAD_TASKS));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (EventQueue.isDispatchThread());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        TasksMenu.this.support.reloadTasks();
                    }
                });
                TasksMenu.this.setMenuBuilt(false);
            }
        });
        this.add(menuItem);
    }
}

