/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.html;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.html.NameAndLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public final class HTMLIterator
extends BasicWizardIterator {
    private DataModel data;

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return HTMLIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new NameAndLocationPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles fileChanges = new CreatedModifiedFiles(model.getProject());
        Project project = model.getProject();
        NbModuleProvider moduleInfo = model.getModuleInfo();
        String name = model.getName();
        String packageName = model.getPackageName();
        String mode = model.getMode();
        try {
            SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.netbeans.api.htmlui");
        }
        catch (IOException ex) {
            Logger.getLogger(HTMLIterator.class.getName()).log(Level.INFO, null, ex);
        }
        if (name != null) {
            HashMap<String, String> replaceTokens = new HashMap<String, String>();
            replaceTokens.put("TEMPLATENAME", name);
            replaceTokens.put("PACKAGENAME", packageName);
            String icon = model.getIcon();
            File fil = null;
            if (icon != null && !(fil = new File(icon)).exists()) {
                fil = null;
            }
            String relativeIconPath = null;
            if (fil != null) {
                FileObject fo = FileUtil.toFileObject((File)fil);
                if (!FileUtil.isParentOf((FileObject)Util.getResourceDirectory((Project)project), (FileObject)fo)) {
                    String iconPath = HTMLIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", fo.getNameExt());
                    fileChanges.add(fileChanges.createFile(iconPath, fo));
                    relativeIconPath = packageName.replace('.', '/') + "/" + fo.getNameExt();
                } else {
                    relativeIconPath = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory((Project)project), (FileObject)fo);
                }
                replaceTokens.put("ICONPATH", relativeIconPath);
                replaceTokens.put("COMMENTICON", "");
            } else {
                replaceTokens.put("ICONPATH", "SET/PATH/TO/ICON/HERE");
                replaceTokens.put("COMMENTICON", "//");
            }
            replaceTokens.put("MODULENAME", moduleInfo.getCodeNameBase());
            String specVersion = moduleInfo.getSpecVersion();
            replaceTokens.put("SPECVERSION", specVersion != null ? specVersion : "0");
            fileChanges.add(fileChanges.addModuleDependency("org.netbeans.api.htmlui"));
            fileChanges.add(fileChanges.addModuleDependency("net.java.html"));
            fileChanges.add(fileChanges.addModuleDependency("net.java.html.json"));
            fileChanges.add(fileChanges.addModuleDependency("net.java.html.js"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.awt"));
            String tcName = HTMLIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "Cntrl.java");
            FileObject template = CreatedModifiedFiles.getTemplate("HTML.java");
            fileChanges.add(fileChanges.createFileWithSubstitutions(tcName, template, replaceTokens));
            String tcFormName = HTMLIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, ".html");
            template = CreatedModifiedFiles.getTemplate("HTML.html");
            fileChanges.add(fileChanges.createFileWithSubstitutions(tcFormName, template, replaceTokens));
        }
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String getRelativePath(String rootpath, String fullyQualifiedPackageName, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootpath).append('/').append(fullyQualifiedPackageName.replace('.', '/')).append('/').append(prefix).append(postfix);
        return sb.toString();
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String name;
        private String icon;
        private String mode;
        private boolean opened = false;
        private boolean keepPrefSize = false;
        private boolean slidingNotAllowed = false;
        private boolean closingNotAllowed = false;
        private boolean draggingNotAllowed = false;
        private boolean undockingNotAllowed = false;
        private boolean maximizationNotAllowed = false;
        private Map<String, String> newModes;
        private Set<String> existingModes;
        private boolean ignorePreviousRun = true;
        private CreatedModifiedFiles files;
        FileSystem sfs;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.setFiles(files);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getMode() {
            return this.mode;
        }

        public void defineMode(String name, String definition) {
            if (this.newModes == null) {
                this.newModes = new TreeMap<String, String>();
            }
            this.newModes.put(name, definition);
        }

        void existingMode(String name) {
            if (this.existingModes == null) {
                this.existingModes = new TreeSet<String>();
            }
            this.existingModes.add(name);
        }

        boolean isExistingMode(String name) {
            return this.existingModes != null && this.existingModes.contains(name);
        }

        Map<String, String> getNewModes() {
            if (this.newModes == null) {
                return null;
            }
            TreeMap<String, String> copy = new TreeMap<String, String>(this.newModes);
            if (this.existingModes != null) {
                copy.keySet().removeAll(this.existingModes);
            }
            return copy.isEmpty() ? null : copy;
        }

        public boolean isIgnorePreviousRun() {
            return this.ignorePreviousRun;
        }

        public void setIgnorePreviousRun(boolean ignorePreviousRun) {
            this.ignorePreviousRun = ignorePreviousRun;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public void setOpened(boolean opened) {
            this.opened = opened;
        }

        public boolean isKeepPrefSize() {
            return this.keepPrefSize;
        }

        public void setKeepPrefSize(boolean keepPrefSize) {
            this.keepPrefSize = keepPrefSize;
        }

        public boolean isClosingNotAllowed() {
            return this.closingNotAllowed;
        }

        public void setClosingNotAllowed(boolean closingNotAllowed) {
            this.closingNotAllowed = closingNotAllowed;
        }

        public boolean isDraggingNotAllowed() {
            return this.draggingNotAllowed;
        }

        public void setDraggingNotAllowed(boolean draggingNotAllowed) {
            this.draggingNotAllowed = draggingNotAllowed;
        }

        public boolean isMaximizationNotAllowed() {
            return this.maximizationNotAllowed;
        }

        public void setMaximizationNotAllowed(boolean maximizationNotAllowed) {
            this.maximizationNotAllowed = maximizationNotAllowed;
        }

        public boolean isSlidingNotAllowed() {
            return this.slidingNotAllowed;
        }

        public void setSlidingNotAllowed(boolean slidingNotAllowed) {
            this.slidingNotAllowed = slidingNotAllowed;
        }

        public boolean isUndockingNotAllowed() {
            return this.undockingNotAllowed;
        }

        public void setUndockingNotAllowed(boolean undockingNotAllowed) {
            this.undockingNotAllowed = undockingNotAllowed;
        }

        void setSFS(FileSystem sfs) {
            this.sfs = sfs;
        }
    }
}

