/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WatchesColumnModels {
    public static ColumnModel createDefaultLocalsColumn() {
        return new AbstractColumn("DefaultLocalsColumn", "CTL_LocalsView_Column_Name_Name", "CTL_LocalsView_Column_Name_Desc", null);
    }

    public static ColumnModel createDefaultWatchesColumn() {
        return new AbstractColumn("DefaultWatchesColumn", "CTL_WatchesView_Column_Name_Name", "CTL_WatchesView_Column_Name_Desc", null);
    }

    static class WatchesTableCellEditor
    implements TableCellEditor,
    FocusListener {
        private JEditorPane editorPane;
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private Object value;
        private Node node;

        WatchesTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            this.editorPane = new WatchesEditorPane("text/x-java", "");
            this.editorPane.addFocusListener(this);
            KeyStroke enterKs = KeyStroke.getKeyStroke(10, 0);
            KeyStroke escKs = KeyStroke.getKeyStroke(27, 0);
            InputMap im = this.editorPane.getInputMap();
            im.put(enterKs, "none");
            im.put(escKs, "none");
            WatchPanel.setupContext(this.editorPane, null);
            try {
                Field nodeField = value.getClass().getDeclaredField("node");
                nodeField.setAccessible(true);
                this.node = (Node)nodeField.get(value);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            if (this.node != null) {
                this.editorPane.setText(this.node.getDisplayName());
            }
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setBackground(table.getBackground());
            scrollPane.setViewportView(this.editorPane);
            return scrollPane;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorPane.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.fireEditingStopped();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireEditingStopped() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                ArrayList<CellEditorListener> list2 = new ArrayList<CellEditorListener>(this.listeners);
                for (CellEditorListener listener : list2) {
                    listener.editingStopped(new ChangeEvent(this));
                }
            }
        }

        class WatchesEditorPane
        extends JEditorPane {
            KeyStroke enter;

            WatchesEditorPane(String type, String text) {
                super(type, text);
                this.enter = KeyStroke.getKeyStroke(10, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (this.enter.equals(ks)) {
                    int id = e.getID();
                    block8: for (KeyListener keyListener : this.getKeyListeners()) {
                        switch (id) {
                            case 400: {
                                keyListener.keyTyped(e);
                                continue block8;
                            }
                            case 401: {
                                keyListener.keyPressed(e);
                                continue block8;
                            }
                            case 402: {
                                keyListener.keyReleased(e);
                            }
                        }
                    }
                    if (!e.isConsumed() && id == 401) {
                        List list = WatchesTableCellEditor.this.listeners;
                        synchronized (list) {
                            ArrayList list2 = new ArrayList(WatchesTableCellEditor.this.listeners);
                            for (CellEditorListener listener : list2) {
                                listener.editingStopped(new ChangeEvent(this));
                            }
                        }
                    }
                    e.consume();
                } else {
                    super.processKeyEvent(e);
                }
            }
        }
    }

    public static class AbstractColumn
    extends ColumnModel {
        private String id;
        private String displayName;
        private String shortDescription;
        private Class type;
        private boolean defaultVisible;
        private PropertyEditor propertyEditor;
        private boolean sortable;
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public AbstractColumn(String id, String displayName, String shortDescription, Class type) {
            this(id, displayName, shortDescription, type, true);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible) {
            this(id, displayName, shortDescription, type, defaultVisible, null);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible, PropertyEditor propertyEditor) {
            this(id, displayName, shortDescription, type, defaultVisible, propertyEditor, true);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible, PropertyEditor propertyEditor, boolean sortable) {
            this.id = id;
            this.displayName = displayName;
            this.shortDescription = shortDescription;
            this.type = type;
            this.defaultVisible = defaultVisible;
            this.propertyEditor = propertyEditor;
            this.sortable = sortable;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return NbBundle.getBundle(WatchesColumnModels.class).getString(this.displayName);
        }

        public String getShortDescription() {
            return NbBundle.getBundle(WatchesColumnModels.class).getString(this.shortDescription);
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean visible) {
            this.properties.setBoolean(this.getID() + ".visible", visible);
        }

        public void setSorted(boolean sorted) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sorted", sorted);
            }
        }

        public void setSortedDescending(boolean sortedDescending) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sortedDescending", sortedDescending);
            }
        }

        public int getCurrentOrderNumber() {
            int cn = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (cn >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++cn;
            }
            return cn;
        }

        public void setCurrentOrderNumber(int newOrderNumber) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", newOrderNumber);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int newColumnWidth) {
            this.properties.setInt(this.getID() + ".columnWidth", newColumnWidth);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean isSorted() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sorted", false);
            }
            return false;
        }

        public boolean isSortedDescending() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
            }
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        public TableCellEditor getTableCellEditor() {
            return new WatchesTableCellEditor();
        }
    }
}

