/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.ui.Bundle;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.Version;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NodeJsPathPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(NodeJsPathPanel.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(NodeJsPathPanel.class);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor.Task versionTask;
    volatile File nodeSources = null;
    private JButton downloadSourcesButton;
    private JButton nodeBrowseButton;
    private JLabel nodeHintLabel;
    private JLabel nodeInstallLabel;
    private JLabel nodeLabel;
    private JButton nodeSearchButton;
    private JTextField nodeTextField;
    private JButton selectSourcesButton;
    private JLabel sourcesLabel;
    private JTextField sourcesTextField;
    private JLabel versionInfoLabel;

    public NodeJsPathPanel() {
        this.initComponents();
        this.init();
        this.versionTask = RP.create(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NodeJsPathPanel.this.setVersion();
                    }
                });
            }
        });
    }

    private void init() {
        this.sourcesTextField.setText(" ");
        String[] nodes = NodeExecutable.NODE_NAMES;
        if (nodes.length > 1) {
            this.nodeHintLabel.setText(Bundle.NodeJsPathPanel_node_hint2(nodes[0], nodes[1]));
        } else {
            this.nodeHintLabel.setText(Bundle.NodeJsPathPanel_node_hint1(nodes[0]));
        }
        this.nodeTextField.getDocument().addDocumentListener(new NodeDocumentListener());
        this.sourcesTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public String getNode() {
        return this.nodeTextField.getText();
    }

    public void setNode(String node) {
        this.nodeTextField.setText(node);
    }

    @CheckForNull
    public String getNodeSources() {
        if (this.nodeSources != null) {
            return this.nodeSources.getAbsolutePath();
        }
        return null;
    }

    public void setNodeSources(String nodeSources) {
        if (StringUtilities.hasText((String)nodeSources)) {
            this.nodeSources = new File(nodeSources);
            this.setNodeSourcesDescription();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void enablePanel(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.nodeLabel.setEnabled(enabled);
        this.nodeTextField.setEnabled(enabled);
        this.nodeBrowseButton.setEnabled(enabled);
        this.nodeSearchButton.setEnabled(enabled);
        this.nodeHintLabel.setEnabled(enabled);
        this.nodeInstallLabel.setVisible(enabled);
        this.sourcesLabel.setEnabled(enabled);
        this.sourcesTextField.setEnabled(enabled);
        this.versionInfoLabel.setEnabled(enabled);
        this.selectSourcesButton.setEnabled(enabled);
        this.downloadSourcesButton.setEnabled(false);
        if (enabled) {
            if (this.nodeSources != null) {
                this.setNodeSourcesDescription();
            }
            this.setVersion();
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void detectVersion() {
        this.versionTask.schedule(100);
    }

    void setVersion() {
        assert (EventQueue.isDispatchThread());
        this.downloadSourcesButton.setEnabled(false);
        if (this.nodeSources == null) {
            this.setNodeSourcesDescription(Bundle.NodeJsPathPanel_version_detecting());
        }
        final String nodePath = this.getNode();
        RP.post(new Runnable(){

            @Override
            public void run() {
                Version nodeVersion;
                String version = null;
                NodeExecutable node = NodeExecutable.forPath(nodePath);
                if (node != null && (nodeVersion = node.getVersion()) != null) {
                    version = nodeVersion.toString();
                }
                final String versionRef = version;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (versionRef != null) {
                            NodeJsPathPanel.this.downloadSourcesButton.setEnabled(true);
                        }
                        if (NodeJsPathPanel.this.nodeSources == null) {
                            NodeJsPathPanel.this.setNodeSourcesDescription(versionRef);
                        }
                    }
                });
            }
        });
    }

    private void downloadSources() {
        assert (EventQueue.isDispatchThread());
        this.downloadSourcesButton.setEnabled(false);
        String nodePath = this.getNode();
        final NodeExecutable node = NodeExecutable.forPath(nodePath);
        assert (node != null) : nodePath;
        final Version version = node.getVersion();
        assert (version != null) : nodePath;
        if (NodeJsUtils.hasNodeSources(version)) {
            this.nodeSources = null;
            this.setNodeSourcesDescription(version.toString());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Bundle.NodeJsPathPanel_sources_exists(version.toString()), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.NO_OPTION) {
                this.downloadSourcesButton.setEnabled(true);
                return;
            }
        }
        this.sourcesTextField.setText(Bundle.NodeJsPathPanel_sources_downloading());
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (FileUtils.downloadNodeSources(version, node.isIojs())) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsPathPanel_download_success());
                    }
                    NodeJsPathPanel.this.nodeSources = null;
                }
                catch (NetworkException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    NodeJsPathPanel.this.informUser(Bundle.NodeJsPathPanel_download_failure(ex.getFailedRequests().get(0)));
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    NodeJsPathPanel.this.informUser(Bundle.NodeJsPathPanel_download_error());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NodeJsPathPanel.this.setNodeSourcesDescription(version.toString());
                        NodeJsPathPanel.this.downloadSourcesButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void informUser(String message) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
    }

    private void setNodeSourcesDescription() {
        assert (EventQueue.isDispatchThread());
        File nodeSourcesRef = this.nodeSources;
        assert (nodeSourcesRef != null);
        this.sourcesTextField.setText(nodeSourcesRef.getAbsolutePath());
    }

    private void setNodeSourcesDescription(@NullAllowed String version) {
        assert (EventQueue.isDispatchThread());
        String text = version == null ? Bundle.NodeJsPathPanel_sources_na() : (NodeJsUtils.hasNodeSources(version) ? Bundle.NodeJsPathPanel_sources_downloaded(version) : Bundle.NodeJsPathPanel_sources_not_downloaded(version));
        this.sourcesTextField.setText(text);
    }

    private void initComponents() {
        this.nodeLabel = new JLabel();
        this.nodeTextField = new JTextField();
        this.nodeBrowseButton = new JButton();
        this.nodeSearchButton = new JButton();
        this.nodeHintLabel = new JLabel();
        this.nodeInstallLabel = new JLabel();
        this.sourcesLabel = new JLabel();
        this.sourcesTextField = new JTextField();
        this.downloadSourcesButton = new JButton();
        this.selectSourcesButton = new JButton();
        this.versionInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nodeLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.nodeBrowseButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeBrowseButton.text"));
        this.nodeBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.nodeBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.nodeSearchButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeSearchButton.text"));
        this.nodeSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.nodeSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.nodeHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.nodeInstallLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeInstallLabel.text"));
        this.nodeInstallLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NodeJsPathPanel.this.nodeInstallLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NodeJsPathPanel.this.nodeInstallLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.sourcesLabel.text"));
        this.sourcesTextField.setEditable(false);
        this.sourcesTextField.setColumns(30);
        Mnemonics.setLocalizedText((AbstractButton)this.downloadSourcesButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.downloadSourcesButton.text"));
        this.downloadSourcesButton.setEnabled(false);
        this.downloadSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.downloadSourcesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.selectSourcesButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.selectSourcesButton.text"));
        this.selectSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.selectSourcesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.versionInfoLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.versionInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nodeLabel).addComponent(this.sourcesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.nodeHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.nodeInstallLabel, -2, -1, -2)).addComponent(this.versionInfoLabel).addGroup(layout.createSequentialGroup().addComponent(this.sourcesTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadSourcesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectSourcesButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeLabel).addComponent(this.nodeTextField, -2, -1, -2).addComponent(this.nodeBrowseButton).addComponent(this.nodeSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeHintLabel).addComponent(this.nodeInstallLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourcesLabel).addComponent(this.downloadSourcesButton).addComponent(this.selectSourcesButton).addComponent(this.sourcesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionInfoLabel)));
    }

    private void nodeBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(NodeJsPathPanel.class).setFilesOnly(true).setTitle(Bundle.NodeJsPathPanel_node_browse_title()).showOpenDialog();
        if (file != null) {
            this.nodeTextField.setText(file.getAbsolutePath());
        }
    }

    private void nodeSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> i$ = FileUtils.findFileOnUsersPath(NodeExecutable.NODE_NAMES).iterator();
        if (i$.hasNext()) {
            String node = i$.next();
            this.nodeTextField.setText(new File(node).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsPathPanel_node_none());
    }

    private void downloadSourcesButtonActionPerformed(ActionEvent evt) {
        this.downloadSources();
    }

    private void nodeInstallLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void nodeInstallLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://nodejs.org/"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void selectSourcesButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File sources = new FileChooserBuilder(NodeJsPathPanel.class).setDirectoriesOnly(true).setTitle(Bundle.NodeJsPathPanel_sources_browse_title()).showOpenDialog();
        if (sources != null) {
            this.nodeSources = sources;
            this.setNodeSourcesDescription();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NodeJsPathPanel.this.fireChange();
        }
    }

    private final class NodeDocumentListener
    implements DocumentListener {
        private NodeDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NodeJsPathPanel.this.fireChange();
            NodeExecutable node = NodeExecutable.forPath(NodeJsPathPanel.this.getNode());
            if (node != null) {
                node.resetVersion();
            }
            NodeJsPathPanel.this.detectVersion();
        }
    }
}

