/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.NativeTrace;
import org.llvm.adt.DenseMapInfo;

public class DenseMapInfoObject<T>
implements DenseMapInfo<T> {
    private final T emptyKey;
    private final T tombstoneKey;

    public DenseMapInfoObject(T emptykey, T tombstoneKey) {
        assert (tombstoneKey != null) : "tombstoneKey marker must be non null";
        assert (emptykey != null) : "emptyKey marker must be non null";
        assert (emptykey != tombstoneKey) : "emptyKey must be different from tombstoneKey";
        this.emptyKey = emptykey;
        this.tombstoneKey = tombstoneKey;
        if (NativeTrace.isDebugMode()) {
            String clsName = this.emptyKey.getClass().getName();
            if ("org.clang.basic.IdentifierInfo".equals(clsName)) {
                new Exception("use IdentifierInfo.DenseMapInfo instead").printStackTrace(System.err);
            } else if (clsName.endsWith("ContentCache")) {
                new Exception("use " + clsName + ".DenseMapInfo instead").printStackTrace(System.err);
            } else if ("org.clang.basic.FileEntry".equals(clsName)) {
                new Exception("use FileEntry.DenseMapInfo instead").printStackTrace(System.err);
            }
        }
    }

    @Override
    public T getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public T getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public long getHashValue(Object Val) {
        assert (Val != this.emptyKey) : "must not be called for emptyKey";
        assert (Val != this.tombstoneKey) : "must not be called for tombstoneKey";
        return System.identityHashCode(Val);
    }

    @Override
    public boolean isEqual(Object LHS, Object RHS) {
        assert (LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        return LHS == RHS;
    }

    @Override
    public boolean isKeyPointerLike() {
        return true;
    }
}

