/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.aliases.DenseMapInfoInt;
import org.llvm.adt.aliases.DenseMapIteratorIntType;

public abstract class DenseMapBaseIntType<DerivedT, ValueT>
implements NativeType.SizeofCapable {
    protected final ValueT defaultValue;
    protected final DenseMapInfoInt keyInfoT;
    protected final int emptyKey;
    protected final int tombstoneKey;
    static final int INVALID_INDEX = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_MASK = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_FLAG = Integer.MIN_VALUE;

    protected DenseMapBaseIntType(DenseMapInfoInt keyInfo, ValueT defaultValue) {
        this.keyInfoT = keyInfo;
        this.defaultValue = defaultValue;
        this.emptyKey = this.keyInfoT.getEmptyKey();
        this.tombstoneKey = keyInfo.getTombstoneKey();
        assert (this.keyInfoT.getEmptyKey() == this.emptyKey) : "empty key must be persistent between calls" + this.keyInfoT;
        assert (this.keyInfoT.getTombstoneKey() == this.tombstoneKey) : "tombstone key must be persistent between calls" + this.keyInfoT;
        assert (this.emptyKey != this.tombstoneKey) : "EmptyKey must be different from TombstoneKey:" + keyInfo;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        if (ADTAliases.CHECK_DENSE_MAP_INFO) assert (keyInfo.getHashValue(keyInfo.getEmptyKey()) != keyInfo.getHashValue(keyInfo.getTombstoneKey())) : "EmptyKey must have different hashCode to TombstoneKey:" + keyInfo;
    }

    public DenseMapIteratorIntType<ValueT> begin() {
        return this.empty() ? this.end() : new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), 0, this.getNumBuckets());
    }

    public DenseMapIteratorIntType<ValueT> end() {
        return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), this.getNumBuckets(), this.getNumBuckets(), true);
    }

    public boolean empty() {
        return this.getNumEntries() == 0;
    }

    public int size() {
        return this.getNumEntries();
    }

    public void resize(long Size) {
        if (Size >= (long)this.getNumBuckets()) {
            this.grow(Size);
        }
    }

    public void clear() {
        if (this.getNumEntries() == 0 && this.getNumTombstones() == 0) {
            return;
        }
        if (this.getNumEntries() * 4 < this.getNumBuckets() && this.getNumBuckets() > 64) {
            this.shrink_and_clear();
            return;
        }
        int EmptyKey = this.getEmptyKey();
        int TombstoneKey = this.getTombstoneKey();
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int P = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P, (int)E)) {
            if (Buckets[P].first != EmptyKey) {
                if (Buckets[P].first != TombstoneKey) {
                    if (!this.isDataPointerLike()) {
                        Native.destroy((Object)Buckets[P].second);
                    }
                    this.decrementNumEntries();
                }
                Buckets[P].first = EmptyKey;
            }
            ++P;
        }
        this.setNumTombstones(0);
    }

    public boolean count(int Val) {
        return this.LookupBucketFor(Val, true) != Integer.MAX_VALUE;
    }

    public DenseMapIteratorIntType<ValueT> find(int Val) {
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public <Lookupint> DenseMapIteratorIntType<ValueT> find_as(Lookupint Val) {
        int TheBucket = this.LookupBucketForAltKey(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public ValueT lookup(int Val) {
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return (ValueT)this.$Buckets()[TheBucket].second;
        }
        return (ValueT)Native.$tryClone(this.defaultValue);
    }

    public std.pairTypeBool<DenseMapIteratorIntType<ValueT>> insert(std.pairIntType<ValueT> KV) {
        int TheBucket = this.LookupBucketFor(KV.first, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(KV.first, KV.second, TheBucket & Integer.MAX_VALUE);
            return std.make_pair(new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair(new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public void insert(type.iterator<?, std.pairIntType<ValueT>> I, type.iterator<?, std.pairIntType<ValueT>> E) {
        while (Native.$noteq(I, E)) {
            this.insert((std.pairIntType)I.$star());
            I.$preInc();
        }
    }

    public boolean erase(int Val) {
        int TheBucketIdx = this.LookupBucketFor(Val, true);
        if (TheBucketIdx == Integer.MAX_VALUE) {
            return false;
        }
        std.pairIntType<ValueT> TheBucket = this.$Buckets()[TheBucketIdx];
        if (!this.isDataPointerLike()) {
            Native.destroy((Object)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
        return true;
    }

    public void erase(DenseMapIteratorIntType<ValueT> I) {
        type.ptr<std.pairIntType<ValueT>> TheBucket = I.$arrow();
        if (!this.isDataPointerLike()) {
            Native.destroy((Object)((std.pairIntType)TheBucket.$star()).second);
        }
        ((std.pairIntType)TheBucket.$star()).first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
    }

    public std.pairIntType<ValueT> FindAndConstruct(int Key) {
        int TheBucket = this.LookupBucketFor(Key, false);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(Key, this.isDataPointerLike() ? null : Native.$tryClone(this.defaultValue), TheBucket & Integer.MAX_VALUE);
        }
        return this.$Buckets()[TheBucket];
    }

    public ValueT $at(int Key) {
        return (ValueT)this.FindAndConstruct((int)Key).second;
    }

    public type.ref<ValueT> ref$at(final int Key) {
        return new type.ref<ValueT>(){
            final std.pairIntType<ValueT> pair;
            {
                this.pair = DenseMapBaseIntType.this.FindAndConstruct(Key);
            }

            public ValueT $deref() {
                assert (Native.$eq((int)Key, (int)this.pair.first));
                return this.pair.second;
            }

            public ValueT $set(ValueT value) {
                assert (Native.$eq((int)Key, (int)this.pair.first));
                this.pair.second = DenseMapBaseIntType.this.isDataPointerLike() ? value : Native.$tryClone(value);
                return value;
            }

            public type.ptr<ValueT> deref$ptr() {
                throw new UnsupportedOperationException("Not supported.");
            }

            public String toString() {
                return "$(" + Key + ")\n => [" + this.pair.second + "]";
            }
        };
    }

    public boolean isPointerIntoBucketsArray(void.ptr Ptr) {
        if (Ptr != null && this.getBuckets() != null && this.getBucketsEnd() != null) {
            return Ptr.$greatereq(this.getBuckets()) && Ptr.$less(this.getBucketsEnd());
        }
        return false;
    }

    public void.ptr getPointerIntoBucketsArray() {
        return this.getBuckets();
    }

    protected void destroyAll() {
        if (this.getNumBuckets() == 0) {
            return;
        }
        int EmptyKey = this.getEmptyKey();
        int TombstoneKey = this.getTombstoneKey();
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int P = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P, (int)E)) {
            if (Buckets[P].first != EmptyKey && Buckets[P].first != TombstoneKey) {
                if (!this.isDataPointerLike()) {
                    Native.destroy((Object)Buckets[P].second);
                }
                if (!this.isKeyPointerLike()) {
                    Native.destroy((int)Buckets[P].first);
                }
            }
            ++P;
        }
    }

    protected void initEmpty() {
        this.setNumEntries(0);
        this.setNumTombstones(0);
        int EmptyKey = this.getEmptyKey();
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int E = this.getNumBuckets();
        for (int B = 0; B != E; ++B) {
            Buckets[B].first = EmptyKey;
        }
    }

    protected void moveFromOldBuckets(std.pairIntType<ValueT>[] OldBucketsBegin, int Num) {
        this.initEmpty();
        int EmptyKey = this.getEmptyKey();
        int TombstoneKey = this.getTombstoneKey();
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int E = Num;
        for (int B = 0; B != Num; ++B) {
            std.pairIntType<ValueT> oldPair = OldBucketsBegin[B];
            int OldKey = oldPair.first;
            if (OldKey == EmptyKey || OldKey == TombstoneKey) continue;
            int DestBucketIdx = this.LookupBucketFor(OldKey, false);
            assert (DestBucketIdx != Integer.MAX_VALUE) : "Key already in new map?";
            assert (DestBucketIdx < 0) : "Key " + System.identityHashCode(OldKey) + " already in new map?" + System.identityHashCode(Buckets[DestBucketIdx]) + ":\nWhen Inserting Key=" + OldKey + "\nFound In Map=" + Buckets[DestBucketIdx];
            assert ((DestBucketIdx &= Integer.MAX_VALUE) >= 0);
            assert (DestBucketIdx != Integer.MAX_VALUE);
            std.pairIntType<ValueT> DestBucket = Buckets[DestBucketIdx];
            DestBucket.first = OldKey;
            DestBucket.second = oldPair.second;
            this.incrementNumEntries();
        }
    }

    protected <OtherBaseT> void copyFrom(DenseMapBaseIntType<OtherBaseT, ValueT> other) {
        this.setNumEntries(other.getNumEntries());
        this.setNumTombstones(other.getNumTombstones());
        std.pairIntType<ValueT>[] ourBuckets = this.$Buckets();
        std.pairIntType<ValueT>[] otherBuckets = other.$Buckets();
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            ourBuckets[i].first = otherBuckets[i].first;
            if (ourBuckets[i].first == this.getEmptyKey() || ourBuckets[i].first == this.getTombstoneKey()) continue;
            if (!this.isKeyPointerLike()) {
                ourBuckets[i].first = Native.$tryClone((int)otherBuckets[i].first);
            }
            ourBuckets[i].second = this.isDataPointerLike() ? otherBuckets[i].second : Native.$tryClone((Object)otherBuckets[i].second);
        }
    }

    protected void swap(DenseMapBaseIntType<DerivedT, ValueT> RHS) {
        int tmp = RHS.getNumEntries();
        RHS.setNumEntries(this.getNumEntries());
        this.setNumEntries(tmp);
        tmp = RHS.getNumTombstones();
        RHS.setNumTombstones(this.getNumTombstones());
        this.setNumTombstones(tmp);
    }

    protected long getHashValue(int Val) {
        return this.keyInfoT.getHashValue(Val);
    }

    protected <Lookupint> long getHashValueAlt(Lookupint Val) {
        return this.keyInfoT.getHashValue(Val);
    }

    protected final int getEmptyKey() {
        return this.emptyKey;
    }

    protected final int getTombstoneKey() {
        return this.tombstoneKey;
    }

    protected abstract int getNumEntries();

    protected abstract void setNumEntries(int var1);

    private void incrementNumEntries() {
        this.setNumEntries(this.getNumEntries() + 1);
    }

    private void decrementNumEntries() {
        this.setNumEntries(this.getNumEntries() - 1);
    }

    protected abstract int getNumTombstones();

    protected abstract void setNumTombstones(int var1);

    private void incrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() + 1);
    }

    private void decrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() - 1);
    }

    protected abstract type.ptr<std.pairIntType<ValueT>> getBuckets();

    protected abstract std.pairIntType<ValueT>[] $Buckets();

    protected abstract int getNumBuckets();

    private type.ptr<std.pairIntType<ValueT>> getBucketsEnd() {
        return NativePointer.create_type$ptr((Object[])this.$Buckets(), (long)this.getNumBuckets());
    }

    protected abstract void grow(long var1);

    protected abstract void shrink_and_clear();

    private int InsertIntoBucket(int Key, ValueT Value, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketImpl(Key, TheBucketIndex);
        std.pairIntType<ValueT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private int InsertIntoBucketImpl(int Key, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((long)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (long)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        int EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private int LookupBucketFor(int Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        int EmptyKey = this.getEmptyKey();
        int TombstoneKey = this.getTombstoneKey();
        assert (Key != EmptyKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        assert (Key != TombstoneKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        int BucketNo = (int)(this.getHashValue(Key) & (long)(NumBuckets - 1));
        int ProbeAmt = 1;
        while (true) {
            std.pairIntType<ValueT> ThisBucket = Buckets[BucketNo];
            if (this.keyInfoT.isEqual(Key, ThisBucket.first)) {
                return BucketNo;
            }
            if (ThisBucket.first == EmptyKey) {
                int Bucket;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket >= 0 && Bucket != Integer.MAX_VALUE);
                return Bucket | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey && FoundTombstone == Integer.MAX_VALUE) {
                FoundTombstone = BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    private <Lookupint> int LookupBucketForAltKey(Lookupint Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std.pairIntType<ValueT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        int EmptyKey = this.getEmptyKey();
        int TombstoneKey = this.getTombstoneKey();
        int BucketNo = (int)(this.getHashValueAlt(Key) & (long)(NumBuckets - 1));
        int ProbeAmt = 1;
        while (true) {
            std.pairIntType<ValueT> ThisBucket = Buckets[BucketNo];
            if (this.keyInfoT.isEqual(Key, (Object)ThisBucket.first)) {
                return BucketNo;
            }
            if (ThisBucket.first != EmptyKey) {
                int Bucket;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket >= 0 && Bucket != Integer.MAX_VALUE);
                return Bucket | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey && FoundTombstone == Integer.MAX_VALUE) {
                FoundTombstone = BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    public long getMemorySize() {
        return this.getNumBuckets() * NativeType.sizeof(type.ptr.class);
    }

    public long $sizeof() {
        return this.getMemorySize();
    }

    protected final boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    protected final boolean isKeyPointerLike() {
        return this.keyInfoT.isKeyPointerLike();
    }
}

