/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.MutexGuard;
import org.llvm.support.impl.ErrorHandlingStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_svector_ostream;
import org.llvm.support.sys.sys;

public final class ErrorHandlingLlvmGlobals {
    public static void install_fatal_error_handler(ADTFunctionPointers.fatal_error_handler_t handler) {
        ErrorHandlingLlvmGlobals.install_fatal_error_handler(handler, null);
    }

    public static void install_fatal_error_handler(ADTFunctionPointers.fatal_error_handler_t handler, Object user_data) {
        MutexGuard Lock = null;
        try {
            Lock = new MutexGuard(ErrorHandlingStatics.ErrorHandlerMutex.$star());
            assert (ErrorHandlingStatics.ErrorHandler == null) : "Error handler already registered!\n";
            ErrorHandlingStatics.ErrorHandler = (ADTFunctionPointers.fatal_error_handler_t)Native.$tryClone((Object)handler);
            ErrorHandlingStatics.ErrorHandlerUserData = Native.$tryClone((Object)user_data);
        }
        finally {
            if (Lock != null) {
                Lock.$destroy();
            }
        }
    }

    public static void remove_fatal_error_handler() {
        MutexGuard Lock = null;
        try {
            Lock = new MutexGuard(ErrorHandlingStatics.ErrorHandlerMutex.$star());
            ErrorHandlingStatics.ErrorHandler = null;
            ErrorHandlingStatics.ErrorHandlerUserData = null;
        }
        finally {
            if (Lock != null) {
                Lock.$destroy();
            }
        }
    }

    public static void report_fatal_error(char.ptr Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, true);
    }

    public static void report_fatal_error(char.ptr Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(new Twine(Reason), GenCrashDiag);
    }

    public static void report_fatal_error(std.string Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, true);
    }

    public static void report_fatal_error(std.string Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(new Twine(Reason), GenCrashDiag);
    }

    public static void report_fatal_error(StringRef Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, true);
    }

    public static void report_fatal_error(StringRef Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(new Twine(Reason), GenCrashDiag);
    }

    public static void report_fatal_error(Twine Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report_fatal_error(Twine Reason, boolean GenCrashDiag) {
        ADTFunctionPointers.fatal_error_handler_t handler = null;
        Object handlerData = null;
        MutexGuard Lock = null;
        try {
            Lock = new MutexGuard(ErrorHandlingStatics.ErrorHandlerMutex.$star());
            handler = (ADTFunctionPointers.fatal_error_handler_t)Native.$tryClone((Object)ErrorHandlingStatics.ErrorHandler);
            handlerData = Native.$tryClone((Object)ErrorHandlingStatics.ErrorHandlerUserData);
        }
        finally {
            if (Lock != null) {
                Lock.$destroy();
            }
        }
        if (handler != null) {
            handler.$call(handlerData, Reason.str(), GenCrashDiag);
        } else {
            SmallString Buffer = null;
            raw_svector_ostream OS = null;
            try {
                Buffer = new SmallString(64);
                OS = new raw_svector_ostream(Buffer);
                llvm.$out_raw_ostream_Twine(OS.$out(NativePointer.$((String)"LLVM ERROR: ")), Reason).$out(NativePointer.$((String)"\n"));
                StringRef MessageStr = OS.str();
                long l = std.write((int)2, (char.ptr)MessageStr.data(), (long)MessageStr.size());
            }
            finally {
                if (OS != null) {
                    OS.$destroy();
                }
                if (Buffer != null) {
                    Buffer.$destroy();
                }
            }
        }
        sys.RunInterruptHandlers();
        std.exit((int)1);
    }

    public static void llvm_unreachable_internal() {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(null, null, 0L);
    }

    public static void llvm_unreachable_internal(char.ptr msg) {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(msg, null, 0L);
    }

    public static void llvm_unreachable_internal(char.ptr msg, char.ptr file) {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(msg, file, 0L);
    }

    public static void llvm_unreachable_internal(char.ptr msg, char.ptr file, long line) {
        throw new UnsupportedOperationException("EmptyBody");
    }
}

