/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.php.editor.actions.FixUsesAction;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.UnusedUsesCollector;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;

public class FixUsesPerformer {
    private static final String NEW_LINE = "\n";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String USE_KEYWORD = "use";
    private static final String USE_PREFIX = "\nuse ";
    private static final String USE_CONST_PREFIX = "\nuse const ";
    private static final String USE_FUNCTION_PREFIX = "\nuse function ";
    private static final String AS_KEYWORD = "as";
    private static final String AS_CONCAT = " as ";
    private static final String EMPTY_STRING = "";
    private static final String COLON = ",";
    private final PHPParseResult parserResult;
    private final ImportData importData;
    private final List<ImportData.ItemVariant> selections;
    private final boolean removeUnusedUses;
    private final FixUsesAction.Options options;
    private EditList editList;
    private BaseDocument baseDocument;

    public FixUsesPerformer(PHPParseResult parserResult, ImportData importData, List<ImportData.ItemVariant> selections, boolean removeUnusedUses, FixUsesAction.Options options) {
        this.parserResult = parserResult;
        this.importData = importData;
        this.selections = selections;
        this.removeUnusedUses = removeUnusedUses;
        this.options = options;
    }

    public void perform() {
        Document document = this.parserResult.getSnapshot().getSource().getDocument(false);
        if (document instanceof BaseDocument) {
            this.baseDocument = (BaseDocument)document;
            this.editList = new EditList(this.baseDocument);
            this.processExistingUses();
            this.processSelections();
            this.editList.apply();
        }
    }

    private void processSelections() {
        this.resolveDuplicateSelections();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult.getModel().getFileScope(), this.importData.caretPosition);
        assert (namespaceScope != null);
        int startOffset = FixUsesPerformer.getOffset(this.baseDocument, namespaceScope);
        ArrayList<UsePart> useParts = new ArrayList<UsePart>();
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
        for (UseScope useScope : declaredUses) {
            this.processUseElement(useScope, useParts);
        }
        for (int i = 0; i < this.selections.size(); ++i) {
            ImportData.ItemVariant itemVariant = this.selections.get(i);
            if (!itemVariant.canBeUsed()) continue;
            SanitizedUse sanitizedUse = new SanitizedUse(new UsePart(this.modifyUseName(itemVariant.getName()), UsePart.Type.create(itemVariant.getType()), itemVariant.isFromAliasedElement()), useParts, this.createAliasStrategy(i, useParts, this.selections));
            if (sanitizedUse.shouldBeUsed()) {
                useParts.add(sanitizedUse.getSanitizedUsePart());
            }
            for (UsedNamespaceName usedNamespaceName : this.importData.getItems().get(i).getUsedNamespaceNames()) {
                this.editList.replace(usedNamespaceName.getOffset(), usedNamespaceName.getReplaceLength(), sanitizedUse.getReplaceName(usedNamespaceName), false, 0);
            }
        }
        this.replaceUnimportedItems();
        this.editList.replace(startOffset, 0, this.createInsertString(useParts), false, 0);
    }

    private void replaceUnimportedItems() {
        for (ImportData.DataItem dataItem : this.importData.getItemsToReplace()) {
            ImportData.ItemVariant defaultVariant = dataItem.getDefaultVariant();
            for (UsedNamespaceName usedNamespaceName : dataItem.getUsedNamespaceNames()) {
                this.editList.replace(usedNamespaceName.getOffset(), usedNamespaceName.getReplaceLength(), defaultVariant.getName(), false, 0);
            }
        }
    }

    private void resolveDuplicateSelections() {
        List<ImportData.DataItem> dataItems = this.importData.getItems();
        ArrayList<ImportData.ItemVariant> selectionsCopy = new ArrayList<ImportData.ItemVariant>(this.selections);
        ArrayList<Integer> itemIndexesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.selections.size(); ++i) {
            ArrayList<UsedNamespaceName> usedNamespaceNames = new ArrayList<UsedNamespaceName>();
            ImportData.ItemVariant baseVariant = this.selections.get(i);
            if (!baseVariant.canBeUsed()) continue;
            for (int j = i + 1; j < selectionsCopy.size(); ++j) {
                ImportData.ItemVariant testedVariant = (ImportData.ItemVariant)selectionsCopy.get(j);
                if (!baseVariant.equals(testedVariant) || itemIndexesToRemove.contains(j)) continue;
                ImportData.DataItem duplicateItem = dataItems.get(j);
                usedNamespaceNames.addAll(duplicateItem.getUsedNamespaceNames());
                itemIndexesToRemove.add(j);
            }
            if (usedNamespaceNames.isEmpty()) continue;
            dataItems.get(i).addUsedNamespaceNames(usedNamespaceNames);
        }
        Collections.sort(itemIndexesToRemove);
        Collections.reverse(itemIndexesToRemove);
        for (Integer itemIndexToRemove : itemIndexesToRemove) {
            this.selections.remove(itemIndexToRemove);
        }
    }

    private AliasStrategy createAliasStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
        AliasStrategyImpl createAliasStrategy = this.options.aliasesCapitalsOfNamespaces() ? new CapitalsStrategy(selectionIndex, existingUseParts, selections) : new UnqualifiedNameStrategy(selectionIndex, existingUseParts, selections);
        return createAliasStrategy;
    }

    private void processUseElement(UseScope useElement, List<UsePart> useParts) {
        if (this.isUsed(useElement) || !this.removeUnusedUses) {
            AliasedName aliasedName = useElement.getAliasedName();
            if (aliasedName != null) {
                useParts.add(new UsePart(this.modifyUseName(aliasedName.getRealName().toString()) + AS_CONCAT + aliasedName.getAliasName(), UsePart.Type.create(useElement.getType())));
            } else {
                useParts.add(new UsePart(this.modifyUseName(useElement.getName()), UsePart.Type.create(useElement.getType())));
            }
        }
    }

    private String modifyUseName(String useName) {
        String result = useName;
        result = this.options.startUseWithNamespaceSeparator() ? (result.startsWith("\\") ? result : "\\" + result) : (result.startsWith("\\") ? result.substring("\\".length()) : result);
        return result;
    }

    private boolean isUsed(UseScope useElement) {
        boolean result = true;
        for (UnusedUsesCollector.UnusedOffsetRanges unusedRange : new UnusedUsesCollector(this.parserResult).collect()) {
            if (!unusedRange.getRangeToVisualise().containsInclusive(useElement.getOffset())) continue;
            result = false;
            break;
        }
        return result;
    }

    private String createInsertString(List<UsePart> useParts) {
        StringBuilder insertString = new StringBuilder();
        Collections.sort(useParts);
        if (useParts.size() > 0) {
            insertString.append(NEW_LINE);
        }
        if (this.options.preferMultipleUseStatementsCombined()) {
            insertString.append(this.createStringForMultipleUse(useParts));
        } else {
            insertString.append(this.createStringForCommonUse(useParts));
        }
        return insertString.toString();
    }

    private String createStringForMultipleUse(List<UsePart> useParts) {
        StringBuilder insertString = new StringBuilder();
        CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
        String indentString = IndentUtils.createIndentString((int)codeStyle.getIndentSize(), (boolean)codeStyle.expandTabToSpaces(), (int)codeStyle.getTabSize());
        UsePart.Type lastUsePartType = null;
        for (UsePart usePart : useParts) {
            if (lastUsePartType != null) {
                if (lastUsePartType == usePart.getType()) {
                    insertString.append(COLON).append(NEW_LINE).append(indentString);
                } else {
                    insertString.append(SEMICOLON);
                }
            }
            if (lastUsePartType != usePart.getType()) {
                lastUsePartType = usePart.getType();
                switch (usePart.getType()) {
                    case TYPE: {
                        insertString.append(USE_PREFIX);
                        break;
                    }
                    case CONST: {
                        insertString.append(USE_CONST_PREFIX);
                        break;
                    }
                    case FUNCTION: {
                        insertString.append(USE_FUNCTION_PREFIX);
                        break;
                    }
                    default: {
                        insertString.append(USE_PREFIX);
                    }
                }
            }
            insertString.append(usePart.getTextPart());
        }
        if (!useParts.isEmpty()) {
            insertString.append(SEMICOLON);
        }
        return insertString.toString();
    }

    private String createStringForCommonUse(List<UsePart> useParts) {
        StringBuilder result = new StringBuilder();
        for (UsePart usePart : useParts) {
            result.append(usePart.getUsePrefix()).append(usePart.getTextPart()).append(SEMICOLON);
        }
        return result.toString();
    }

    private void processExistingUses() {
        ExistingUseStatementVisitor visitor = new ExistingUseStatementVisitor();
        Program program = this.parserResult.getProgram();
        if (program != null) {
            program.accept(visitor);
        }
        for (OffsetRange offsetRange : visitor.getUsedRanges()) {
            int startOffset = this.getOffsetWithoutLeadingWhitespaces(offsetRange.getStart());
            this.editList.replace(startOffset, offsetRange.getEnd() - startOffset, EMPTY_STRING, false, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOffsetWithoutLeadingWhitespaces(int startOffset) {
        int result = startOffset;
        this.baseDocument.readLock();
        try {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.baseDocument, startOffset);
            if (ts != null) {
                ts.move(startOffset);
                while (ts.movePrevious() && ((PHPTokenId)ts.token().id()).equals((Object)PHPTokenId.WHITESPACE)) {
                    result = ts.offset();
                }
            }
        }
        finally {
            this.baseDocument.readUnlock();
        }
        return result;
    }

    private static int getOffset(BaseDocument baseDocument, NamespaceScope namespaceScope) {
        try {
            return Utilities.getRowEnd((BaseDocument)baseDocument, (int)FixUsesPerformer.getReferenceElement(namespaceScope).getOffset());
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    private static ModelElement getReferenceElement(NamespaceScope namespaceScope) {
        Scope offsetElement = null;
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
        for (UseScope useScope : declaredUses) {
            if (offsetElement != null && offsetElement.getOffset() >= useScope.getOffset()) continue;
            offsetElement = useScope;
        }
        return offsetElement != null ? offsetElement : namespaceScope;
    }

    private static class UsePart
    implements Comparable<UsePart> {
        private final String textPart;
        private final Type type;
        private final boolean isFromAliasedElement;

        private UsePart(String textPart, Type type, boolean isFromAliasedElement) {
            this.textPart = textPart;
            this.type = type;
            this.isFromAliasedElement = isFromAliasedElement;
        }

        private UsePart(String textPart, Type type) {
            this(textPart, type, false);
        }

        public String getTextPart() {
            return this.textPart;
        }

        public Type getType() {
            return this.type;
        }

        public String getUsePrefix() {
            return this.type.getUsePrefix();
        }

        public boolean isFromAliasedElement() {
            return this.isFromAliasedElement;
        }

        @Override
        public int compareTo(UsePart other) {
            int result = 0;
            if (Type.TYPE.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 0;
            } else if (Type.TYPE.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.TYPE.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = 0;
            } else if (Type.CONST.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = -1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.TYPE.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.CONST.equals((Object)other.getType())) {
                result = 1;
            } else if (Type.FUNCTION.equals((Object)this.getType()) && Type.FUNCTION.equals((Object)other.getType())) {
                result = 0;
            }
            return result == 0 ? this.getTextPart().compareToIgnoreCase(other.getTextPart()) : result;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.textPart);
            hash = 71 * hash + Objects.hashCode((Object)this.type);
            hash = 71 * hash + (this.isFromAliasedElement ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsePart other = (UsePart)obj;
            if (!Objects.equals(this.textPart, other.textPart)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.isFromAliasedElement == other.isFromAliasedElement;
        }

        static enum Type {
            TYPE{

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_PREFIX;
                }
            }
            ,
            CONST{

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_CONST_PREFIX;
                }
            }
            ,
            FUNCTION{

                @Override
                String getUsePrefix() {
                    return FixUsesPerformer.USE_FUNCTION_PREFIX;
                }
            };


            abstract String getUsePrefix();

            static Type create(ImportData.ItemVariant.Type type) {
                Type result;
                switch (type) {
                    case CLASS: 
                    case INTERFACE: 
                    case TRAIT: {
                        result = TYPE;
                        break;
                    }
                    case CONST: {
                        result = CONST;
                        break;
                    }
                    case FUNCTION: {
                        result = FUNCTION;
                        break;
                    }
                    default: {
                        result = TYPE;
                    }
                }
                return result;
            }

            static Type create(UseScope.Type type) {
                Type result;
                switch (type) {
                    case TYPE: {
                        result = TYPE;
                        break;
                    }
                    case CONST: {
                        result = CONST;
                        break;
                    }
                    case FUNCTION: {
                        result = FUNCTION;
                        break;
                    }
                    default: {
                        result = TYPE;
                    }
                }
                return result;
            }
        }
    }

    private static class ExistingUseStatementVisitor
    extends DefaultVisitor {
        private final List<OffsetRange> usedRanges = new LinkedList<OffsetRange>();

        private ExistingUseStatementVisitor() {
        }

        public List<OffsetRange> getUsedRanges() {
            return Collections.unmodifiableList(this.usedRanges);
        }

        @Override
        public void visit(UseStatement node) {
            this.usedRanges.add(new OffsetRange(node.getStartOffset(), node.getEndOffset()));
        }
    }

    private static class SanitizedUse {
        private final UsePart usePartToSanitization;
        private String alias;
        private final boolean shouldBeUsed;

        public SanitizedUse(UsePart usePartToSanitization, List<UsePart> existingUseParts, AliasStrategy createAliasStrategy) {
            this.usePartToSanitization = usePartToSanitization;
            QualifiedName qualifiedName = QualifiedName.create(usePartToSanitization.getTextPart());
            if (!existingUseParts.contains(usePartToSanitization) && !usePartToSanitization.isFromAliasedElement()) {
                this.alias = createAliasStrategy.createAlias(qualifiedName);
                this.shouldBeUsed = true;
            } else {
                this.shouldBeUsed = false;
            }
        }

        public UsePart getSanitizedUsePart() {
            return new UsePart(this.hasAlias() ? this.usePartToSanitization.getTextPart() + FixUsesPerformer.AS_CONCAT + this.alias : this.usePartToSanitization.getTextPart(), this.usePartToSanitization.getType(), this.usePartToSanitization.isFromAliasedElement());
        }

        private boolean hasAlias() {
            return this.alias != null && !this.alias.isEmpty();
        }

        public String getReplaceName(UsedNamespaceName usedNamespaceName) {
            String result = this.hasAlias() ? this.alias : (this.usePartToSanitization.isFromAliasedElement() ? this.usePartToSanitization.getTextPart() : usedNamespaceName.getReplaceName());
            return result;
        }

        public boolean shouldBeUsed() {
            return this.shouldBeUsed;
        }
    }

    private static class UnqualifiedNameStrategy
    extends AliasStrategyImpl {
        public UnqualifiedNameStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            return qualifiedName.getName();
        }
    }

    private static class CapitalsStrategy
    extends AliasStrategyImpl {
        public CapitalsStrategy(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            StringBuilder sb = new StringBuilder();
            for (String segment : qualifiedName.getSegments()) {
                sb.append(Character.toUpperCase(segment.charAt(0)));
            }
            return sb.toString();
        }
    }

    private static abstract class AliasStrategyImpl
    implements AliasStrategy {
        private final int selectionIndex;
        private final List<UsePart> existingUseParts;
        private final List<ImportData.ItemVariant> selections;

        public AliasStrategyImpl(int selectionIndex, List<UsePart> existingUseParts, List<ImportData.ItemVariant> selections) {
            this.selectionIndex = selectionIndex;
            this.existingUseParts = existingUseParts;
            this.selections = selections;
        }

        @Override
        public String createAlias(QualifiedName qualifiedName) {
            String possibleAliasedName;
            String result = FixUsesPerformer.EMPTY_STRING;
            String newAliasedName = possibleAliasedName = this.getPossibleAliasName(qualifiedName);
            int i = 1;
            while (this.existSelectionWith(newAliasedName, this.selectionIndex) || this.existUseWith(newAliasedName)) {
                result = newAliasedName = possibleAliasedName + ++i;
            }
            return result.isEmpty() && this.mustHaveAlias(qualifiedName) ? possibleAliasedName : result;
        }

        private boolean mustHaveAlias(QualifiedName qualifiedName) {
            String unqualifiedName = qualifiedName.getName();
            return this.existSelectionWith(unqualifiedName, this.selectionIndex) || this.existUseWith(unqualifiedName);
        }

        private boolean existSelectionWith(String name, int selectionIndex) {
            boolean result = false;
            for (int i = selectionIndex + 1; i < this.selections.size(); ++i) {
                if (!this.endsWithName(this.selections.get(i).getName(), name)) continue;
                result = true;
            }
            return result;
        }

        private boolean existUseWith(String name) {
            boolean result = false;
            for (UsePart existingUsePart : this.existingUseParts) {
                if (!this.endsWithName(existingUsePart.getTextPart(), name) && !existingUsePart.getTextPart().endsWith(FixUsesPerformer.SPACE + name)) continue;
                result = true;
            }
            return result;
        }

        private boolean endsWithName(String usePart, String name) {
            return usePart.endsWith("\\" + name);
        }

        protected abstract String getPossibleAliasName(QualifiedName var1);
    }

    private static interface AliasStrategy {
        public String createAlias(QualifiedName var1);
    }
}

