/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PHPCodeTemplateProcessor
implements CodeTemplateProcessor {
    private static final String NEW_VAR_NAME = "newVarName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_NAME = "variableFromNextAssignmentName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE = "variableFromNextAssignmentType";
    private static final String VARIABLE_FROM_PREVIOUS_ASSIGNMENT = "variableFromPreviousAssignment";
    private static final String INSTANCE_OF = "instanceof";
    private static final RequestProcessor RP = new RequestProcessor(PHPCodeTemplateProcessor.class);
    private static final Logger LOGGER = Logger.getLogger(PHPCodeTemplateProcessor.class.getName());
    private static final int TIMEOUT = 500;
    private final CodeTemplateInsertRequest request;
    private ParserResult info;

    public PHPCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
    }

    public void updateDefaultValues() {
        for (CodeTemplateParameter param : this.request.getMasterParameters()) {
            String value = this.getProposedValue(param);
            if (value == null || value.equals(param.getValue())) continue;
            param.setValue(value);
        }
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
    }

    public void release() {
    }

    private String getNextVariableType() {
        List<? extends VariableName> variables;
        VariableName first;
        if (!this.initParsing()) {
            return null;
        }
        int offset = this.request.getComponent().getCaretPosition();
        Collection<? extends VariableName> declaredVariables = this.getDeclaredVariables(offset);
        String varName = this.getNextVariableName();
        if (varName == null || declaredVariables == null) {
            return null;
        }
        if (varName.charAt(0) != '$') {
            varName = "$" + varName;
        }
        if ((first = ModelUtils.getFirst(variables = ModelUtils.filter(declaredVariables, varName))) != null) {
            String typeNames = StringUtils.implode(this.getUniqueTypeNames(first, offset), (String)"|");
            if (!StringUtils.hasText((String)typeNames)) {
                return null;
            }
            return typeNames;
        }
        return null;
    }

    private String getProposedValue(CodeTemplateParameter param) {
        String def = null;
        boolean newVarName = false;
        boolean previousVariable = false;
        String type = null;
        for (Map.Entry entry : param.getHints().entrySet()) {
            String hintName;
            switch (hintName = (String)entry.getKey()) {
                case "default": {
                    assert (def == null) : "default already set to " + def;
                    def = param.getValue();
                    break;
                }
                case "newVarName": {
                    assert (!newVarName) : "newVarName already set";
                    newVarName = true;
                    break;
                }
                case "variableFromNextAssignmentName": {
                    return this.getNextVariableName();
                }
                case "variableFromNextAssignmentType": {
                    return this.getNextVariableType();
                }
                case "variableFromPreviousAssignment": {
                    assert (!previousVariable) : "previousVariable already set";
                    previousVariable = true;
                    break;
                }
                case "instanceof": {
                    assert (type == null) : "type already set to " + type;
                    type = (String)entry.getValue();
                    break;
                }
            }
        }
        if (newVarName) {
            return this.newVarName(def);
        }
        if (previousVariable) {
            return this.getPreviousVariable(type);
        }
        return null;
    }

    private String getNextVariableName() {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        VariableName var = null;
        Collection<? extends VariableName> allVariables = this.getDeclaredVariables(caretOffset);
        if (allVariables != null) {
            for (VariableName variableName : allVariables) {
                int oldDiff;
                if (var == null) {
                    var = variableName;
                    continue;
                }
                int newDiff = Math.abs(variableName.getNameRange().getStart() - caretOffset);
                if (newDiff >= (oldDiff = Math.abs(var.getNameRange().getStart() - caretOffset))) continue;
                var = variableName;
            }
        }
        return var != null ? var.getName().substring(1) : null;
    }

    private String getPreviousVariable(String type) {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        VariableName var = null;
        Collection<? extends VariableName> allVariables = this.getDeclaredVariables(caretOffset);
        if (allVariables != null) {
            for (VariableName variableName : allVariables) {
                int newDiff = variableName.getNameRange().getStart() - caretOffset;
                if (newDiff >= 0 || !this.hasType(variableName, caretOffset, type)) continue;
                if (var == null) {
                    var = variableName;
                    continue;
                }
                int oldDiff = var.getNameRange().getStart() - caretOffset;
                assert (oldDiff < 0);
                if (newDiff <= oldDiff) continue;
                var = variableName;
            }
        }
        return var != null ? var.getName() : null;
    }

    private boolean hasType(VariableName variableName, int offset, String type) {
        if (type == null) {
            return true;
        }
        return variableName.getTypeNames(offset).contains(type);
    }

    private List<String> getUniqueTypeNames(VariableName variableName, int offset) {
        ArrayList<String> uniqueTypeNames = new ArrayList<String>();
        for (TypeScope type : variableName.getTypes(offset)) {
            if (uniqueTypeNames.contains(type.getName())) continue;
            uniqueTypeNames.add(type.getName());
        }
        return uniqueTypeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newVarName(String proposed) {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        int suffix = 0;
        final String[] nue = new String[]{null};
        PHPCodeTemplateProcessor pHPCodeTemplateProcessor = this;
        synchronized (pHPCodeTemplateProcessor) {
            while (true) {
                nue[0] = proposed + (suffix > 0 ? String.valueOf(suffix) : "");
                Set<String> varInScope = ASTNodeUtilities.getVariablesInScope(this.info, caretOffset, new ASTNodeUtilities.VariableAcceptor(){

                    @Override
                    public boolean acceptVariable(String variableName) {
                        return nue[0].equals(variableName);
                    }
                });
                if (varInScope.isEmpty()) break;
                ++suffix;
            }
        }
        return nue[0];
    }

    private synchronized boolean initParsing() {
        if (this.info != null) {
            return true;
        }
        final Document doc = this.request.getComponent().getDocument();
        FileObject file = NavUtils.getFile(doc);
        if (file == null) {
            return false;
        }
        Future future = RP.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            PHPParseResult parserResult = (PHPParseResult)resultIterator.getParserResult();
                            if (parserResult != null) {
                                PHPCodeTemplateProcessor.this.info = parserResult;
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    PHPCodeTemplateProcessor.this.info = null;
                }
            }
        });
        try {
            future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Getting of parser result has been interrupted.");
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, "Exception has been thrown during getting of parser result.", ex);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.FINE, "Timeout for getting parser result has been exceed: {0}", 500);
        }
        return this.info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends VariableName> getDeclaredVariables(int caretOffset) {
        if (!this.initParsing()) {
            return null;
        }
        PHPCodeTemplateProcessor pHPCodeTemplateProcessor = this;
        synchronized (pHPCodeTemplateProcessor) {
            Model model = ((PHPParseResult)this.info).getModel();
            VariableScope varScope = model.getVariableScope(caretOffset);
            if (varScope != null) {
                return varScope.getDeclaredVariables();
            }
            return null;
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new PHPCodeTemplateProcessor(request);
        }
    }
}

