/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;

class CodeMarkerBuilder {
    private ASTNodeInfo currentNodeInfo;
    private Scope currentScope;
    private Map<ASTNodeInfo<ReturnStatement>, Scope> returnStatements = new HashMap<ASTNodeInfo<ReturnStatement>, Scope>();
    private HashMap<MethodDeclarationInfo, Scope> methodDeclarations = new HashMap();
    private HashMap<FunctionDeclarationInfo, Scope> fncDeclarations = new HashMap();

    CodeMarkerBuilder() {
    }

    void prepare(FunctionDeclaration node, Scope scope) {
        FunctionDeclarationInfo nodeInfo = FunctionDeclarationInfo.create(node);
        if (this.canBePrepared(node, scope)) {
            this.fncDeclarations.put(nodeInfo, scope);
        }
    }

    void prepare(MethodDeclaration node, Scope scope) {
        if (scope instanceof MethodScope && scope.getInScope() instanceof TypeScope) {
            MethodDeclarationInfo nodeInfo = MethodDeclarationInfo.create(node, (TypeScope)scope.getInScope());
            if (this.canBePrepared(node, scope)) {
                this.methodDeclarations.put(nodeInfo, scope);
            }
        }
    }

    void prepare(ReturnStatement returnStatement, Scope scope) {
        ASTNodeInfo<ReturnStatement> nodeInfo = ASTNodeInfo.create(returnStatement);
        if (this.canBePrepared(returnStatement, scope)) {
            this.returnStatements.put(nodeInfo, scope);
        }
    }

    void setCurrentContextInfo(int offset) {
        ArrayList<LazyBuild> scopesToScan = new ArrayList<LazyBuild>();
        for (Map.Entry<MethodDeclarationInfo, Scope> entry : this.methodDeclarations.entrySet()) {
            if (entry.getValue() instanceof LazyBuild) {
                LazyBuild scope = (LazyBuild)((Object)entry.getValue());
                scopesToScan.add(scope);
            }
            this.setOccurenceAsCurrent(entry.getKey(), entry.getValue(), offset);
        }
        for (LazyBuild lazyBuild : scopesToScan) {
            if (lazyBuild.isScanned()) continue;
            lazyBuild.scan();
        }
        for (Map.Entry<ASTNodeInfo, Scope> entry : this.fncDeclarations.entrySet()) {
            this.setOccurenceAsCurrent(entry.getKey(), entry.getValue(), offset);
        }
        for (Map.Entry<ASTNodeInfo, Scope> entry : this.returnStatements.entrySet()) {
            this.setOccurenceAsCurrent(entry.getKey(), entry.getValue(), offset);
        }
    }

    private void buildFunctionDeclarations(FileScopeImpl fileScope) {
        String scopeName = this.currentScope.getName();
        for (Map.Entry<FunctionDeclarationInfo, Scope> entry : this.fncDeclarations.entrySet()) {
            Scope scope = entry.getValue();
            FunctionDeclarationInfo nodInfo = entry.getKey();
            if (!scopeName.equalsIgnoreCase(scope.getName())) continue;
            FunctionDeclaration function = (FunctionDeclaration)nodInfo.getOriginalNode();
            Identifier functionName = function.getFunctionName();
            OffsetRange range = new OffsetRange(function.getStartOffset(), functionName.getStartOffset());
            fileScope.addCodeMarker(new CodeMarkerImpl.InvisibleCodeMarker(range, fileScope));
        }
    }

    private void buildMethodDeclarations(FileScopeImpl fileScope) {
        String scopeName = this.currentScope.getName();
        for (Map.Entry<MethodDeclarationInfo, Scope> entry : this.methodDeclarations.entrySet()) {
            Scope scope = entry.getValue();
            Scope parentScope = scope.getInScope();
            Scope parentCurrentScope = this.currentScope.getInScope();
            MethodDeclarationInfo nodInfo = entry.getKey();
            if (!scopeName.equalsIgnoreCase(scope.getName()) || parentCurrentScope == null || parentScope == null || !parentCurrentScope.getName().equalsIgnoreCase(parentScope.getName())) continue;
            FunctionDeclaration function = ((MethodDeclaration)nodInfo.getOriginalNode()).getFunction();
            Identifier functionName = function.getFunctionName();
            OffsetRange range = new OffsetRange(function.getStartOffset(), functionName.getStartOffset());
            fileScope.addCodeMarker(new CodeMarkerImpl.InvisibleCodeMarker(range, fileScope));
        }
    }

    private void buildReturnStatement(FileScopeImpl fileScope) {
        String scopeName = this.currentScope.getName();
        for (Map.Entry<ASTNodeInfo<ReturnStatement>, Scope> entry : this.returnStatements.entrySet()) {
            Scope scope = entry.getValue();
            Scope parentScope = scope.getInScope();
            Scope parentCurrentScope = this.currentScope.getInScope();
            ASTNodeInfo<ReturnStatement> nodInfo = entry.getKey();
            if (!scopeName.equalsIgnoreCase(scope.getName()) || parentCurrentScope == null || parentScope == null || !parentCurrentScope.getName().equalsIgnoreCase(parentScope.getName())) continue;
            fileScope.addCodeMarker(new CodeMarkerImpl(nodInfo, fileScope));
        }
    }

    void build(FileScopeImpl fileScope, int offset) {
        if (this.currentNodeInfo == null && offset >= 0) {
            this.setCurrentContextInfo(offset);
        }
        if (this.currentNodeInfo != null && this.currentScope != null) {
            ASTNodeInfo.Kind kind = this.currentNodeInfo.getKind();
            this.currentNodeInfo = null;
            switch (kind) {
                case FUNCTION: {
                    this.buildFunctionDeclarations(fileScope);
                    this.buildReturnStatement(fileScope);
                    break;
                }
                case STATIC_METHOD: 
                case METHOD: {
                    this.buildMethodDeclarations(fileScope);
                    this.buildReturnStatement(fileScope);
                    break;
                }
                case RETURN_MARKER: {
                    this.buildMethodDeclarations(fileScope);
                    this.buildFunctionDeclarations(fileScope);
                    this.buildReturnStatement(fileScope);
                    break;
                }
                default: {
                    throw new IllegalStateException(kind.toString());
                }
            }
        }
    }

    private boolean canBePrepared(ASTNode node, ModelElement scope) {
        return scope != null && node != null;
    }

    private void setOccurenceAsCurrent(ASTNodeInfo nodeInfo, Scope scope, int offset) {
        OffsetRange range = nodeInfo.getRange();
        Object originalNode = nodeInfo.getOriginalNode();
        if (originalNode instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)originalNode;
            Expression expression = returnStatement.getExpression();
            if (expression != null) {
                range = new OffsetRange(returnStatement.getStartOffset(), expression.getStartOffset());
            }
        } else if (originalNode instanceof MethodDeclaration) {
            FunctionDeclaration function = ((MethodDeclaration)originalNode).getFunction();
            Identifier functionName = function.getFunctionName();
            range = new OffsetRange(function.getStartOffset(), functionName.getStartOffset());
        } else if (originalNode instanceof FunctionDeclaration) {
            FunctionDeclaration function = (FunctionDeclaration)originalNode;
            Identifier functionName = function.getFunctionName();
            range = new OffsetRange(function.getStartOffset(), functionName.getStartOffset());
        }
        if (range.containsInclusive(offset)) {
            this.currentNodeInfo = nodeInfo;
            this.currentScope = scope;
        }
    }
}

